<?php
/**
 * Extension Name: Clients
 * Extension URI: http://themearabia.net/extension/clients
 * license: free
 * Version: 2.0
 * Requires: 5.0
 * Description: clients
 * Author: Themearabia
 * Author URI: http://themearabia.net
*/

if (!class_exists('extensions_clients')) {
    class extensions_clients
    {
        protected $veiwdir      = 'posts.clients';
        protected $ex_id        = 'clients';
        protected $ex_type      = 'clients';
        protected $option_name  = 'options_clients';
        protected $path         = '';
        protected $ex_url       = '';
        protected $ex_lang      = 'clients';
        protected $ex_icon      = 'bx bx-heart';
        protected $ex_order     = '65';

        /**
         * __construct()
         */
        function __construct()
        {
            $this->path     = extension_path($this->ex_id);
            $this->ex_url   = extension_url($this->ex_id);
            $this->options  = maybe_unserialize(get_option($this->option_name));
            if(is_admin()){
                Eventy::addAction('admin_dashboard_counter', [$this, 'admin_dashboard_counter'], $this->ex_order, 1);
                Eventy::addAction('admin_sidebar_menu', [$this, 'admin_sidebar_menu'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_identifier_types', [$this, 'supports_post_type'], $this->ex_order, 1);
                Eventy::addFilter('admin_permissions_args', [$this, 'admin_permissions_args'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_newpost_'.$this->ex_type, [$this, 'filter_newpost'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_editpost_'.$this->ex_type, [$this, 'filter_editpost'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_homepage_options', [$this, 'widgets_homepage_options'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_options_clients', [$this, 'widgets_options_clients_echo'], $this->ex_order, 1);
                Eventy::addFilter('action_widgets_options_clients', [$this, 'widgets_options_clients'], $this->ex_order, 1);
            }
            else {
                Eventy::addFilter('widgets_homepage_start', [$this, 'widgets_homepage_start'], $this->ex_order, 1);
                Eventy::addFilter('widgets_homepage_data_clients', [$this, 'filter_data_home'], $this->ex_order, 1);
            }
        }

        /**
         * filter_data_home($data = [])
         */
        public function filter_data_home($data = [])
        {
            if(is_extensions('clients'))
            {
                $default_options['widgetid']        = 'clients';
                $default_options['title']           = '';
                $default_options['description']     = '';
                $default_options['more_button']     = false;
                $default_options['more_icon']       = '';
                $default_options['more_txt']        = '';
                $default_options['more_url']        = false;
                $default_options['bgclass']         = 'bg_white';
                $default_options['bgattachment']    = 'fixed';
                $default_options['bgrepeat']        = 'no_repeat';
                $default_options['bgsize']          = 'cover';
                $default_options['image']           = false;
                $default_options['image_style']     = '';
                $default_options['style']           = 'normal';
                $default_options['column']          = 'col-md-3';
                $default_options['owlrespc']        = '6';
                $default_options['owlrestablet']    = '4';
                $default_options['owlresphone']     = '2';
                $default_options['limit']           = 8;
                $options = mega_parse_args($data, $default_options);
                $newdata = [];
                $options['bgclass'] = (in_array($options['bgclass'], ['bg_black', 'bg_color']))? $options['bgclass'].' title-white' : $options['bgclass'];
                if($options['bgclass'] == 'bg_img')
                {
                    $options['bgclass'] = 'bg-image title-white '.$options['bgattachment'].' '.$options['bgrepeat'].' '.$options['bgsize'];
                    $options['image_style'] = ' style="background-image: url('.$options['image'].')"';
                }
                $newdata['options'] = $options;
                $newdata['column']  = $options['column'];
                $newdata['clients'] = $this->get_query()->limit($options['limit'])->get();
                return $newdata;
            }
            else
            {
                return $data;
            }
        }
        /**
         * get_query()
         */
        public function get_query()
        {
            $query = DB::table('posts')
            ->leftJoin('postsmeta as client_url', function ($join) {$join->on('client_url.post_id', '=', 'posts.id')->where('client_url.meta_key', '=', 'client_url');})
            ->leftJoin('postsmeta as thumbnails', function ($join) {$join->on('thumbnails.post_id', '=', 'posts.id')->where('thumbnails.meta_key', '=', 'thumbnails');})
            ->selectRaw(
                db_select_column_as('posts', 'post_title').
                db_select_column_as('posts', 'post_name').
                db_select_column_as('posts', 'id').
                db_select_column_as('client_url', 'meta_value', 'client_url').
                db_select_column_as('client_url', 'meta_value', 'client_url').
                db_select_column_as('thumbnails', 'meta_value', 'thumbnail', '')
            )
            ->where(['post_type' => $this->ex_type, 'post_status' => '1'])
            ->orderBy('post_orders', 'ASC')
            ->orderBy('post_modified', 'DESC');
            return $query;
        }

        /**
         * widgets_homepage_options($value)
         */
        public function widgets_homepage_options($value)
        {
            $options = [
                'clients' => [
                    'title' => extension_lang($this->ex_lang, 'clients'), 
                    'option' => 'clients'
                ]
            ];
            echo foreach_widgets_homepage_options($options, $value, extension_lang($this->ex_lang, 'clients'));
        }

        /**
         * widgets_options_clients()
         */
        public function widgets_options_clients($data)
        {
            $style          = (isset($data['widget']['style']))? $data['widget']['style'] : 'normal';
            $limit          = (isset($data['widget']['limit']))? $data['widget']['limit'] : 8;
            $column         = (isset($data['widget']['column']))? $data['widget']['column'] : 'col-md-3';
            $owlrespc       = (isset($data['widget']['owlrespc']))? $data['widget']['owlrespc'] : '6';
            $owlrestablet   = (isset($data['widget']['owlrestablet']))? $data['widget']['owlrestablet'] : '4';
            $owlresphone    = (isset($data['widget']['owlresphone']))? $data['widget']['owlresphone'] : '2';
            $option_style = ['id' => $data['option_name'].'['.$data['key'].'][style]', 'box_class' => 'form-group', 'name' => admin_lang('style'), 'value' => $style, 'options' => [
                'normal' => admin_lang('normal'),
                'owlcarousel' => 'Owl Carousel',
            ]];
            $option_column = ['id' => $data['option_name'].'['.$data['key'].'][column]', 'box_class' => 'form-group', 'name' => admin_lang('column'), 'value' => $column, 'options' => [
                'col-md-2' => '6 '.admin_lang('column'),
                'col-md-3' => '4 '.admin_lang('column'), 
                'col-md-4' => '3 '.admin_lang('column'), 
                'col-md-6' => '2 '.admin_lang('column')
            ]];
            $option_limit = ['id' => $data['option_name'].'['.$data['key'].'][limit]', 'box_class' => 'form-group', 'name' => admin_lang('post_per_page'), 'value' => $limit, 'min' => '1', 'max' => '32', 'step' => '1'];
            $options_owlres = ['type' => 'input_group','name' => 'Owl Responsive', 'box_class' => 'form-group', 'box_class2' => 'd-flex', 'class' => 'text-center', 'grouptext' => admin_lang('items'), 'options' => [
                ['id' => $data['option_name'].'['.$data['key'].'][owlrespc]', 'type' => 'number' ,'value' => $owlrespc, 'grouptext' => '<i class="fas fa-laptop"></i>'],
                ['id' => $data['option_name'].'['.$data['key'].'][owlrestablet]', 'type' => 'number', 'value' => $owlrestablet, 'grouptext' => '<i class="fas fa-tablet-alt"></i>'],
                ['id' => $data['option_name'].'['.$data['key'].'][owlresphone]', 'type' => 'number', 'value' => $owlresphone, 'grouptext' => '<i class="fas fa-mobile-alt"></i>'],
            ]];
            return '
            <div class="row">
                <div class="col-md-6">
                    '.field_radio_input($option_style, false).'
                </div>
                <div class="col-md-6">
                    '.field_radio_input($option_column, false).'
                </div>
                <div class="col-md-6">
                    '.field_text_input_group($options_owlres, false).'
                </div>
                <div class="col-md-6">
                    '.field_slider_number_input($option_limit, false).'
                </div>
            </div>
            ';
        }

        /**
         * widgets_options_clients_echo($data)
         */
        public function widgets_options_clients_echo($data)
        {
            echo $this->widgets_options_clients($data);
        }

        /**
         * widgets_homepage_start($value)
         */
        public function widgets_homepage_start($arg)
        {
            $support = [
                'clients'    => 'widgets.widget_clients'
            ];
            return mega_parse_args( $support, $arg );
        }

        /**
         * supports_post_type($arg)
         */
        public function supports_post_type($arg = [])
        {
            $support = [$this->ex_type => ['slug' => $this->ex_type]];
            return mega_parse_args( $support, $arg );
        }

        /**
         * admin_permissions_args($arg = [])
         */
        public function admin_permissions_args($arg = [])
        {
            $permission = [
                $this->ex_id  => [
                    'title' => extension_lang($this->ex_lang, 'clients'), 
                    'permission' => [
                        $this->ex_type => extension_lang($this->ex_lang, 'clients'),
                    ]
                ]
            ];
            return mega_parse_args( $permission, $arg );
        }

        /**
         * admin_dashboard_counter()
         */
        public function admin_dashboard_counter()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'count'     => get_post_count($this->ex_type),
                'title'     => extension_lang($this->ex_lang, 'clients'),
            ];
            echo get_admin_view('hooks.admin_dashboard_counter', $data)->render();
        }

        /**
         * admin_sidebar_menu()
         */
        public function admin_sidebar_menu()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'badge'     => false,
                'title'     => extension_lang($this->ex_lang, 'clients'),
                'submenu'   => [
                    ['title' => extension_lang($this->ex_lang, 'clients'), 'url' => get_admin_url('posts/'.$this->ex_type), 'badge' => ''],
                    ['title' => admin_lang('add_new'), 'url' => get_admin_url('postnew/'.$this->ex_type), 'badge' => '']
                ]
            ];
            if(is_permission($this->ex_type)){
                echo get_admin_view('hooks.admin_sidebar_menu', $data)->render();
            }
        }

        /**
         * filter_newpost($arg)
         * arg = ['data', 'request']
         * data = ['type', 'post_id']
         */
        public function filter_newpost($arg = [])
        {
            $data['client_url'] = '#';
            return $data;
        }

        /**
         * filter_editpost($arg)
         * arg = ['data', 'request']
         * data = ['type', 'post_id']
         */
        public function filter_editpost($arg = [])
        {
            $newdata['client_url'] = get_post_meta('client_url', $arg['post_id'], '');
            return array_merge( $newdata, (array) $arg );
        }

    }

    new extensions_clients();
}
