<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\City;
use App\Models\Area;
use App\Models\State;
use App\Models\Country;
use App\Models\Utility;
use App\Models\Property;
use App\Models\Pincode;
use PHPUnit\Framework\Constraint\Count;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use App\Models\estate;
use App\Http\Requests\PropertyRequest;


class PropertyController extends Controller
{
    private $url_prefix;
    private $page_title;
    private $url_new;
    private $btn_new;
    private $paginate;

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->url_prefix   = 'Property';
        $this->page_title   = 'Property';
        $this->btn_new      = 'add_new';
        $this->url_new      = get_admin_url('propertyadd');
        $this->paginate     = 5;
    }
    //Property index
    public function index_property($type = '',Request $request)
    {
       
        $data['type']       = 'users';
        $data['page_class'] = 'Property';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
        //if ($request->has('page') and $request->get('page') > $country->lastPage()) {return redirect($country->url($country->lastPage()));}
        
        $country=Country::where('country_code','=','IN')->first();
        $state = [];
        $estate=estate::all();
        $city=City::all();
       
        $area=Area::all();
        $property=Property::all();
        if(!empty($country))
            $state=State::select('id','state_name')->where('country_id','=',$country->id)->get();
       
        return get_admin_view('property.index_property',["data"=> $data,"property_data"=>$property,"states"=>$state,"citys"=>$city,"areas"=>$area,"estates"=>$estate ]);
    }

    public function ajaxlist_property(Request $request){
    
        if($request->ajax())
        {
            $data['type']       = 'users';
            $data['page_class'] = 'property';
            $data['url_prefix'] = $this->url_prefix;
            $data['page_title'] = $this->page_title;
            $data['btn_new']    = $this->btn_new;
            $data['url_new']    = $this->url_new;
            
         
            $property = Property::orderBy('created_at', 'DESC');
            $estate=estate::all();
            $city=City::all();
            $state=State::all();
            $area=Area::all();
          

            if($request->get('s')){
                $search = $request->get('s');
                 $property->where(function ($query)use($search) {

                    
                    $query->Where('tenament_no', 'LIKE', '%' .$search. '%')
                        ->orWhere('survey_no', 'LIKE', '%' .$search. '%')
                        ->orWhere('area_id', 'LIKE', '%' .$search. '%')
                        ->orWhere('city_id', 'LIKE', '%' .$search. '%')
                        ->orWhere('rental_type', 'LIKE', '%' .$search. '%')
                        ->orWhere('current_rate', 'LIKE', '%' .$search. '%')
                        ->orWhere('property_type', 'LIKE', '%' .$search. '%')
                        ->orWhere('attribute', 'LIKE', '%' .$search. '%')
                        ->orWhere('last_rent_paid', 'LIKE', '%' .$search. '%');
                    });
              
            }

            if($request->has('estate_name') and !empty($request->input('estate_name'))){
                $estate=$request->input('estate_name');
        
                $property=Property::with(["estate"=>function($q) 
                {
                 
                }])
                ->whereHas('estate', function ($query) use($estate) {
                    $query->when($estate, function ($q) use($estate){ 
                         $q->where('estate_id','LIKE','%'.$estate.'%');
                            
                        });
                   
                });    
        }

        if($request->has('city_name') and !empty($request->input('city_name'))){
            $city=$request->input('city_name');
    
            $property=Property::with(["city"=>function($q) 
            {
             
            }])
            ->whereHas('city', function ($query) use($city) {
                $query->when($city, function ($q) use($city){ 
                     $q->where('city_id','LIKE','%'.$city.'%');
                        
                    });
               
            });    
     }

    if($request->has('area_name') and !empty($request->input('area_name'))){
        $area=$request->input('area_name');

        $property=Property::with(["area"=>function($q) 
        {
         
        }])
        ->whereHas('area', function ($query) use($area) {
            $query->when($area, function ($q) use($area){ 
                 $q->where('area_id','LIKE','%'.$area.'%');
                    
                });
           
        });    
        }

    if($request->has('rental_type') and !empty($request->input('rental_type'))){
        $rental=$request->input('rental_type');

         $property=Property::Where("rental_type",'=',$rental);
    }          
    if($request->has('property_type') and !empty($request->input('property_type'))){
        $propertytype=$request->input('property_type');

            $property=Property::Where("property_type",'=',$propertytype);
    }

            if($request->has('attribute') and !empty($request->input('attribute'))){
                $attribute=$request->input('attribute');
        
                $property=Property::Where("attribute",'=',$attribute);
            }
            
    
            $property = $property->paginate($this->paginate);
             if($request->has('page') and $request->get('page') > $property->lastPage()) {return redirect($property->url($property->lastPage()));}
            return get_admin_view('property.ajaxlist_property', ["data"=> $data,'propertys'=>$property]);
        }
        
       }

       public function autocom_pincode(Request $request){
        $pincod_data="";
       
        if(isset($request['keyword']) && $request['keyword'] != "") {
          $search =   $request['keyword'];
       
         $pincode= Pincode::where('pincode','LIKE','%'.$search.'%')->get();
        
         $pincod_data  .= "<ul id='country-list'>";
         
         
         foreach($pincode as $pincod_datas) {
           
           
            $pincod_data  .= "<li onClick='selectCountry($pincod_datas->pincode);'>$pincod_datas->pincode</li>";
            $pincod_data  .= "</ul>";   
        
         }
       }
       echo $pincod_data;exit;

       }
    

    public function property_profile($id =0, Request $request)
    {
   
        $curre_user = Auth::user();
       
        $user_id =  $curre_user->id;
   
        $property=Property::find($id);
     
        if($property){
        
        $getuser = User::find($user_id);
       
        if ($getuser->count()) {
           
            $type               = 'users';
            $user               = $getuser->first();
            $data['user']       = $user;
            $data['type']       = $type;
            $data['page_class'] = $type;
            $data['action']     = 'update';
            $data['page_title'] = 'Update Property';
            $data['user_meta']  = query_user_meta($data['user']->id);
        
            $datauser                   = $user;
            $data['user_userlevel']     = $curre_user->userlevel;
            $data['userlevel']          = $datauser->userlevel;
            $data['type']               = $datauser->userlevel;
            $data['page_class']         = $datauser->userlevel;
            $data['action']             = 'update';
            $data['userid']             = $datauser->id;
            $data['username']           = $datauser->username;
            $data['email']              = $datauser->email;
            $data['user_status']        = $datauser->status;
            $data['admin_language']     = get_user_meta('admin_language', $user_id, 'en');
            $permission                 = maybe_unserialize(get_user_meta('permission', $user_id, []));
            $data['user_permission']    = (is_array($permission))? $permission : [];
            
            $country=Country::all();
            $estate=estate::all();
            $city=City::all();
            $state=State::all();
            $area=Area::all();
            return get_admin_view('property.profile_property', ["data"=>$data,
            "property"=>$property,"states"=>$state,"estates"=>$estate,"countrys"=>$country,"citys"=>$city,"areas"=>$area]);


           
        }
    }
    }

    // index profile
    public function index_propertyadd(Request $request)
    {
        $user = Auth::user();
        
        $data['page_title']         = "Add Property";
        $type                       = 'users';
        $data['type']               = $type;
        $data['page_class']         = $type;
        $data['action']             = 'addnew';
        $data['user_userlevel']     = $user->userlevel;
        $data['userlevel']          = 'user';
        $data['user_vip']           = '0';
        $data['user_viptime']       = '';
        $data['userid']             = '0';
        $data['user_status']        = '1';
        $data['username']           = '';
        $data['email']              = '';
        $data['admin_language']     = 'en';
        $data['user_permission']    = [];
        $country=Country::all();
        $estate=estate::all();
        $city=City::all();
        return get_admin_view('property.property_edit', ['data'=>$data,
        "estates"=>$estate,"countrys"=>$country]);
 
    }

    // estate dropdown 
    public function estateDropdown(){
        $data = estate::all();
        return get_admin_view('property.property_form',['data'=>$data]);
    }

    // send form
    public function property_sendform(PropertyRequest $request)
    {

        $user = Auth::user();
    
        $userid = $request->get('userid');
        
        $property=Property::create([
        "estate_id"=>$request->input('estate_id'),
        "tenament_no"=>$request->input("tenament_no"),
        "paiki"=>$request->input('paiki'),
        "property_size"=>$request->input('property_size'),
        "survey_no"=>$request->input('survey_no'),
        "area_id"=>$request->input('area_id'),
        "city_id"=>$request->input('city_id'),
        "rental_type"=>$request->input('rental_type'),
        "current_rate"=>$request->input('current_rate'),
        "property_type"=>$request->input('property_type'),
        "attribute"=>$request->input('attribute'),
        "varsai"=>$request->input('varsai'),
        "hold"=>$request->input('hold'),
        "last_rent_paid"=>$request->input('last_rent_paid'),
        "electric_consumer_no"=>$request->input('electric_consumer_no'),
        "remarks"=>$request->input('remarks')
    ]);
        if($property){
            return redirect()->back()->with('success','Property '.$request->input('') . ' added Successfully!');
          }else{
            return redirect()->back()->with('failure', "Property ".$request->input('') . ' Not added');
          }
     
    
       // return redirect(get_admin_url('profile/'.$user_id))->with("success", $success);
    }


    // country,state,city,area fuction 

  
    // country,state,city,area fuction end

    // actions post
    public function property_actions(PropertyRequest $request)
    {
    
        if($request->has('query') && $request->get('query') == 'action')
        {
          
             if($request->get('action') == 'update')
            {
             
                $property=Property::find($request->input('id'));
                $property->estate_id = $request->input('estate_id');
                $property->tenament_no = $request->input('tenament_no');
                $property->paiki = $request->input('paiki');
                $property->property_size = $request->input('property_size');
                $property->survey_no = $request->input('survey_no');
                $property->area_id = $request->input('area_id');
                $property->city_id = $request->input('city_id');
                $property->rental_type = $request->input('rental_type');
                $property->current_rate = $request->input('current_rate');
                $property->property_type = $request->input('property_type');
                $property->attribute = $request->input('attribute');
                $property->varsai = $request->input('varsai');
                $property->hold = $request->input('hold');
                $property->last_rent_paid = $request->input('last_rent_paid');
                $property->electric_consumer_no = $request->input('electric_consumer_no');
                $property->remarks = $request->input('remarks');
                if($property->save()){
                    return redirect()->back()->with("success", "Property Updated successfully!");
                }else{
                    return redirect()->back()->with("failure", "Property Not Updated!");
                }
            }
   else{
            $marks = $request->get('mark');
             if(empty($marks)){
                return redirect()->back();
             }
             $items=count($marks);
             $faileditem=0;
             $success="";
            if($request->get('action') == 'delete' and is_array($marks))
            {
                $count=0;
                foreach($marks as $markid)
                {
                   $count=$count+1;
                   $success= Property::find($markid)->delete();
                   if(empty($success)){
                    $faileditem= $faileditem+1;
                   }
                }
                if(($success) && $items==$count ){
                    return redirect()->back()->with("success", "All selected Items are Deleted Successfully!");
                }
                else if(($success) && $faileditem!=0){
                    return redirect()->back()->with("failure","Selected Items are deleted except $faileditem property");
                }
                else{
                    return redirect()->back()->with("failure","Selected Items are not deleted");
                }
            }
         

            
        }
    }
    }
    // action enable post
   
     public function view_property($id,Request $request){
        $user = Auth::user();
        $property=Property::find($id);

        $data['page_title']         = "Add Property";
        $type                       = 'users';
        $data['type']               = $type;
        $data['page_class']         = $type;
        $data['action']             = 'addnew';
        $data['user_userlevel']     = $user->userlevel;
        $data['userlevel']          = 'user';
        $data['user_vip']           = '0';
        $data['user_viptime']       = '';
        $data['userid']             = '0';
        $data['user_status']        = '1';
        $data['username']           = '';
        $data['email']              = '';
        $data['admin_language']     = 'en';
        $data['user_permission']    = [];

        $country=Country::all();
        $estate=estate::all();
        $city=City::all();
        $state=State::all();
        $area=Area::all();
        return get_admin_view('property.property_edit', ['data'=>$data,"propertys"=>$property,"property_view"=>true,
        "estates"=>$estate,"countrys"=>$country,"citys"=>$city,"states"=>$state,"areas"=>$area]);

     }


    // action delete post
    public function index_deleteproperty($id, $token)
    { $property=Property::find($id);
      $propertyname=$property->property_name;
      $property=$property->delete();
      if($property){
        return redirect()->back()->with("success", "property $propertyname deleted Successfully!");
      }else{
        return redirect()->back()->with("failure", "property $propertyname deleted");
      }
    }


        

      //property ajaxlist_tabl
}



?>
