<?php
/**
 * Extension Name: Frequently Asked Questions
 * Extension URI: http://themearabia.net/extension/faqs
 * Version: 3.0
 * Requires: 5.0
 * Description: Frequently Asked Questions
 * Author: Themearabia
 * Author URI: http://themearabia.net
 */

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FaqsController extends Controller
{

    private $type;
    private $url;
    private $paginate;
    private $options;

    public function __construct()
    {
        parent::__construct();
        $this->type         = 'faqs';
        $this->url          = url('faqs');
        $default_options    = [
            "style"         => "left",
            "catelink"      => "off",
            "column"        => "1column",
            "post_per_page" => "10",
        ];
        $options        = maybe_unserialize(site_config('options_faqs'));
        $this->options  = mega_parse_args($options, $default_options);
        $this->paginate = $this->options['post_per_page'];
    }
    
    // index faq
    public function faqs($slug = false, Request $request)
    {
        if(!is_extensions('faqs')){
            return redirect(url('/'));
        }

        foreach($this->options as $key => $option){
            $data['faq_'.$key] = $option;
        }

        $data['post_type']      = $this->type;
        $data['sub_header']     = extension_lang('faqs', 'frequently_asked_questions');
        
        $posts = DB::table(POSTS_TABLE)->where(['post_status' => '1', 'post_type' => $this->type])->orderBy('post_modified', 'desc');

        if($slug) {
            $slug = utf8_uri_encode(safe_input($slug));
            $term = get_term_by_slug($slug, $this->type);
            if ($term->count()) {
                $get_term = $term->first();
                $data['the_term_id']    = $get_term->id;
                $data['the_cate_name']  = $get_term->name;
                $data['page_title']     = extension_lang('faqs', 'faqs').' - '.$get_term->name;
                $data['breadcrumbs'][]  = ['link' => url('faqs'), 'title' => extension_lang('faqs', 'faqs')];
                $data['breadcrumbs'][]  = ['link' => false, 'title' => $get_term->name];
                $posts = $posts->where(['term_id' => $get_term->id])->get();
            }
            else {
                return redirect($this->url);
            }
        }
        else {
            $data['the_term_id']    = false;
            $data['the_cate_name']  = false;
            $data['page_title']     = extension_lang('faqs', 'faqs');
            $data['breadcrumbs'][]  = ['link' => false, 'title' => extension_lang('faqs', 'faqs')];
            $posts = $posts->limit($this->paginate)->get();
        }

        $data['posts']      = $posts;

        $data['categories'] = DB::table('terms')
        ->leftJoin('posts', 'posts'.'.term_id', '=', 'terms'.'.id')
        ->selectRaw(
            db_select_column_as('terms', 'name').
            db_select_column_as('terms', 'slug').
            db_select_column_as('terms', 'id').
            db_select_column_as_count('posts', 'id', 'posts_count', '')
        )
        ->where(['type' => $this->type, 'status' => '1', 'post_status' => '1', 'post_type' => $this->type])
        ->groupBy('posts'.'.term_id')->orderBy('orders', 'asc')->get();
        
        return get_view('faqs.faqs', $data);
    }
}
