<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PropertyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'estate_id' => 'required',
            'tenament_no' => 'required',
            'paiki' => 'required',
            'property_size' => 'required',
            'survey_no' => 'required',
            'area_id' => 'required',
            'city_id' => 'required',
            'rental_type' => 'required',
            'current_rate' => 'required',
            'property_type' => 'required',
            'attribute' => 'required',
            'varsai' => 'required',
            'hold' => 'required',
            'last_rent_paid' => 'required',
            'electric_consumer_no' => 'required',
            'remarks' => 'required',
            

        ];
    }
    public function messages()
    {
        return [
            'estate_id.required' => 'Estate is required',
            'tenament_no.required' => 'Tenament No is required',
            'paiki.required' => 'Paiki is required',
            'property_size.required' => 'Property Size is required',
            'survey_no.required' => 'Survey No is required',
            'area_id.required' => 'Area is required',
            'city_id.required' => 'City is required',
            'rental_type.required' => 'Rental Type is required',
            'current_rate.required' => 'Current Rate is required',
            'property_type.required' => 'Property Type is required',
            'attribute.required' => 'Attribute is required',
            'varsai.required' => 'Varsai is required',
            'hold.required' => 'Hold is required',
            'last_rent_paid.required' => 'Last Rent Paid is required',
            'electric_consumer_no.required' => 'Electric Consumer No is required',
            'remarks.required' => 'Remarks is required',
           
        ];
    }
}
