<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;

class Bookmaster extends Model
{
    use HasFactory, Notifiable;
    protected $table="book_master";
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'book_no',
        'receipt_start',
        'receipt_end',   
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    public function deceased()
    {
        //first id should be relationship table and another id is dependent table 
        return $this->hasOne(Deceased::class ,'id', 'graveyard_id');
    }
}
