<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePropertyMasterTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('property_master', function (Blueprint $table) {
            $table->bigIncrements('id'); 
            $table->integer('estate_id')->nullable();            
            $table->string('tenament_no')->nullable();
            $table->string('paiki')->nullable();
            $table->double('property_size',15, 8)->nullable();
            $table->integer('survey_no')->nullable();
            $table->integer('area_id')->nullable();
            $table->integer('city_id')->nullable();
            $table->enum('rental_type', array('Residence','Commercial '))->nullable();
            $table->double('current_rate',15, 8)->nullable();
            $table->enum('property_type', array('Rent','Vacant'))->nullable();
            $table->enum('attribute',array('Masjid','Community hall','Open land','House','Shop','office','Institute'))->nullable();
            $table->enum('varsai', array('YES', 'NO'))->nullable();
            $table->enum('hold', array('YES', 'NO'))->nullable();
            $table->date('last_rent_paid')->nullable();
            $table->string('electric_consumer_no')->nullable();
            $table->text('remarks')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('upted_by')->nullable();            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('property_master');
    }
}
