@if(session()->has('success'))
     
       <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
       @php session()->forget('success')@endphp
       
       @elseif(session()->has('failure'))
       <div class="alert alert-warning alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('failure') }}</div>  
       @php session()->forget('failure')@endphp
   @endif

        <form class="form-horizontal" method="POST" action="{{ get_admin_url('BookmasterActions') }}">
            {{ csrf_field() }}
            <input type="hidden" name="query" value="action">
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="actionselect">
                        <select name="action" class="custom-select form-select custom-select-sm form-control form-control-sm" style="width: 150px;">
                            <option value="-1">{{admin_lang('bulk_actions')}}</option>
                            <option value="enable">{{admin_lang('enable')}}</option>
                            <option value="disable">{{admin_lang('disable')}}</option>
                            <option value="delete">{{admin_lang('delete')}}</option>
        
                        </select>
                        <input type="submit" class="btn btn-sm btn-primary" value="{{admin_lang('apply')}}" onclick="return confirm(\'{{admin_lang('apply_confirm')}}\');">
                    </div>
                </div>
                <div class="col-md-8 align-right">
                    <a href="{{ $data['url_new'] }}" class="btn btn-sm btn-primary">{{admin_lang('add_new')}}</a>
                </div>
            </div>
            <table id="jq-table" class="table table-striped table-bordered countrytable">
                <thead>
                    <tr>
                        <th style="width: 15px;" class="text-center th-checkbox">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="selectall" />
                                <label class="custom-control-label" for="selectall"></label>
                            </div>
                        </th>
                        <th class="hidden-phone text-center">Book Number</th>
                        <th class="hidden-phone text-center">Receipt Start</th>
                        <th class="hidden-phone text-center">Receipt End</th>
                        <th class="hidden-phone text-center">Created Date</th>

                        @action('admin_users_th')
                      
                
                    </tr>
                </thead>
                <tbody >

         
                
       @foreach($bookmasters as $key => $bookmaster)
        
                    <tr>
                        <td class="td-checkbox  ">
                        
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="mark[]" value="{{$bookmaster->id}}" "select"/>                                        
                                <label class="custom-control-label" select></label>
                            </div>                          
                        </td>
                        <td class="text-center">
                        <strong><a href="{{get_admin_url('bookmaster/'.$bookmaster->id)}}">{{ $bookmaster->book_no }}</a></strong>   
                        <div class="row-actions">

                        <a href="{{get_admin_url('bookmaster/'.$bookmaster->id)}}" class="green">Edit</a>
                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#confirm-delete" data-href="{{ get_admin_url('deletebookmaster/'.$bookmaster->id.'/'.csrf_token() ) }}" data-body="{{ admin_lang('delete_confirm') }} # {{ $bookmaster->book_no }}?" class="red">{{ admin_lang('delete') }}</a>
                                
                            </div>
                        </td>
                        <td class="text-center">
                        <strong><a href="{{get_admin_url('bookmaster/'.$bookmaster->id)}}">{{ $bookmaster->receipt_start }}</a></strong>   
                        </td>
                        <td class="text-center">
                        <strong><a href="{{get_admin_url('bookmaster/'.$bookmaster->id)}}">{{ $bookmaster->receipt_end }}</a></strong>   
                        </td>
                        <td class="text-center">
                        <strong><a href="{{get_admin_url('bookmaster/'.$bookmaster->id)}}">{{ $bookmaster->created_at }}</a></strong>   
                        </td>
                        
</tr>
                     
                    @endforeach 
                    </tbody>
            </table>
        </form>
                    {{$bookmasters->links('dashboard.layouts.pagination')}}
                
