@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $page_title }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            @if($sub_page_title)
            <li class="breadcrumb-item"><a href="{{ get_admin_url('comments') }}">{{ admin_lang('comments') }}</a></li>
            <li class="breadcrumb-item active">{{ $sub_page_title }}</li>
            @else
            <li class="breadcrumb-item active">{{ $page_title }}</li>
            @endif
        </ol>
    </div>
</div>
<div class="row mb-3">
    <div class="col-md-3 data-tables-filter">
        <form method="GET" action="" class="form-filter">
            <input type="search" name="s" class="form-control form-control-sm" value="{{request()->get('s')}}" placeholder="{{admin_lang('search')}}">
            <button type="submit" class="btn btn-sm btn-primary button-form-filter">{{admin_lang('search')}}</button>
        </form>
    </div>
    <div class="col-md-6"></div>
</div>
@if(session()->has('success'))
<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{!! session()->get('success') !!}</div>
@endif
<div class="card">
    <div class="card-body">
        <form class="form-horizontal" method="POST" action="{{ get_admin_url('CommentsActions') }}">
            {{ csrf_field() }}
            <input type="hidden" name="query" value="action">
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="actionselect">
                        <select name="action" class="custom-select form-select custom-select-sm form-control form-control-sm" style="width: 150px;">
                            <option value="-1">{{admin_lang('bulk_actions')}}</option>
                            <option value="unapprove">{{admin_lang('unapproved')}}</option>
                            <option value="approve">{{admin_lang('approve')}}</option>
                            <option value="delete">{{admin_lang('delete')}}</option>
                        </select>
                        <input type="submit" class="btn btn-sm btn-primary" value="{{admin_lang('apply')}}" onclick="return confirm(\'{{admin_lang('apply_confirm')}}\');">
                    </div>
                </div>
                <div class="col-md-4">

                </div>
                <div class="col-md-4 data-tables-filter">
                    
                </div>
            </div>
            <table id="jq-table" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th style="width: 15px;" class="text-center th-checkbox">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="selectall" />
                                <label class="custom-control-label" for="selectall"></label>
                            </div>
                        </th>
                        <th class="hidden-phone">{{admin_lang('author')}}</th>
                        <th style="width: 60%">{{admin_lang('comment')}}</th>
                        <th style="width: 80px;" class="hidden-phone text-center">{{admin_lang('date')}}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($comments as $comment)
                    <tr>
                        <td class="td-checkbox">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="mark[]" value="{{ $comment->cid }}" id="select-{{ $comment->cid }}" />                                        
                                <label class="custom-control-label" for="select-{{ $comment->cid }}"></label>
                            </div>
                            @if($comment->cstatus)<span class="sq-post-status disable"></span>@else<span class="sq-post-status enable"></span>@endif
                            <div>#{{$comment->cid}}</div>
                        </td>
                        <td>
                            <div class="avatar2"><img src="@if($comment->cuid){{get_user_avatar($comment->cuid)}}@else{{get_user_avatar_username($comment->cuname)}}@endif" alt="@if($comment->cuid){{ get_username($comment->cuid) }}@else{{$comment->cuname}}@endif"></div>
                            <ul class="tdul-list">
                                <li>
                                    <h6>@if($comment->cuid)<a href="{{get_admin_url('profile/'.$comment->cuid)}}">{{ get_username($comment->cuid) }}</a>@else{{$comment->cuname}}@endif</h6>
                                    <h6 class="mb-1"><a href="mailto:{{$comment->cuemail}}">{{$comment->cuemail}}</a></h6>
                                </li>
                                <li>
                                    <small>
                                        <a href="{{get_admin_url('comments/ip/'.$comment->ip)}}">{{$comment->ip}}</a> | 
                                        <a href="{{get_admin_url('comments/platfrom/'.$comment->platformname)}}">{{$comment->platformname}}</a> | 
                                        <a href="{{get_admin_url('comments/browser/'.$comment->browserfamily)}}">{{$comment->browserfamily}}</a>
                                    </small>
                                </li>
                            </ul>
                        </td>
                        <td>
                            <h6>{!!get_post_title_from_comment($comment->cpid, $comment->ctype)!!}</h6>
                            <p>{!! nl2br($comment->ccontent) !!}</p>
                            <div class="row-actions">
                                <a href="{{ get_admin_url('editcomment/'.$comment->cid) }}">{{admin_lang('edit')}}</a> | 
                                @if($comment->cstatus)
                                <a href="{{ get_admin_url('disablecomment/'.$comment->cid) }}" class="red">{{admin_lang('unapproved')}}</a> |
                                @else
                                <a href="{{ get_admin_url('enablecomment/'.$comment->cid) }}" class="green">{{admin_lang('approve')}}</a> |
                                @endif
                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#confirm-delete" data-href="{{ get_admin_url('deletecomment/'.$comment->cid.'/'.csrf_token() ) }}" data-body="{{ admin_lang('delete_confirm') }} # {{ $comment->cid }}?" class="red">{{ admin_lang('delete') }}</a>
                            </div>
                        </td>
                        <td class="hidden-phone text-center" dir="ltr">{{ time_format($comment->cmodified, 'date', 'd/m/Y') }}<br />{{ time_format($comment->cmodified, 'time') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </form>
        {{$comments->links('dashboard.layouts.pagination')}}
    </div>
</div>
@endsection