@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $data['page_title'] }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{get_admin_url('/')}}">{{admin_lang('dashboard')}}</a></li>
            <li class="breadcrumb-item active"> <a href="{{ get_admin_url('country') }}">{{ $data['page_title'] }}</a></li>
        </ol>
    </div>
</div>
      @if(session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
            @elseif(session()->has('failure'))
            <div class="alert alert-warning alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('failure') }}</div>
   @endif
    <div class="card">
    <div class="card-body">
<form method="POST" action="{{ get_admin_url('CountryActions') }}" class="form-horizontal" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="action" value="{{$data['action']}}">
    <input type="hidden" name="query" value="action">
    <input type="hidden" name="id" value="{{$country->id}}">
    <div class="row">
        
         <div class="col-md-5">   
        <div class="form-group required">
         <label class="control-label">Country Name</label><br>
        <input type="text" name="country_name" id="country_name" class="form-control col-md-6" placeholder="CountryName" value="{{$country->country_name}}" >       
        </div>
    </div>
       
            <div class="col-md-5">
        <div class="form-group required">
         <label class="control-label">Country Name[Gujarati]</label><br>
        <input type="text" name="country_name_gj" id="country_name_gj" class="form-control col-md-6" placeholder="દેશનું નામ"  value="{{$country->country_name_gj}}">       
        </div>
    </div>

            <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Country Code</label><br>
        <input type="text" name="country_code" id="country_code" class="form-control col-md-6" placeholder="CountryCode eg +91" value="{{$country->country_code}}">       
        </div>
        </div>
</div>

        <div class="form-group mt-2">
        <button type="submit" class="btn btn-primary"><span></span>Update</button>
        <a href="{{get_admin_url('country')}}" class="btn btn-danger"><span></span>Cancel</a>
    </div>
        
          
</form>
</div>
</div>
@section('script_code')
<script>
$(document).ready(function () {
    loadGujarati('country_name_gj');
});
</script>
@endsection
@endsection