@extends('dashboard.layouts.master')
@section('content')
@include('dashboard.posts.boxs.box_page_head')
<form method="POST" action="{{ get_admin_url('PostSendForm') }}" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="post_type" value="{{$type}}">
    <input type="hidden" name="action" value="{{$action}}" />
    <input type="hidden" name="post_id" value="{{$post_id}}" />
    @include('dashboard.posts.boxs.box_publish_toolbar')
    @include('dashboard.posts.inputs.input_title')
    @include('dashboard.posts.inputs.input_postname')
    <div class="tacf-box-container">
        <div class="tacf-box-tabs nav-tabs-cookie" data-cookie="formpost_{{$type}}" data-cookie-tab="tab-details">
            <a href="#" class="active" data-tab=".tab-details"><i class="bx bx-pencil"></i> {{ admin_lang('details') }}</a>
            <a href="#" class="" data-tab=".tab-content"><i class="bx bx-file"></i> {{ admin_lang('content') }}</a>
            <a href="#" class="" data-tab=".tab-seo"><i class="bx bx-search-alt"></i> {{admin_lang('seo')}}</a>
            @if($action == 'update' and is_permission('comments'))<a href="#" class="" data-tab=".tab-comments"><i class="bx bx-comment-dots"></i> {{admin_lang('comments')}}</a>@endif
        </div>
        <div class="tacf-tabs-content">
            <div class="tacf-tab-content tab-details active">
                <div class="row">
                    <div class="col-md-5">
                        @include('dashboard.posts.inputs.input_categories')
                        <div class="row">
                            <div class="col-md-4">@include('dashboard.posts.inputs.input_orders')</div>
                            <div class="col-md-4">@include('dashboard.posts.inputs.input_comment_status')</div>
                            <div class="col-md-4">@include('dashboard.posts.inputs.input_post_pin')</div>
                        </div>
                    </div>
                    <div class="col-md-7">
                        @include('dashboard.posts.inputs.input_excerpts')
                    </div>
                </div>
                
            </div>
            <div class="tacf-tab-content tab-content p-0">
                @include('dashboard.posts.inputs.input_content')
            </div>
            <div class="tacf-tab-content tab-seo">
                @include('dashboard.posts.boxs.box_seo')
            </div>
            @if($action == 'update')
            <div class="tacf-tab-content tab-comments pl-3 pr-3 pb-3 pt-0">
                @include('dashboard.comments.index_loop_comments')
            </div>
            @endif
        </div>
    </div>
</form>
@if(get_option('content_editor') == 'articleeditor')
@include('dashboard.layouts.articleeditor')
@else
@include('dashboard.layouts.tinymce')
@endif
@endsection
@section('style_files')
<link href="{{ asset('libs/tacf/tacf.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('script_files')
<script src="{{ asset('libs/tacf/tacf.min.js') }}"></script>
@endsection

