@extends(get_extends('layouts.master'))
@section('content')
<div class="container padding_80">
    <div class="row @if($books_style == 'fixed') justify-content-center @endif">
        @if($books_style == 'left_sidebar')
        @include(get_extends('books.sidebar'))
        @endif
        <div class="@if($books_style == 'full') col-lg-12  @elseif($books_style == 'fixed') col-lg-10  @else  col-lg-9 col-md-8 col-sm-12 @endif">
            <div class="head-title">
                <h4>@if($the_cate_name){{$the_cate_name}}@else{{extension_lang('books', 'books')}}@endif</h4>
            </div>
            <div class="row">
                @foreach ($posts as $item)
                <div class="col-md-6">
                    <div class="book-grid-item">
                        <a href="{{url('book/'.$item->post_name)}}">
                            <img src="{{get_attachment_url($item->thumbnail, 'full')}}" class="book-grid-cover" alt="{{$item->post_title}}">
                        </a>
                        <div class="book-grid-meta">
                            <h4 class="book-grid-title"><a href="{{url('book/'.$item->post_name)}}">{{$item->post_title}}</a></h4>
                            <p class="grid-details"><strong>{{extension_lang('books', 'by')}}:</strong> {{$item->author}}</p>
                            <p class="grid-details"><strong>{{extension_lang('books', 'year')}}:</strong> {{$item->year}}</p>
                            <p class="grid-details"><strong>{{extension_lang('books', 'type')}}:</strong> {{$item->type}}</p>
                            <p class="grid-details"><strong>{{extension_lang('books', 'paperback')}}:</strong> {{$item->paperback}} {{extension_lang('books', 'pages')}}</p>
                            <p class="grid-details"><strong>{{extension_lang('books', 'price')}}:</strong> {{$item->price}}</p>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            {{ $posts->links(get_include('plugins.pagination')) }}
        </div>
        @if($books_style == 'right_sidebar')
        @include(get_extends('books.sidebar'))
        @endif
    </div>
</div>
@endsection