@extends(get_extends('layouts.master'))
@section('sub_header')
@include(get_extends('knowledgebase.search_form'))
@endsection
@section('content')
<div class="container padding_80">
    <div class="row @if($kb_single_style == 'fixed') justify-content-center @endif">
        @if($kb_single_style == 'left_sidebar')
        @include(get_extends('knowledgebase.sidebar'))
        @endif
        <div class="@if($kb_single_style == 'full') col-lg-12  @elseif($kb_single_style == 'fixed') col-lg-10  @else  col-lg-9 col-md-8 col-sm-12 @endif">
            <div class="head-title"><h3>{{$single->post_title}}</h3></div>
            <div class="knowledgebase-content">
                <div class="post-meta">
                    @if($kb_meta_author)<span class="meta-author"><i class="pe-7s-user"></i> {{get_username($single->post_author)}}</span>@endif
                    @if($kb_meta_date)<span class="meta-date"><i class="pe-7s-date"></i> {{time_format($single->post_modified, 'date')}}</span>@endif
                    @if($kb_meta_comments and $single->comment_status)<span class="meta-comment"><i class="pe-7s-comment"></i> {{get_count_comments($single->id, $single->post_type)}} {{lang('comments')}}</span>@endif
                    @if($kb_meta_views)<span class="meta-views"><i class="pe-7s-look"></i> {{$single->post_views}} {{lang('views')}}</span>@endif
                    @if($kb_meta_cate)<span class="meta-categories"><i class="pe-7s-ticket"></i> <a href="{{url('kbc/'.get_term_slug($single->term_id))}}">{{get_term_name($single->term_id)}}</a></span>@endif
                </div>
                <div class="post-content">{!!$single->post_content!!}</div>
            </div>
            <div class="knowledgebase-footer">
                @if($kb_meta_shareit)
                <div class="stars-tags">
                    @include(get_extends('plugins.share_socials'), ['title' => $single->post_title, 'link' => url('kb/'.$single->post_name)])
                </div>
                @endif
            </div>
            @include(get_extends('plugins.comments'), ['single' => $single])
        </div>
        @if($kb_single_style == 'right_sidebar')
        @include(get_extends('knowledgebase.sidebar'))
        @endif
    </div>
</div>
@endsection