@extends(get_extends('layouts.master'))
@section('content') 
<div class="container padding_80">
    <div class="row">
        <aside class="col-lg-3 col-md-5 col-sm-12 sidebar">
            <div class="profile-sidebar">
                <div class="avatar">
                    <img src="{{get_user_avatar_username(auth()->user()->username, 150)}}" alt="{{auth()->user()->username}}">
                </div>
                <h4>{{auth()->user()->username}}</h4>
            </div>
        </aside>
        <div class="col-lg-9 col-md-7 col-sm-12">
            <div class="profile-container">
                <h3>{{lang('profile')}}</h3>
                @if($errors->any())
                    <div class="alert alert-warning">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                @if(session()->has('success'))<div class="alert alert-success">{!! session()->get('success') !!}</div>@endif
                <form class="form-horizontal" action="{{url('profile')}}">
                    <div class="row">
                        <div class="col-lg-6 col-md-12">
                            <div class="form-group">
                                <label>{{lang('username')}}</label>
                                <div class="frm-input">
                                    <i class="far fa-user"></i>
                                    <input id="username" type="text" placeholder="{{lang('username')}}" class="input" name="username" value="@if(old('username')){{old('username')}}@else{{auth()->user()->username}}@endif">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="form-group">
                                <label>{{lang('email')}}</label>
                                <div class="frm-input">
                                    <i class="far fa-envelope"></i>
                                    <input type="email" class="input" name="email" placeholder="{{lang('email')}}" value="@if(old('email')){{old('email')}}@else{{auth()->user()->email}}@endif">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="form-group">
                                <label>{{lang('new_password')}}</label>
                                <div class="frm-input">
                                    <i class="fas fa-lock"></i>
                                    <input type="password" placeholder="{{lang('enter_new_password')}}" class="input" name="password">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="form-group">
                                <label>{{lang('confirm_new_password')}}</label>
                                <div class="frm-input">
                                    <i class="fas fa-lock"></i>
                                    <input type="password" placeholder="{{lang('confirm_new_password')}}" class="input" name="password_confirmation">
                                </div>
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="button">{{lang('update')}}</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection