<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\UsersController;
use App\Http\Controllers\Frontend\AuthController;


Route::any(get_admin_route('login'), [AuthController::class, 'adminlogin'])->middleware('guest');
Route::get(get_admin_route('pincode/confirm'), [AuthController::class, 'admin_pincode_confirm'])->middleware('auth')->name('pincode.confirm');
Route::post(get_admin_route('pincode/confirm'), [AuthController::class, 'admin_pincode_confirm_post'])->middleware('auth');

Route::any('login', [AuthController::class, 'login'])->middleware('guest')->name('login');
Route::any('/register', [AuthController::class, 'register'])->middleware('guest')->name('register');
Route::post('/logout', [AuthController::class, 'logout'])->middleware('auth')->name('logout');
Route::any('forgot-password', [AuthController::class, 'forgot_password'])->middleware('guest')->name('password.email');

Route::middleware(['auth'])->group(function () {
    Route::any('profile', [UsersController::class, 'profile'])->name('profile');
});
