
<form method="POST" action="<?php echo e(get_admin_url('UsersSendForm')); ?>" class="form-horizontal" enctype="multipart/form-data">
    <?php echo e(csrf_field()); ?>

    <input type="hidden" name="action" value="<?php echo e($data['action']); ?>">
    <input type="hidden" name="userid" value="<?php echo e($data['userid']); ?>">
    <div class="row">
        <div class="col-md-12">
            <?php app('eventy')->action('admin_user_form_before', $data['userid']); ?>
            <h4 class="card-title"><i class="bx bx-id-card"></i> <?php echo e(admin_lang('personal_data')); ?></h4>
            <hr />
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label for="username"><?php echo e(admin_lang('username')); ?></label>
                        <div class="frm-input">
                            <input class="form-control" name="username" type="text" id="username" value="<?php if(old('username')): ?><?php echo e(old('username')); ?><?php else: ?><?php echo e($data['username']); ?><?php endif; ?>" placeholder="<?php echo e(admin_lang('username')); ?>">
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label for="email"><?php echo e(admin_lang('email')); ?></label>
                        <div class="frm-input">
                            <input class="form-control" name="email" type="email" id="email" value="<?php if(old('email')): ?><?php echo e(old('email')); ?><?php else: ?><?php echo e($data['email']); ?><?php endif; ?>" placeholder="<?php echo e(admin_lang('email')); ?>">
                        </div>
                    </div>
                </div>
                <?php if($data['user_userlevel'] == 'admin'): ?>
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label><?php echo e(admin_lang('status')); ?></label>
                        <div>
                            <input type="checkbox" name="status" value="1" class="custom-control-input" switch="bool" id="status_switch" <?php if($data['user_status']): ?> checked <?php endif; ?>>
                            <label for="status_switch" data-on-label="ON" data-off-label="OFF"></label>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <?php app('eventy')->action('admin_user_form_personal_data', $data['userid']); ?>
            <h4 class="card-title"><i class="bx bx-lock-alt"></i> <?php echo e(admin_lang('password')); ?> <small><?php echo e(admin_lang('leave_field_change')); ?></small></h4>
            <hr />
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label for="password"><?php echo e(admin_lang('password')); ?></label>
                        <div class="input-group">
                            <input class="form-control" name="password" type="password" id="password" value="<?php echo e(old('password')); ?>" placeholder="<?php echo e(admin_lang('password')); ?>">
                            <span class="input-group-text"><i class="bx bx-lock"></i></span>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label for="confirm_password"><?php echo e(admin_lang('confirm_password')); ?></label>
                        <div class="input-group">
                            <input class="form-control" name="password_confirmation" type="password" id="confirm_password" value="<?php echo e(old('password_confirmation')); ?>" placeholder="<?php echo e(admin_lang('confirm_password')); ?>">
                            <span class="input-group-text"><i class="bx bx-lock"></i></span>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label for="pincode"><?php echo e(admin_lang('pincode')); ?> <small><?php echo e(admin_lang('admin_only')); ?></small></label>
                        <div class="input-group">
                            <input class="form-control" name="pincode" type="password" id="pincode" value="<?php echo e(old('pincode')); ?>" placeholder="<?php echo e(admin_lang('pincode')); ?>">
                            <span class="input-group-text"><i class="bx bx-dialpad"></i></span>
                        </div>
                    </div>
                </div>
            </div>
            <?php app('eventy')->action('admin_user_form_password_data', $data['userid']); ?>
            <?php if($data['user_userlevel'] == 'admin'): ?>
            <h4 class="card-title"><i class="bx bx-id-card"></i> <?php echo e(admin_lang('role')); ?></h4>
            <hr />
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label><?php echo e(admin_lang('role')); ?></label>
                        <div class="buttons-options">
                            <button type="button" data-value="admin" class="option-on <?php echo e(get_class_active($data['userlevel'], 'admin', false)); ?>"><?php echo e(admin_lang('userlevel_admin')); ?></button>
                            <button type="button" data-value="supervisor" class="option-on <?php echo e(get_class_active($data['userlevel'], 'supervisor', false)); ?>"><?php echo e(admin_lang('userlevel_supervisor')); ?></button>
                            <button type="button" data-value="user" class="option-on <?php echo e(get_class_active($data['userlevel'], 'user', false)); ?>"><?php echo e(admin_lang('userlevel_user')); ?></button>
                            <button type="button" data-value="new" class="option-on <?php echo e(get_class_active($data['userlevel'], 'new', false)); ?>"><?php echo e(admin_lang('userlevel_new')); ?></button>
                            <input type="hidden" name="userlevel" value="<?php echo e($data['userlevel']); ?>">
                        </div>
                    </div>
                    
                    <div class="form-group mb-4">
                        <label><?php echo e(admin_lang('dashboard')); ?></label>
                        <div class="buttons-options">
                        
                        </div>
                    </div>

                </div>
                <div class="col-md-8">
                    <div class="form-group mb-4">
                        <label><?php echo e(admin_lang('permissions')); ?></label>
                        <select id="permission" multiple="multiple"  name="permission[]">
                            <?php $__currentLoopData = get_array_permission(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <optgroup label="<?php echo e($permission['title']); ?>">
                                <?php $__currentLoopData = $permission['permission']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_key => $item_title): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item_key); ?>" <?php if(in_array($item_key, $data['user_permission'])): ?> selected <?php endif; ?>><?php echo e($item_title); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </optgroup>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php app('eventy')->action('admin_user_form_after', $data['userid']); ?>
        </div>
    </div>
    <hr />
    <div class="form-group mb-0">
        <button type="submit" class="btn btn-primary"><span></span> <?php if($data['action'] == 'update'): ?> <?php echo e(admin_lang('update')); ?> <?php else: ?> <?php echo e(admin_lang('add_new')); ?> <?php endif; ?></button>
    </div>
</form><?php /**PATH C:\wamp64\www\waqf_new\resources\views/dashboard/users/user_form.blade.php ENDPATH**/ ?>