
<?php $__env->startSection('content'); ?>
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18"><?php echo e($page_title); ?></h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="<?php echo e(get_admin_url('/')); ?>"><?php echo e(admin_lang('dashboard')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e($page_title); ?></li>
        </ol>
    </div>
</div>
<?php if(session()->has('success')): ?>
<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button><?php echo session()->get('success'); ?></div>
<?php endif; ?>
<div class="card">
    <div class="card-body">
        <form class="form-horizontal" method="POST" action="<?php echo e(get_admin_url('PostsActions')); ?>">
            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="type" value="<?php echo e($type); ?>">
            <input type="hidden" name="query" value="action">
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="actionselect">
                        <select name="action" class="custom-select form-select custom-select-sm form-control form-control-sm" style="width: 150px;">
                            <option value="-1"><?php echo e(admin_lang('bulk_actions')); ?></option>
                            <option value="enable"><?php echo e(admin_lang('enable')); ?></option>
                            <option value="disable"><?php echo e(admin_lang('disable')); ?></option>
                            <option value="delete"><?php echo e(admin_lang('delete')); ?></option>
                        </select>
                        <input type="submit" class="btn btn-sm btn-primary" value="<?php echo e(admin_lang('apply')); ?>" onclick="return confirm(\'<?php echo e(admin_lang('apply_confirm')); ?>\');">
                    </div>
                </div>
                <div class="col-md-4">

                </div>
                <div class="col-md-4 btn-addnew">
                    <a href="<?php echo e(get_admin_url('postnew/'.$type)); ?>" class="btn btn-sm btn-primary"><?php echo e(admin_lang('add_new')); ?></a>
                </div>
            </div>
            <table id="datatable" class="table table-striped table-bordered dt-responsive nowrap">
                <thead>
                    <tr>
                        <th style="width: 15px;" class="text-center th-checkbox">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="selectall" />
                                <label class="custom-control-label" for="selectall"></label>
                            </div>
                        </th>
                        <th><?php echo e(admin_lang('title')); ?></th>
                        <th style="width: 200px;" class="hidden-phone text-center"><?php echo e(admin_lang('author')); ?></th>
                        <th style="width: 100px;" class="hidden-phone text-center"><?php echo e(admin_lang('views')); ?></th>
                        <th style="width: 150px;" class="hidden-phone text-center"><?php echo e(admin_lang('date')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="td-checkbox text-center">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="mark[]" value="<?php echo e($post->id); ?>" id="select-<?php echo e($post->id); ?>" />                                        
                                <label class="custom-control-label" for="select-<?php echo e($post->id); ?>"></label>
                            </div>
                            <?php if($post->post_status): ?>
                            <span class="sq-post-status disable"></span>
                            <?php else: ?>
                            <span class="sq-post-status enable"></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <strong><a href="<?php echo e(get_admin_url('editpost/'.$post->id)); ?>"><?php echo e($post->post_title); ?></a></strong>
                            <?php echo $__env->make('dashboard.posts.boxs.rowactions', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </td>
                        <td class="hidden-phone text-center"><?php echo e(get_username($post->post_author)); ?></td>
                        <td class="hidden-phone text-center"><?php echo e($post->post_views); ?></td>
                        <td class="hidden-phone text-center"><?php echo e($post->post_modified); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </form>
        <?php echo e($posts->links('dashboard.layouts.pagination')); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\php-help-manager\v5\script\project\resources\views/dashboard/posts/pages/index_posts.blade.php ENDPATH**/ ?>