<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Country;
use PHPUnit\Framework\Constraint\Count;

class CountryController extends Controller
{
    private $url_prefix;
    private $page_title;
    private $url_new;
    private $btn_new;
    private $paginate;

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->url_prefix   = 'Country';
        $this->page_title   = 'Country';
        $this->btn_new      = 'add_new';
        $this->url_new      = get_admin_url('countryadd');
        $this->paginate     = 5;
    }
    // index users
    public function index_country($type = '',Request $request)
    {
       
       
        $data['type']       = 'users';
        $data['page_class'] = 'country';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
        //if ($request->has('page') and $request->get('page') > $country->lastPage()) {return redirect($country->url($country->lastPage()));}
        return get_admin_view('country.index_country',["data"=> $data]);
    }

    public function ajaxlist_country(Request $request){
    
        if($request->ajax())
        {
            $data['type']       = 'users';
            $data['page_class'] = 'country';
            $data['url_prefix'] = $this->url_prefix;
            $data['page_title'] = $this->page_title;
            $data['btn_new']    = $this->btn_new;
            $data['url_new']    = $this->url_new;
            $country=new Country();
         
            $country = $country->orderBy('created_at', 'DESC');
          
            if($request->get('s')){
                $search = $request->get('s');
                $country->orWhere('country_name', 'LIKE', "%{$search}%");
                $country->orWhere('country_name_gj', 'LIKE', "%{$search}%");
                $country->orWhere('country_name_gj', 'LIKE', "%{$search}%");
                $country->orWhere('country_code', 'LIKE', "%{$search}%");
                $country->orWhere('created_at', 'LIKE', "%{$search}%");
            }
            $country = $country->paginate($this->paginate);
            if($request->has('page') and $request->get('page') > $country->lastPage()) {return redirect($country->url($country->lastPage()));}
            return get_admin_view('country.ajaxlist_country', ["data"=> $data,'countrys'=>$country]);
        }
        
       }
     




    public function country_profile($id =0, Request $request)
    {
   
        $curre_user = Auth::user();
       
        $user_id =  $curre_user->id;
   
        $country=Country::find($id);
     
        if($country){
        
        $getuser = User::find($user_id);
       
        if ($getuser->count()) {
           
            $type               = 'users';
            $user               = $getuser->first();
            $data['user']       = $user;
            $data['type']       = $type;
            $data['page_class'] = $type;
            $data['action']     = 'update';
            $data['page_title'] = 'Update Country';
            $data['user_meta']  = query_user_meta($data['user']->id);
        
            $datauser                   = $user;
            $data['user_userlevel']     = $curre_user->userlevel;
            $data['userlevel']          = $datauser->userlevel;
            $data['type']               = $datauser->userlevel;
            $data['page_class']         = $datauser->userlevel;
            $data['action']             = 'update';
            $data['userid']             = $datauser->id;
            $data['username']           = $datauser->username;
            $data['email']              = $datauser->email;
            $data['user_status']        = $datauser->status;
            $data['admin_language']     = get_user_meta('admin_language', $user_id, 'en');
            $permission                 = maybe_unserialize(get_user_meta('permission', $user_id, []));
            $data['user_permission']    = (is_array($permission))? $permission : [];

            return get_admin_view('country.profile_country', ["data"=>$data,"country"=>$country]);
        }
    }
    }

    // index profile
    public function index_countryadd(Request $request)
    {
        $user = Auth::user();
        
        $data['page_title']         = "Add Country";
        $type                       = 'users';
        $data['type']               = $type;
        $data['page_class']         = $type;
        $data['action']             = 'addnew';
        $data['user_userlevel']     = $user->userlevel;
        $data['userlevel']          = 'user';
        $data['user_vip']           = '0';
        $data['user_viptime']       = '';
        $data['userid']             = '0';
        $data['user_status']        = '1';
        $data['username']           = '';
        $data['email']              = '';
        $data['admin_language']     = 'en';
        $data['user_permission']    = [];
        return get_admin_view('country.country_edit', ['data'=>$data]);
    }

    // send form
    public function country_sendform(Request $request)
    {
       
        $user = Auth::user();
        $userid = $request->get('userid');

        $country=Country::create(["country_name"=>$request->input('country_name'),
        "country_name_gj"=>$request->input("country_name_gj"),
        "country_code"=>$request->input('country_code')]);

        if($country){
            return redirect()->back()->with('success','Country '.$request->input('country_name') . ' added Successfully!');
          } 
          else {
            return redirect()->back()->with('failure', "Country ".$request->input('country_name') . ' Not added');
          }
     
    
       // return redirect(get_admin_url('profile/'.$user_id))->with("success", $success);
    }


    // actions post
    public function country_actions(Request $request)
    {
    
        if($request->has('query') && $request->get('query') == 'action')
        {
          
             if($request->get('action') == 'update')
            {
             
                $country=Country::find($request->input('id'));
                $country->country_name = $request->input('country_name');
                $country->country_name_gj = $request->input('country_name_gj');
                $country->country_code = $request->input('country_code');
                if($country->save()){
                    return redirect()->back()->with("success", "Country Updated successfully!");
                }else{
                    return redirect()->back()->with("failure", "Country Not Updated!");
                }
            }
   else{
            $marks = $request->get('mark');
             if(empty($marks)){
                return redirect()->back();
             }
             $items=count($marks);
             $faileditem=0;
             $success="";
            if($request->get('action') == 'delete' and is_array($marks))
            {
                $count=0;
                foreach($marks as $markid)
                {
                   $count=$count+1;
                   $success= Country::find($markid)->delete();
                   if(empty($success)){
                    $faileditem= $faileditem+1;
                   }
                }
                if(($success) && $items==$count ){
                    return redirect()->back()->with("success", "Selected Items are Deleted Successfully!");
                }
                else if(($success) && $faileditem!=0){
                    return redirect()->back()->with("failure","Selected Items are deleted except $faileditem country");
                }
                else{
                    return redirect()->back()->with("failure","Selected Items are not deleted");
                }
            }
         

            
        }
    }
    }
    // action enable post



    // action delete post
    public function index_deletecountry($id, $token)
    { $country=Country::find($id);
      $countryname=$country->country_name;
      $country=$country->delete();
      if($country){
        return redirect()->back()->with("success", "Country $countryname deleted Successfully!");
      }else{
        return redirect()->back()->with("failure", "Country $countryname deleted");
      }
    }
}