<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\CertificatePrintLog;
use Illuminate\Support\Facades\Auth;
use App\Models\Driver;
use App\Models\User;
use App\Models\DriverFund;
use TCPDF;


class DashboardController extends Controller
{

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
    }

    public function generatePDF()
    {

        $user = Auth::user();
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        $pdf->SetFont('freeserif', '', 12);
        $deceased = session()->get('deceased');
        $d_id = "";
        if (isset($deceased))
            $date = date('Y-m-d');
        $d_id = $deceased->id;
        $filename = "deceased_$date.pdf";
        $pdf->SetFont('freeserif', '', 12);

        $pdf->AddPage();
        $pdf->getBreakMargin();
        $pdf->Image(asset('images/asmwc_logo_org.png'), 10, 80, 200, 100, '', '', '', false, 0, '', false, false, 0);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->SetAutoPageBreak(true);
        $pdf->setPageMark();
        if ($deceased['lang'] == 1) {
            $pdf->writeHTML(view('dashboard.deceased.pdf_deceased', array('deceased' => $deceased)), true, false, true, false, '');
        } else {
            $pdf->writeHTML(view('dashboard.deceased.pdf_deceased_guj', array('deceased' => $deceased)), true, false, true, false, '');
        }

        $pdf->Output($filename);
        $date = date('Y-m-d', time());
        CertificatePrintLog::create(['deceased_id' => $d_id, 'created_by' => $user->id, 'print_date' => $date]);

        // return response()->download($filename);
        // $deceased=session()->get('deceased');
        // if(isset($deceased))
        // if($deceased['lang']==1){
        // $pdf = PDF::loadView('dashboard.deceased.pdf_deceased',array('deceased'=>$deceased));
        // }
        // else{
        // $pdf = PDF::loadView('dashboard.deceased.pdf_deceased_guj',array('deceased'=>$deceased));
        // }
        // $date=date('y-m-d');
        // return $pdf->download("deceased_$date.pdf");
    }


    public function index_dashboard(Request $request)
    {
        $data['page_title'] = admin_lang('dashboard');
        $data['page_class'] = 'dashboard';
        $visitor_ismobile = DB::table(VISITOR_TABLE)->where('ismobile', '1')->count();
        $visitor_istablet = DB::table(VISITOR_TABLE)->where('istablet', '1')->count();
        $visitor_isdesktop = DB::table(VISITOR_TABLE)->where('isdesktop', '1')->count();
        $visitor_isbot = DB::table(VISITOR_TABLE)->where('isbot', '1')->count();
        $visitor_ischrome = DB::table(VISITOR_TABLE)->where('ischrome', '1')->count();
        $visitor_isfirefox = DB::table(VISITOR_TABLE)->where('isfirefox', '1')->count();
        $visitor_isopera = DB::table(VISITOR_TABLE)->where('isopera', '1')->count();
        $visitor_issafari = DB::table(VISITOR_TABLE)->where('issafari', '1')->count();
        $visitor_isie = DB::table(VISITOR_TABLE)->where('isie', '1')->count();
        $visitor_isedge = DB::table(VISITOR_TABLE)->where('isedge', '1')->count();
        $visitor_total = $visitor_ismobile + $visitor_ismobile + $visitor_isdesktop + $visitor_isbot;
        $data['visitor_total'] = number_format($visitor_total);
        $data['visitor_ismobile'] = number_format($visitor_ismobile);
        $data['visitor_istablet'] = number_format($visitor_istablet);
        $data['visitor_isdesktop'] = number_format($visitor_isdesktop);
        $data['visitor_isbot'] = number_format($visitor_isbot);
        $data['visitor_ismobile_pre'] = $visitor_ismobile > 0 ? @number_format(($visitor_total / $visitor_ismobile) * 100, 2) : 0;
        $data['visitor_istablet_pre'] = $visitor_ismobile > 0 ? @number_format(($visitor_total / $visitor_istablet) * 100, 2) : 0;
        $data['visitor_isdesktop_pre'] = $visitor_isdesktop > 0 ? @number_format(($visitor_total / $visitor_isdesktop) * 100, 2) : 0;
        $data['visitor_isbot_pre'] = $visitor_isbot > 0 ? @number_format(($visitor_total / $visitor_isbot) * 100, 2) : 0;
        $data['visitor_ischrome'] = number_format($visitor_ischrome);
        $data['visitor_isfirefox'] = number_format($visitor_isfirefox);
        $data['visitor_isopera'] = number_format($visitor_isopera);
        $data['visitor_issafari'] = number_format($visitor_issafari);
        $data['visitor_isie'] = number_format($visitor_isie);
        $data['visitor_isedge'] = number_format($visitor_isedge);
        $visitors = DB::table(VISITOR_TABLE)->select('date', DB::raw('count(*) as total'))->orderBy('date', 'DESC')->groupBy('date')->limit(30)->get();
        if(Auth::user()->userlevel == 'admin'){
            $data['driver_fund'] = DriverFund::with('drivers')->orderBy('id', 'DESC')->limit(10)->get();
            $data['drivers'] = Driver::orderBy('SMART_DRIVERID', 'DESC')->limit(10)->get();
        }else if(Auth::user()->userlevel == 'supervisor'){
            $driver = DriverFund::pluck('driver_id');
            $item = Driver::whereIn('SMART_DRIVERID', $driver)->where('MEM_ID', Auth::user()->id)->pluck('SMART_DRIVERID');
            $data['driver_fund'] = DriverFund::whereIn('driver_id', $item)->orderBy('id', 'DESC')->limit(10)->get();
            $data['drivers'] = Driver::where('MEM_ID', Auth::user()->id)->orderBy('SMART_DRIVERID', 'DESC')->limit(10)->get();
        }
        if (Auth::user()->userlevel == 'admin' || Auth::user()->userlevel == 'supervisor') {
            $substatusCountssql = DB::table('smartpay_driver')
                ->select('CREATED_DATE', DB::raw('COUNT(*) as total'), DB::raw('MONTH(CREATED_DATE) as Month'))
                ->where('STATUS', '=', 1)
                ->where('CARD_NUM', '!=', NULL);
            if ($request->has('past_year')) {
                $pastYear = $request->input('past_year');
                $substatusCountssql->whereYear('CREATED_DATE', '=', $pastYear);
            } else {
                $substatusCountssql->whereYear('CREATED_DATE', '=', date('Y'));
            }

            if (Auth::user()->userlevel == 'supervisor') {
                $substatusCountssql->where('MEM_ID', Auth::user()->id);
            }
            $substatusCounts = $substatusCountssql->groupBy(DB::raw('MONTH(CREATED_DATE)'))
                ->get();
            $month = [
                'January' => 0,
                'February' => 0,
                'March' => 0,
                'April' => 0,
                'May' => 0,
                'June' => 0,
                'July' => 0,
                'August' => 0,
                'September' => 0,
                'October' => 0,
                'November' => 0,
                'December' => 0
            ];


            foreach ($substatusCounts as $count) {
                $monthName = date('F', mktime(0, 0, 0, $count->Month, 1));
                if (array_key_exists($monthName, $month)) {
                    $month[$monthName] = $count->total;
                }
            }
            $dataSeries = [];
            foreach ($month as $monthName => $count) {
                $dataSeries[] = [
                    'name' => $monthName,
                    'data' => $count
                ];

                $data['cards'] = $dataSeries;

            }
        }
        $data['driver'] = Driver::where('CLIENT_ID', Auth::user()->id)->first();
        // $data['cards'] = $month;
        return get_admin_view('index_dashboard', $data);
    }

    public function index_settings()
    {
        if (!is_permission('settings')) {
            return parent::admin_handle_permission('settings');
        }
        $data['page_title'] = admin_lang('settings');
        $data['page_class'] = 'settings';
        return get_admin_view('settings.settings', $data);
    }

    public function settings_sendform(Request $request)
    {
        if (!is_permission('settings')) {
            return parent::admin_handle_permission('settings');
        }
        foreach ($request->all() as $key => $value) {
            if ($key != '_token') {
                if (is_array($value)) {
                    update_option($key, maybe_serialize($value));
                } else {
                    update_option($key, $value);
                }
            }
        }
        return redirect()->back()->with("success", admin_lang('settings_saved_successfully'));
    }

    public function low_limit_threshold(Request $request, $id)
    {
        $user = User::find($id);
        $user->low_limit_threshold = $request->low_limit_threshold;
        $user->update();

        return redirect()->back()->with('success', 'Low Limit Threshold is Updated');
    }

}
