<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\City;
use App\Models\Area;
use App\Models\State;
use App\Models\Country;
use App\Models\Utility;
use App\Models\Driver;
use App\Models\Pincode;
use App\Models\DriverFund;
use App\Models\DriverStatus;
use PHPUnit\Framework\Constraint\Count;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use App\Models\estate;
use App\Http\Requests\PropertyRequest;


class DriverController extends Controller
{
    private $url_prefix;
    private $page_title;
    private $url_new;
    private $btn_new;
    private $paginate;

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->url_prefix = 'Driver';
        $this->page_title = 'Driver';
        $this->btn_new = 'add_new';
        $this->url_new = get_admin_url('driveradd');
        $this->paginate = 25;
    }
    //Property index
    public function index_driver(Request $request, $type = '')
    {

        $data['type'] = 'users';
        $data['page_class'] = 'Driver';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new'] = $this->btn_new;
        $data['url_new'] = $this->url_new;
        //if ($request->has('page') and $request->get('page') > $country->lastPage()) {return redirect($country->url($country->lastPage()));}

        $country = Country::where('country_code', '=', 'IN')->first();
        $state = [];
        $estate = estate::all();
        $city = City::all();

        $area = Area::all();
        $driver = Driver::all();
        $companies = User::where('userlevel', 'supervisor')->get();
        if (!empty($country))
            $state = State::select('id', 'state_name')->where('country_id', '=', $country->id)->get();

        return get_admin_view('driver.index_driver', ["data" => $data, "companies" => $companies, "driver_data" => $driver, "states" => $state, "citys" => $city, "areas" => $area, "estates" => $estate]);
    }

    public function driver_fund(Request $request, $type = '')
    {
        $data['type'] = 'users';
        $data['page_class'] = 'Driver Fund';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new'] = $this->btn_new;
        $data['url_new'] = $this->url_new;
        //if ($request->has('page') and $request->get('page') > $country->lastPage()) {return redirect($country->url($country->lastPage()));}

        $country = Country::where('country_code', '=', 'IN')->first();
        $state = [];
        $estate = estate::all();
        $city = City::all();

        $area = Area::all();
        $driver_fund = DriverFund::with('drivers')->paginate($this->paginate);
        if (!empty($country))
            $state = State::select('id', 'state_name')->where('country_id', '=', $country->id)->get();

        return get_admin_view('driver.index_driver_fund', ["data" => $data, "driver_data" => $driver_fund, "states" => $state, "citys" => $city, "areas" => $area, "estates" => $estate]);
    }

    public function ajaxlist_driver(Request $request)
    {
        if ($request->ajax()) {
            $data['type'] = 'users';
            $data['page_class'] = 'Driver';
            $data['url_prefix'] = $this->url_prefix;
            $data['page_title'] = $this->page_title;
            $data['btn_new'] = $this->btn_new;
            $data['url_new'] = $this->url_new;

            if (Auth::user()->userlevel == 'admin') {
                $driver = Driver::orderBy('CREATED_DATE', 'DESC');
            } else {
                $driver = Driver::where('MEM_ID', Auth::user()->id)->orderBy('CREATED_DATE', 'DESC');
            }
            $estate = estate::all();
            $city = City::all();
            $state = State::all();
            $area = Area::all();

            if ($request->has('s') || $request->has('company_name') || $request->has('driver_status')) {
                $driver->where(function ($query) use ($request) {
                    $search = $request->input('s');
                    $company_name = $request->input('company_name');
                    $driver_status = $request->input('driver_status');
                    if ($search != '') {
                        $query->where(function ($querysearch) use ($search) {

                            $querysearch->where('FIRST_NAME', 'LIKE', '%' . $search . '%')
                                ->orWhere('LAST_NAME', 'LIKE', '%' . $search . '%')
                                ->orWhere('CARD_NUM', 'LIKE', '%' . $search . '%')
                                ->orWhere('DRIVER_PHONE', 'LIKE', '%' . $search . '%')
                                ->orWhere('SUB_STATUS', 'LIKE', '%' . $search . '%');
                        });
                    }

                    if ($driver_status != '') {
                        $query->Where('STATUS', $driver_status);
                    }

                    if (Auth::user()->userlevel == 'admin' && $company_name != '') {
                        $query->Where('MEM_ID', $company_name);
                    }
                });
            }
            $driver = $driver->paginate($this->paginate);
            if ($request->has('page') and $request->get('page') > $driver->lastPage()) {
                return redirect($driver->url($driver->lastPage()));
            }
            return get_admin_view('driver.ajaxlist_driver', ["data" => $data, 'drivers' => $driver]);
        }

    }

    public function ajaxlist_driver_fund(Request $request)
    {
        if ($request->ajax()) {
            $data['type'] = 'users';
            $data['page_class'] = 'Driver Fund';
            $data['url_prefix'] = $this->url_prefix;
            $data['page_title'] = $this->page_title;
            $data['btn_new'] = $this->btn_new;
            $data['url_new'] = $this->url_new;

            $driver = DriverFund::pluck('driver_id');
            $item = Driver::whereIn('SMART_DRIVERID', $driver)->where('MEM_ID', Auth::user()->id)->pluck('SMART_DRIVERID');
            $ab = DriverFund::whereIn('driver_id', $item)->orderBy('id', 'DESC');

            $estate = estate::all();
            $city = City::all();
            $state = State::all();
            $area = Area::all();


            if ($request->get('s')) {

                $search = $request->get('s');
                $ab->where(function ($query) use ($search) {
                    $query->Where('amount', 'LIKE', '%' . $search . '%')
                        ->orWhere('issue_to', 'LIKE', '%' . $search . '%')
                        ->orWhere('notes', 'LIKE', '%' . $search . '%')
                        ->orWhere('ref_id', 'LIKE', '%' . $search . '%')
                        ->orWhereHas('drivers', function ($query) use ($search) {
                            $query->where('USERNAME', 'LIKE', '%' . $search . '%');
                        });
                });
            }

            $ab = $ab->paginate($this->paginate);
            if ($request->has('page') and $request->get('page') > $ab->lastPage()) {
                return redirect($ab->url($ab->lastPage()));
            }
            return get_admin_view('driver.ajaxlist_driver_fund', ["data" => $data, 'drivers' => $ab]);
        }

    }



    public function autocom_pincode(Request $request)
    {
        $pincod_data = "";

        if (isset($request['keyword']) && $request['keyword'] != "") {
            $search = $request['keyword'];

            $pincode = Pincode::where('pincode', 'LIKE', '%' . $search . '%')->get();

            $pincod_data .= "<ul id='country-list'>";


            foreach ($pincode as $pincod_datas) {


                $pincod_data .= "<li onClick='selectCountry($pincod_datas->pincode);'>$pincod_datas->pincode</li>";
                $pincod_data .= "</ul>";

            }
        }
        echo $pincod_data;
        exit;

    }


    public function driver_profile(Request $request, $id, $mode = '')
    {
        $curre_user = Auth::user();

        $user_id = ($id) ? $id : $curre_user->id;

        $driver = Driver::where('SMART_DRIVERID', $id)->first();

        if ($driver) {

            $getuser = User::find($driver->CLIENT_ID);
            if ($getuser->count()) {
                $type = 'users';
                $user = $getuser;
                $data['user'] = $user;
                $data['type'] = $type;
                $data['page_class'] = $type;
                $data['action'] = 'update';
                $data['page_title'] = 'Update Driver';
                $data['user_meta'] = query_user_meta($data['user']->id);
                $loop_comments = DB::table(COMMENTS_TABLE)
                    ->where([['cuid', '=', $user_id], ['spam_trash', '=', '0']])
                    ->orderBy('cstatus', 'ASC')
                    ->orderBy('cmodified', 'DESC')
                    ->paginate(25);
                if ($request->has('page') and $request->get('page') > $loop_comments->lastPage()) {
                    return redirect($loop_comments->url($loop_comments->lastPage()));
                }
                $data['loop_comments'] = $loop_comments;
                $data['signintime'] = get_user_meta('signintime', $user->id);
                $data['details']['ip'] = get_user_meta('ip', $user->id);
                $data['details']['useragent'] = get_user_meta('useragent', $user->id);
                $data['details']['platformname'] = get_user_meta('platformname', $user->id);
                $data['details']['browserfamily'] = get_user_meta('browserfamily', $user->id);

                $datauser = $user;
                $data['user_userlevel'] = $curre_user->userlevel;
                $data['userlevel'] = $datauser->userlevel;
                $data['type'] = $datauser->userlevel;
                $data['page_class'] = $datauser->userlevel;
                $data['action'] = 'update';
                $data['userid'] = $datauser->id;
                $data['username'] = $datauser->username;
                $data['email'] = $datauser->email;
                $data['user_status'] = $datauser->status;
                $data['admin_language'] = get_user_meta('admin_language', $user_id, 'en');
                $permission = maybe_unserialize(get_user_meta('permission', $user_id, []));
                $data['user_permission'] = (is_array($permission)) ? $permission : [];
                $data['driver'] = $driver;
                // dd($data['driver']);
                $apiData = [];
                $array_getCard = [];
                if ($driver->CARD_NUM) {
                    $efsData = [
                        'clientID' => getEFSClientID(),
                        'cardNumber' => $driver->CARD_NUM
                    ];
                    $response = CallApi('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getSmartPayDriver_api.php', $efsData);
                    $responseData = json_decode($response);
                    if (!empty($responseData->ns5getSmartPayDriverResponse->result)) {
                        $apiData = $responseData->ns5getSmartPayDriverResponse->result;
                        $data['driver']->FIRST_NAME = $apiData->firstName;
                        $data['driver']->LAST_NAME = $apiData->lastName;
                        $data['driver']->ADDRESS = $apiData->address;
                        $data['driver']->CITY = $apiData->city;
                        $data['driver']->STATE = $apiData->state;
                        $data['driver']->POSTAL = $apiData->postalCode;
                        $data['driver']->COUNTRY = $apiData->country;
                        $data['driver']->DOB = $apiData->dob;
                        if (empty($data['driver']->SSN_NUM)) {
                            $data['driver']->SSN_NUM = '000-00-'.$apiData->last4ss;
                        }
                        $data['driver']->DRIVER_EMAIL = $apiData->email;
                        $data['driver']->DRIVER_PHONE = $apiData->phone;
                    }


                }

                return get_admin_view('driver.profile_driver', [
                    "data" => $data,
                    "driver" => $driver,
                    "mode" => $mode,
                    "api_data" => $array_getCard
                ]);



            }
        }
    }

    // index profile
    public function index_driveradd(Request $request, $mode = '')
    {
        $user = Auth::user();

        $data['page_title'] = "Add Driver";
        $type = 'users';
        $data['type'] = $type;
        $data['page_class'] = $type;
        $data['action'] = 'addnew';
        $data['user_userlevel'] = $user->userlevel;
        $data['userlevel'] = 'user';
        $data['user_vip'] = '0';
        $data['user_viptime'] = '';
        $data['userid'] = '0';
        $data['user_status'] = '1';
        $data['username'] = '';
        $data['email'] = '';
        $data['admin_language'] = 'en';
        $data['user_permission'] = [];
        $companies = User::where('userlevel', 'supervisor')->get();
        $country = Country::all();
        $estate = estate::all();
        $city = City::all();
        return get_admin_view('driver.driver_edit', [
            'data' => $data,
            "estates" => $estate,
            "countrys" => $country,
            "companies" => $companies,
            "mode" => $mode
        ]);

    }

    // estate dropdown
    public function estateDropdown()
    {
        $data = estate::all();
        return get_admin_view('driver.driver_form', ['data' => $data]);
    }

    // send form
    public function driver_sendform(Request $request)
    {
        $this->validate($request, [
            'FIRST_NAME' => 'required',
            'LAST_NAME' => 'required',
            'ADDRESS' => 'required',
            'CITY' => 'required',
            'STATE' => 'required',
            'POSTAL' => 'required',
            'COUNTRY' => 'required',
            'DOB' => 'required',
            'SSN_NUM' => 'required',
            'DRIVER_EMAIL' => 'required|unique:smartpay_driver',
            'DRIVER_PHONE' => 'required',
            'STATUS' => 'required',
            'SUB_STATUS' => 'required',
            'USERNAME' => 'required',
            'PASSWORD' => 'required',
            'pin_number' => 'required',
        ]);

        $driverEmail = $request->DRIVER_EMAIL;
        $emailExists = User::where('email', $driverEmail)->exists();

        if ($emailExists) {
            return redirect()->back()->with('error', 'Email is Already Been Taken Pls Use Another Email.');
        }

        $user = Auth::user();
        // $userid = $request->get('userid');

        $driver = Driver::create([
            "FIRST_NAME" => $request->input('FIRST_NAME'),
            "LAST_NAME" => $request->input("LAST_NAME"),
            "ADDRESS" => $request->input('ADDRESS'),
            "CITY" => $request->input('CITY'),
            "STATE" => $request->input('STATE'),
            "POSTAL" => $request->input('POSTAL'),
            "COUNTRY" => $request->input('COUNTRY'),
            "DOB" => $request->input('DOB'),
            "SSN_NUM" => $request->input('SSN_NUM'),
            "DRIVER_EMAIL" => $request->input('DRIVER_EMAIL'),
            "DRIVER_PHONE" => $request->input('DRIVER_PHONE'),
            "STATUS" => $request->input('STATUS'),
            "SUB_STATUS" => $request->input('SUB_STATUS'),
            "USERNAME" => $request->input('USERNAME'),
            "PASSWORD" => $request->input('PASSWORD'),
            "pin_number" => $request->input('pin_number'),
            "MEM_ID" => $user->id,
            "CREATED_DATE" => date('Y-m-d'),
        ]);

        $lastDriverId = $driver->SMART_DRIVERID;

        $mailurl = "https://tms.tmdashboard.com/sendgrid/newcard_order.php?ID=" . $lastDriverId;
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $mailurl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            )
        );
        $response = curl_exec($curl);
        curl_close($curl);

        $user = User::create([
            "username" => $request->input('USERNAME'),
            "email" => $request->input("DRIVER_EMAIL"),
            "password" => Hash::make($request->input('PASSWORD')),
            'pincode' => md5($request->input('pin_number')),
            "userlevel" => 'user',
            "status" => 1,
        ]);
        $lastUserId = $user->id;
        //dd($lastUserId);
        $driverUpdate = Driver::find($lastDriverId);
        $driverUpdate->CLIENT_ID = $lastUserId;
        $driverUpdate->save();

        if ($driver && $user) {
            return redirect()->route('driver')->with('success', 'Driver Added Successfully!');
        } else {
            return redirect()->back()->with('failure', "Driver " . $request->input('') . ' Not added');
        }
    }

    public function quickDriverAdd(Request $request)
    {
        $this->validate(
            $request,
            [
                'FIRST_NAME' => 'required',
                'LAST_NAME' => 'required',
            ]
        );
        $driverEmail = $request->input('FIRST_NAME') . $request->input('LAST_NAME') . '@tmsdashboard.com';
        $emailExists = User::where('email', $driverEmail)->exists();

        if ($emailExists) {
            return redirect()->back()->with('error', 'First Name And Last Name Already Taken Pls Use Another Name.');
        }

        $user = Auth::user();
        // $userid = $request->get('userid');


        $driver = Driver::create([
            "FIRST_NAME" => $request->input('FIRST_NAME'),
            "LAST_NAME" => $request->input("LAST_NAME"),
            "USERNAME" => $request->input('FIRST_NAME') . $request->input('LAST_NAME'),
            "DRIVER_EMAIL" => $request->input('FIRST_NAME') . $request->input('LAST_NAME') . '@tmsdashboard.com',
            "PASSWORD" => date('mdY'),
            "pin_number" => 1234,
            "STATUS" => 0,
            "MEM_ID" => $user->id,
            "CREATED_DATE" => date('Y-m-d'),
        ]);

        $lastDriverId = $driver->SMART_DRIVERID;

        $mailurl = "https://tms.tmdashboard.com/sendgrid/newcard_order.php?ID=" . $lastDriverId;
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $mailurl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            )
        );
        $response = curl_exec($curl);
        curl_close($curl);

        $user = User::create([
            "username" => $driver->USERNAME,
            "email" => $driver->DRIVER_EMAIL,
            "password" => Hash::make($driver->PASSWORD),
            'pincode' => md5($driver->pin_number),
            "userlevel" => 'user',
            "status" => 1,
        ]);
        $lastUserId = $user->id;
        //dd($lastUserId);
        $driverUpdate = Driver::find($lastDriverId);
        $driverUpdate->CLIENT_ID = $lastUserId;
        $driverUpdate->save();

        if ($driver && $user) {
            return redirect()->route('driver')->with('success', 'Driver Added Successfully!');
        } else {
            return redirect()->back()->with('failure', "Driver " . $request->input('') . ' Not added');
        }
    }

    public function driver_actions(Request $request)
    {
        $this->validate($request, [
            'email' => 'required',
            'username' => 'required',
            'password_confirmation' => 'same:password'
        ]);

        $driverEmail = $request->email;
        $emailExists = User::where('email', $driverEmail)->exists();

        if ($emailExists) {
            return redirect()->back()->with('error', 'Email is Already Been Taken Pls Use Another Email.');
        }

        $user = User::find($request->input('userid'));
        if ($request->get('action') == 'update') {
            $driver = Driver::where('CLIENT_ID', $user->id)->first();
            $driver->DRIVER_EMAIL = $request->input('email');
            $driver->USERNAME = $request->input('username');
            $driver->PASSWORD = $request->input('password');
            $driver->pin_number = $request->input('pin_number');
            $driver->save();

            $userID = $driver->CLIENT_ID;
            if (!empty($userID)) {
                $userUpdate = User::find($userID);
                $userUpdate->username = $request->input('username');
                $userUpdate->email = $request->input("email");
                $userUpdate->password = Hash::make($request->input('password'));
                $userUpdate->pincode = md5($request->input('pin_number'));
                $userUpdate->two_factor = $request->input('two_factor');
                $userUpdate->save();
            }
            return redirect()->route('driver')->with('success', 'Driver Updated Successfully!');
        }

    }
    // action enable post

    public function view_driver($id, Request $request)
    {
        $user = Auth::user();
        $driver = Driver::find($id);

        $data['page_title'] = "Add Driver";
        $type = 'users';
        $data['type'] = $type;
        $data['page_class'] = $type;
        $data['action'] = 'addnew';
        $data['user_userlevel'] = $user->userlevel;
        $data['userlevel'] = 'user';
        $data['user_vip'] = '0';
        $data['user_viptime'] = '';
        $data['userid'] = '0';
        $data['user_status'] = '1';
        $data['username'] = '';
        $data['email'] = '';
        $data['admin_language'] = 'en';
        $data['user_permission'] = [];

        $country = Country::all();
        $estate = estate::all();
        $city = City::all();
        $state = State::all();
        $area = Area::all();
        return get_admin_view('driver.driver_edit', [
            'data' => $data,
            "driver" => $driver,
            "driver_view" => true,
            "estates" => $estate,
            "countrys" => $country,
            "citys" => $city,
            "states" => $state,
            "areas" => $area
        ]);

    }


    // action delete post
    public function index_deletedriver($id)
    {
        $driver = Driver::find($id);
        $drivername = $driver->first_name;
        $userID = $driver->CLIENT_ID;
        if (!empty($userID)) {
            $userUpdate = User::find($userID);
            $userUpdate->delete();
        }
        $driver = $driver->delete();
        if ($driver) {
            return redirect()->back()->with("success", "Driver $drivername deleted Successfully!");
        } else {
            return redirect()->back()->with("failure", "Driver $drivername deleted");
        }
    }

    public function driverCardDetails(Request $request)
    {
        $this->validate(
            $request,
            [
                'CARD_NUM' => 'required',
                'CSV_NUM' => 'required|digits:3',
                'EXPIRES' => 'required',
            ],
            [
                'CSV_NUM.digits' => 'Please Enter 3-digits CSV Number.'
            ]
        );

        $driver = Driver::find($request->id);
        $driver->CARD_NUM = $request->CARD_NUM;
        $driver->CSV_NUM = $request->CSV_NUM;
        $driver->EXPIRES = $request->EXPIRES;
        $driver->SUB_STATUS = 'Processed';

        $driver->update();

        return redirect()->route('driver')->with("success", "Driver's Details Updated Successfully!");
    }

    public function addLoadFunds($id)
    {
        $driver = Driver::find($id);
        $data['driver'] = $driver;
        $data['page_title'] = 'Add Load Funds';
        $driver = Driver::find($id);
        $data['status'] = 'INACTIVE';
        if ($driver->CARD_NUM != '') {
            $efs_data = array('clientID' => getEFSClientID(), 'cardNumber' => $driver->CARD_NUM);
            $return_data = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getcard_api.php', $efs_data);
            $clean_xml = str_ireplace(['soapenv:', 'SOAP:'], '', $return_data);
            $xml = simplexml_load_string($clean_xml);
            $response = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $return_data);
            $xml = new \SimpleXMLElement($response);
            $body = $xml->xpath('//soapenvBody')[0];
            $array_getCard = json_decode(json_encode((array) $body), TRUE);
            $data['status'] = $array_getCard['ns5getCardResponse']['result']['header']['status'];
        }
        return get_admin_view('driver.add_load_funds', ['data' => $data]);
    }

    public function storeLoadFunds(Request $request)
    {

        $this->validate($request, [
            'amount' => 'required',
            'issue_to' => 'required',
        ]);
        if ($request->amount <= 0) {
            return redirect()->back()->with('error', 'Amount Must Be Greater Then 0.');
        }
        $driver = Driver::find($request->driver_id);
        $card = $driver->CARD_NUM;
        $load_fund = new DriverFund();

        $load_fund->driver_id = $request->driver_id;
        $load_fund->amount = $request->amount;
        $load_fund->issue_to = $request->issue_to;
        $load_fund->notes = $request->notes;
        $load_fund->created_at = date('Y-m-d');
        $load_fund->save();
        $lastId = $load_fund->id;
        $message = 'Driver Fund Added Successfully!';
        if (!empty(Auth::user()->contract_id)) {
            $data = [
                'clientID' => getEFSClientID(),
                'cardNumber' => $card,
                'amount' => $load_fund->amount,
                'refNumber' => $load_fund->issue_to,
                'notes' => $load_fund->notes,
                'currency' => 'USD'
            ];
            if (env('EFS_ON', 0) == 1) {
                $return_data = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/loadCash_api.php', $data);
                $output = json_decode($return_data);
                $output1 = json_decode($return_data, true);
                if (!empty($output1['ns5issueMoneyCodeResponse']['result']['code'])) {
                    $res_code = $output1['ns5issueMoneyCodeResponse']['result']['code'];
                    $load_fund = DriverFund::find($lastId);
                    $load_fund->ref_id = $res_code;
                    $load_fund->update();
                    $message = 'Driver(EFS) Fund Added Successfully!';
                }
            }
        }
        return redirect()->route('driver')->with('success', );

    }

    public function driver_personal_data(Request $request)
    {
        // dd($request->all());
        $this->validate($request, [
            'ADDRESS' => 'required',
            'CITY' => 'required',
            'STATE' => 'required',
            'POSTAL' => 'required',
            'COUNTRY' => 'required',
            'DOB' => 'required',
            'SSN_NUM' => 'required',
            'DRIVER_PHONE' => 'required',
            'SUB_STATUS' => 'required'
        ]);
        $user = User::find($request->input('userid'));
        if ($request->get('action') == 'update') {
            $driver = Driver::where('CLIENT_ID', $user->id)->first();
            if ($request->set_smart_driver != '' && !empty($driver->CARD_NUM)) {
                $efsdata = [
                    'clientID' => getEFSClientID(),
                    'cardNumber' => $driver->CARD_NUM,
                    'firstName' => $driver->FIRST_NAME,
                    'lastName' => $driver->LAST_NAME,
                    'address' => $request->input('ADDRESS'),
                    'city' => $request->input('CITY'),
                    'state' => $request->input('STATE'),
                    'postalCode' => $request->input('POSTAL'),
                    'country' => $request->input('COUNTRY'),
                    'dob' => $request->input('DOB'),
                    'last4ss' => substr($request->input('SSN_NUM'), -4),
                    'email' => $driver->DRIVER_EMAIL,
                    'phone' => $request->input('DRIVER_PHONE')
                ];
                // dd($efsdata);
                $response = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/setSmartPayDriver_api.php', $efsdata);
            }
            if ($driver->SUB_STATUS != $request->input('SUB_STATUS')) {
                $driver_status = new DriverStatus();
                $driver_status->new_sub_status = $request->input('SUB_STATUS');
                $driver_status->old_sub_status = $driver->SUB_STATUS;
                $driver_status->driver_id = $driver->SMART_DRIVERID;
                $driver_status->date_time = date('Y-m-d');
                $driver_status->user_id = Auth::user()->id;
                $driver_status->save();
            }
            $driver->ADDRESS = $request->input('ADDRESS');
            $driver->CITY = $request->input('CITY');
            $driver->STATE = $request->input('STATE');
            $driver->POSTAL = $request->input('POSTAL');
            $driver->COUNTRY = $request->input('COUNTRY');
            $driver->DOB = $request->input('DOB');
            $driver->SSN_NUM = $request->input('SSN_NUM');
            $driver->DRIVER_PHONE = $request->input('DRIVER_PHONE');
            $driver->SUB_STATUS = $request->input('SUB_STATUS');
            $driver->save();
            // dd($driver->CARD_NUM);

            return redirect()->route('driver')->with('success', 'Driver Updated Successfully!');
        }
    }

    public function driver_card_pin(Request $request)
    {
        $this->validate($request, [
            'CARD_PIN' => 'required|digits:4',
        ], [
                'CARD_PIN.digits' => 'Please enter a 4-digit card PIN.',
            ]);

        $driver = Driver::find($request->driverid);
        $driver->STATUS = $request->get('STATUS');
        $driver->CARD_PIN = $request->get('CARD_PIN', null);
        $name = $driver->FIRST_NAME . ' ' . $driver->LAST_NAME;

        if ($driver->STATUS != $request->input('STATUS')) {
            $driver_status = new DriverStatus();
            $driver_status->new_status = $request->input('STATUS');
            $driver_status->old_status = $driver->STATUS;
            $driver_status->driver_id = $driver->SMART_DRIVERID;
            $driver_status->date_time = date('Y-m-d');
            $driver_status->user_id = Auth::user()->id;
            $driver_status->save();
        }

        if (!empty($driver->CARD_NUM)) {
            //setCard in EFS
            $cardNumber = $driver->CARD_NUM;
            $pin = $request->get('CARD_PIN');
            if (!empty($pin)) {
                $efsdata = [
                    'clientID' => getEFSClientID(),
                    'cardNumber' => $cardNumber,
                    'newPin' => $pin
                ];
                $response = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/setcardpin_api.php', $efsdata);
            }
        }

        if (!empty($driver->CARD_NUM)) {
            $data = array('clientID' => getEFSClientID(), 'cardNumber' => $driver->CARD_NUM);
            $return_data = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getcard_api.php', $data);
            $clean_xml = str_ireplace(['soapenv:', 'SOAP:'], '', $return_data);

            $xml = simplexml_load_string($clean_xml);
            $response = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $return_data);
            $xml = new \SimpleXMLElement($response);
            $body = $xml->xpath('//soapenvBody')[0];
            $array_getCard = json_decode(json_encode((array) $body), TRUE);
            $status = $driver->STATUS == '1' ? 'ACTIVE' : 'INACTIVE';

            if (!empty($array_getCard['ns5getCardResponse']['result']['header'])) {
                $header = $array_getCard['ns5getCardResponse']['result']['header'];
            } else {
                $header = array(
                    'companyXRef' => '',
                    'handEnter' => '',
                    'infoSource' => 'BOTH',
                    'limitSource' => '',
                    'locationOverride' => '',
                    'locationSource' => '',
                    'overrideAllLocations' => '',
                    'originalStatus' => '',
                    'payrollStatus' => 'FOLLOWS',
                    'override' => 0,
                    'policyNumber' => '0',
                    'status' => $status,
                    'timeSource' => 'BOTH',
                    'lastUsedDate' => '',
                    'lastTransaction' => '',
                    'payrollUse' => 'N',
                    'payrollAtm' => 'DISALLOW',
                    'payrollChk' => 'DISALLOW',
                    'payrollAch' => 'DISALLOW',
                    'payrollWire' => 'DISALLOW',
                    'payrollDebit' => 'DISALLOW'
                );
                //$header_json=json_encode($header,true);
            }

            $data = array('clientID' => getEFSClientID(), 'cardNumber' => $driver->CARD_NUM, 'status' => $status, 'NAME' => $name, 'UNIT' => '0', 'DRID' => $driver->SMART_DRIVERID, 'companyXRef' => $header['companyXRef'], 'handEnter' => $header['handEnter'], 'infoSource' => $header['infoSource'], 'limitSource' => $header['limitSource'], 'locationOverride' => $header['locationOverride'], 'locationSource' => $header['locationSource'], 'overrideAllLocations' => $header['overrideAllLocations'], 'originalStatus' => '', 'payrollStatus' => $header['payrollStatus'], 'override' => $header['override'], 'policyNumber' => $header['policyNumber'], 'timeSource' => $header['timeSource'], 'lastUsedDate' => '', 'lastTransaction' => $header['lastTransaction'], 'payrollUse' => $header['payrollUse'], 'payrollAtm' => $header['payrollAtm'], 'payrollChk' => $header['payrollChk'], 'payrollAch' => $header['payrollAch'], 'payrollWire' => $header['payrollWire'], 'payrollDebit' => $header['payrollDebit']);

            $data_setcard = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/setcard_api.php', $data);
            $data_return = json_decode($data_setcard, true);

        }

        $driver->update();

        return redirect()->route('driver')->with("success", "Driver's Details Updated Successfully!");
    }

    public function admin_driver_add(Request $request)
    {
        $this->validate(
            $request,
            [
                'FIRST_NAME' => 'required',
                'LAST_NAME' => 'required',
                'ADDRESS' => 'required',
                'CITY' => 'required',
                'STATE' => 'required',
                'POSTAL' => 'required',
                'COUNTRY' => 'required',
                'DOB' => 'required',
                'SSN_NUM' => 'required',
                'DRIVER_EMAIL' => 'required|unique:smartpay_driver',
                'DRIVER_PHONE' => 'required',
                'STATUS' => 'required',
                'SUB_STATUS' => 'required',
                'USERNAME' => 'required',
                'PASSWORD' => 'required',
                'pin_number' => 'required',
                'MEM_ID' => 'required',
            ],
            [
                'MEM_ID.required' => 'Company is required.'
            ]
        );

        $driverEmail = $request->DRIVER_EMAIL;
        $emailExists = User::where('email', $driverEmail)->exists();

        if ($emailExists) {
            return redirect()->back()->with('error', 'Email is Already Been Taken Pls Use Another Email.');
        }

        $user = Auth::user();

        $driver = Driver::create([
            "FIRST_NAME" => $request->input('FIRST_NAME'),
            "LAST_NAME" => $request->input("LAST_NAME"),
            "ADDRESS" => $request->input('ADDRESS'),
            "CITY" => $request->input('CITY'),
            "STATE" => $request->input('STATE'),
            "POSTAL" => $request->input('POSTAL'),
            "COUNTRY" => $request->input('COUNTRY'),
            "DOB" => $request->input('DOB'),
            "SSN_NUM" => $request->input('SSN_NUM'),
            "DRIVER_EMAIL" => $request->input('DRIVER_EMAIL'),
            "DRIVER_PHONE" => $request->input('DRIVER_PHONE'),
            "STATUS" => $request->input('STATUS'),
            "SUB_STATUS" => $request->input('SUB_STATUS'),
            "USERNAME" => $request->input('USERNAME'),
            "PASSWORD" => $request->input('PASSWORD'),
            "pin_number" => $request->input('pin_number'),
            "MEM_ID" => $request->MEM_ID,
            "CREATED_DATE" => date('Y-m-d'),
        ]);

        $lastDriverId = $driver->SMART_DRIVERID;

        $mailurl = "https://tms.tmdashboard.com/sendgrid/newcard_order.php?ID=" . $lastDriverId;
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $mailurl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            )
        );
        $response = curl_exec($curl);
        curl_close($curl);

        $user = User::create([
            "username" => $request->input('USERNAME'),
            "email" => $request->input("DRIVER_EMAIL"),
            "password" => Hash::make($request->input('PASSWORD')),
            'pincode' => md5($request->input('pin_number')),
            "userlevel" => 'user',
            "status" => 1,
        ]);
        $lastUserId = $user->id;
        //dd($lastUserId);
        $driverUpdate = Driver::find($lastDriverId);
        $driverUpdate->CLIENT_ID = $lastUserId;
        $driverUpdate->save();

        if ($driver && $user) {
            return redirect()->route('driver')->with('success', 'Driver Added Successfully!');
        } else {
            return redirect()->back()->with('failure', "Driver " . $request->input('') . ' Not added');
        }
    }

    public function adminQuickDriverAdd(Request $request)
    {
        $this->validate(
            $request,
            [
                'FIRST_NAME' => 'required',
                'LAST_NAME' => 'required',
                'MEM_ID' => 'required'
            ],
            [
                'MEM_ID.required' => 'Company Name Is Required.'
            ]
        );
        $driverEmail = $request->input('FIRST_NAME') . $request->input('LAST_NAME') . '@tmsdashboard.com';
        $emailExists = User::where('email', $driverEmail)->exists();

        if ($emailExists) {
            return redirect()->back()->with('error', 'First Name And Last Name Already Taken Pls Use Another Name.');
        }

        $user = Auth::user();
        // $userid = $request->get('userid');


        $driver = Driver::create([
            "FIRST_NAME" => $request->input('FIRST_NAME'),
            "LAST_NAME" => $request->input("LAST_NAME"),
            "USERNAME" => $request->input('FIRST_NAME') . $request->input('LAST_NAME'),
            "DRIVER_EMAIL" => $request->input('FIRST_NAME') . $request->input('LAST_NAME') . '@tmsdashboard.com',
            "PASSWORD" => date('mdY'),
            "pin_number" => 1234,
            "STATUS" => 0,
            "MEM_ID" => $request->MEM_ID,
            "CREATED_DATE" => date('Y-m-d'),
        ]);

        $lastDriverId = $driver->SMART_DRIVERID;

        $mailurl = "https://tms.tmdashboard.com/sendgrid/newcard_order.php?ID=" . $lastDriverId;
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $mailurl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            )
        );
        $response = curl_exec($curl);
        curl_close($curl);

        $user = User::create([
            "username" => $driver->USERNAME,
            "email" => $driver->DRIVER_EMAIL,
            "password" => Hash::make($driver->PASSWORD),
            'pincode' => md5($driver->pin_number),
            "userlevel" => 'user',
            "status" => 1,
        ]);
        $lastUserId = $user->id;
        //dd($lastUserId);
        $driverUpdate = Driver::find($lastDriverId);
        $driverUpdate->CLIENT_ID = $lastUserId;
        $driverUpdate->save();

        if ($driver && $user) {
            return redirect()->route('driver')->with('success', 'Driver Added Successfully!');
        } else {
            return redirect()->back()->with('failure', "Driver " . $request->input('') . ' Not added');
        }
    }

    public function get_cashavailable($driverId)
    {

        $driver = Driver::find($driverId);
        //setCard in EFS
        if ($driver->CARD_NUM != '') {
            $efsdata = [
                'clientID' => getEFSClientID(),
                'cardNumber' => $driver->CARD_NUM
            ];
            $response = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getcurrentcashall_api.php', $efsdata);
            $responseData = json_decode($response);
            $cashAvailable = 0;
            if (!empty($responseData->ns5getCurrentCashAllAmountsResponse)) {
                $cashAvailable = $responseData->ns5getCurrentCashAllAmountsResponse->result->value->cashAvailable;
                $driver->cashAvailable = $cashAvailable;
                $driver->save();
            }
            return $cashAvailable;
        } else {
            return '0.00';
        }
    }

    public function card_info($driverId)
    {
        $driver = Driver::find($driverId);
        if ($driver->CARD_NUM != '') {
            $efs_data = array('clientID' => getEFSClientID(), 'cardNumber' => $driver->CARD_NUM);
            $return_data = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getcard_api.php', $efs_data);
            $clean_xml = str_ireplace(['soapenv:', 'SOAP:'], '', $return_data);
            $xml = simplexml_load_string($clean_xml);
            $response = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $return_data);
            $xml = new \SimpleXMLElement($response);
            $body = $xml->xpath('//soapenvBody')[0];
            $array_getCard = json_decode(json_encode((array) $body), TRUE);

            return $array_getCard['ns5getCardResponse']['result'];
        }else{
            return $array_getCard['ns5getCardResponse']['result'] = [];
        }
    }

}



?>
