<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Graveyard;
use PHPUnit\Framework\Constraint\Count;

class GraveyardController extends Controller
{
    private $url_prefix;
    private $page_title;
    private $url_new;
    private $btn_new;
    private $paginate;

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->url_prefix   = 'Graveyard';
        $this->page_title   = 'Graveyard';
        $this->btn_new      = 'add_new';
        $this->url_new      = get_admin_url('graveyardadd');
        $this->paginate     = 5;
    }
    // index users
    public function index_graveyard($type = '',Request $request)
    {
       
       
        $data['type']       = 'users';
        $data['page_class'] = 'graveyard';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
        //if ($request->has('page') and $request->get('page') > $graveyard->lastPage()) {return redirect($graveyard->url($graveyard->lastPage()));}
        return get_admin_view('graveyard.index_graveyard',["data"=> $data]);
    }

    public function ajaxlist_graveyard(Request $request){
    
        if($request->ajax())
        {
            $data['type']       = 'users';
            $data['page_class'] = 'graveyard';
            $data['url_prefix'] = $this->url_prefix;
            $data['page_title'] = $this->page_title;
            $data['btn_new']    = $this->btn_new;
            $data['url_new']    = $this->url_new;
            $graveyard=new graveyard();
         
            $graveyard = $graveyard->orderBy('created_at', 'DESC');
          
            if($request->get('s')){
                $search = $request->get('s');
                $graveyard->orWhere('graveyard_name', 'LIKE', "%{$search}%");
                $graveyard->orWhere('graveyard_name_gj', 'LIKE', "%{$search}%");                                
                $graveyard->orWhere('created_at', 'LIKE', "%{$search}%");
            }
            $graveyard = $graveyard->paginate($this->paginate);
            if($request->has('page') and $request->get('page') > $graveyard->lastPage()) {
                return redirect($graveyard->url($graveyard->lastPage()));
            }
            return get_admin_view('graveyard.ajaxlist_graveyard', ["data"=> $data,'graveyards'=>$graveyard]);
        }
        
       }

       public function graveyard_profile($id =0, Request $request)
       {
      
           $curre_user = Auth::user();
          
           $user_id =  $curre_user->id;
      
           $graveyard=Graveyard::find($id);
        
           if($graveyard){
           
           $getuser = User::find($user_id);
          
           if ($getuser->count()) {
              
               $type               = 'users';
               $user               = $getuser->first();
               $data['user']       = $user;
               $data['type']       = $type;
               $data['page_class'] = $type;
               $data['action']     = 'update';
               $data['page_title'] = 'Update Graveyard';
               $data['user_meta']  = query_user_meta($data['user']->id);
           
               $datauser                   = $user;
               $data['user_userlevel']     = $curre_user->userlevel;
               $data['userlevel']          = $datauser->userlevel;
               $data['type']               = $datauser->userlevel;
               $data['page_class']         = $datauser->userlevel;
               $data['action']             = 'update';
               $data['userid']             = $datauser->id;
               $data['username']           = $datauser->username;
               $data['email']              = $datauser->email;
               $data['user_status']        = $datauser->status;
               $data['admin_language']     = get_user_meta('admin_language', $user_id, 'en');
               $permission                 = maybe_unserialize(get_user_meta('permission', $user_id, []));
               $data['user_permission']    = (is_array($permission))? $permission : [];
   
               return get_admin_view('graveyard.profile_graveyard', ["data"=>$data,"graveyard"=>$graveyard]);
                }
            }
       } 

       public function index_graveyardadd(Request $request)
       {
           $user = Auth::user();
           
           $data['page_title']         = "Add Graveyard";
           $type                       = 'users';
           $data['type']               = $type;
           $data['page_class']         = $type;
           $data['action']             = 'addnew';
           $data['user_userlevel']     = $user->userlevel;
           $data['userlevel']          = 'user';
           $data['user_vip']           = '0';
           $data['user_viptime']       = '';
           $data['userid']             = '0';
           $data['user_status']        = '1';
           $data['username']           = '';
           $data['email']              = '';
           $data['admin_language']     = 'en';
           $data['user_permission']    = [];
           return get_admin_view('graveyard.graveyard_edit', ['data'=>$data]);
       }
   
       // send form
       public function graveyard_sendform(Request $request)
       {
          
          
           $user = Auth::user();
       
           $userid = $request->get('userid');
           $graveyard=Graveyard::create(["graveyard_name"=>$request->input('graveyard_name'),"graveyard_name_gj"=>$request->input("graveyard_name_gj")]);
           if($graveyard){
               return redirect()->back()->with('success','graveyard '.$request->input('graveyard_name') . ' added Successfully!');
             }else{
               return redirect()->back()->with('failure', "graveyard ".$request->input('graveyard_name') . ' Not added');
             }
        
       
          // return redirect(get_admin_url('profile/'.$user_id))->with("success", $success);
       }
   
   
       // actions post
       public function graveyard_actions(Request $request)
       {
        
           if($request->has('query') && $request->get('query') == 'action')
           {
             
                if($request->get('action') == 'update')
               {
                
                   $graveyard=Graveyard::find($request->input('id'));
                   $graveyard->graveyard_name = $request->input('graveyard_name');
                   $graveyard->graveyard_name_gj = $request->input('graveyard_name_gj');
                   
                   if($graveyard->save()){
                       return redirect()->back()->with("success", "graveyard Updated successfully!");
                   }else{
                       return redirect()->back()->with("failure", "graveyard Not Updated!");
                   }
               }
      else{
               $marks = $request->get('mark');
                if(empty($marks)){
                   return redirect()->back();
                }
              
                $faileditem=0;
                $success="";
               if($request->get('action') == 'delete' and is_array($marks))
               {
                 
                   foreach($marks as $markid)
                   {
                    
                      $success= Graveyard::find($markid)->delete();
                      if(empty($success)){
                       $faileditem= $faileditem+1;
                      }
                   }
                 
                   if($faileditem==0){
                       
                    $request->session()->put("success", "Selected Items are Deleted Successfully!");
                       return redirect()->back();
                   }
                   else if($faileditem!=0){
                    $request->session()->put("failure","Selected Items are deleted except $faileditem Graveyard");
                       return redirect()->back();
                   }
                   else{
                    $request->session()->put("failure","Selected Items are not deleted");
                       return redirect()->back();
                   }
               }
            
   
               
           }
       }
       }
      
   
   
   
       // action delete graveyard
       public function index_deletegraveyard($id, $token,Request $request)
       { 
         $graveyard=Graveyard::find($id);
         $graveyardname=$graveyard->graveyard_name;
         $graveyard=$graveyard->delete();
         if($graveyard){
            $request->session()->put("success", "Graveyard $graveyardname deleted Successfully!");
            return redirect()->back();
    
         }else{
            $request->session()->put("failure", "Graveyard $graveyardname Not deleted");
            return redirect()->back();
         }
       }




}
