<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\Driver;
use App\Models\User;
use App\Models\DriverFund;
use Image;

class UsersController extends Controller
{
    private $url_prefix;
    private $page_title;
    private $url_new;
    private $btn_new;
    private $paginate;

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->url_prefix   = 'user';
        $this->page_title   = admin_lang('users');
        $this->btn_new      = admin_lang('add_new');
        $this->url_new      = get_admin_url('useradd');
        $this->paginate     = 25;
    }
    // index users
    public function index_users(Request $request,$type = '')
    {

        $data['type']       = 'users';
        $data['page_class'] = 'users';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
        $users = DB::table(USERS_TABLE)->orderBy('created_at', 'DESC')->orderBy('status', 'ASC');
        if($type){
            $users->where('userlevel', $type);
        }
        if($request->get('s')){
            $search = $request->get('s');
            $users->orWhere('username', 'LIKE', "%{$search}%");
            $users->orWhere('email', 'LIKE', "%{$search}%");
        }
        $users = $users->paginate($this->paginate);
        if ($request->has('page') and $request->get('page') > $users->lastPage()) {return redirect($users->url($users->lastPage()));}
        $data['users'] = $users;
        return get_admin_view('users.index_users', $data);
    }
    // index users
    public function index_users_ip($ip, Request $request)
    {
        $data['page_title'] = $this->page_title.' :: IP: '.$ip;
        $data['type']       = 'users';
        $data['page_class'] = 'users';
        $data['url_prefix'] = $this->url_prefix;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
        $users = DB::table(USERS_TABLE)->leftJoin('usersmeta', 'users.id', '=', 'usersmeta.user_id')->where([
            ['meta_key', '=', 'ipaddress'],
            ['meta_value', '=', $ip]
        ]);
        if($request->get('s')){
            $search = $request->get('s');
            $users->orWhere('username', 'LIKE', "%{$search}%");
            $users->orWhere('email', 'LIKE', "%{$search}%");
        }
        $users = $users->paginate($this->paginate);
        if ($request->has('page') and $request->get('page') > $users->lastPage()) {return redirect($users->url($users->lastPage()));}
        $data['users'] = $users;
        return get_admin_view('users.index_users', $data);
    }
    // index users
    public function index_users_browser($browser, Request $request)
    {
        $data['page_title'] = $this->page_title.' :: Browser: '.$browser;
        $data['type']       = 'users';
        $data['page_class'] = 'users';
        $data['url_prefix'] = $this->url_prefix;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
        $users = DB::table(USERS_TABLE)->leftJoin('usersmeta', 'users.id', '=', 'usersmeta.user_id')->where([
            ['meta_key', '=', 'browserfamily'],
            ['meta_value', '=', $browser]
        ]);
        if($request->get('s')){
            $search = $request->get('s');
            $users->orWhere('username', 'LIKE', "%{$search}%");
            $users->orWhere('email', 'LIKE', "%{$search}%");
        }
        $users = $users->paginate($this->paginate);
        if ($request->has('page') and $request->get('page') > $users->lastPage()) {return redirect($users->url($users->lastPage()));}
        $data['users'] = $users;
        return get_admin_view('users.index_users', $data);
    }
    // index users
    public function index_users_platform($platform, Request $request)
    {
        $data['page_title'] = $this->page_title.' :: Plat Form: '.$platform;
        $data['type']       = 'users';
        $data['page_class'] = 'users';
        $data['url_prefix'] = $this->url_prefix;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
        $users = DB::table(USERS_TABLE)->leftJoin('usersmeta', 'users.id', '=', 'usersmeta.user_id')->where([
            ['meta_key', '=', 'platformname'],
            ['meta_value', '=', $platform]
        ]);
        if($request->get('s')){
            $search = $request->get('s');
            $users->orWhere('username', 'LIKE', "%{$search}%");
            $users->orWhere('email', 'LIKE', "%{$search}%");
        }
        $users = $users->paginate($this->paginate);
        if ($request->has('page') and $request->get('page') > $users->lastPage()) {return redirect($users->url($users->lastPage()));}
        $data['users'] = $users;
        return get_admin_view('users.index_users', $data);
    }
    // index profile
    public function index_profile(Request $request,$id = false)
    {
        $curre_user = Auth::user();

        $user_id = ($id)? $id : $curre_user->id;

        if(!is_permission('users') and $curre_user->id != $user_id) {
            return redirect(get_admin_url('profile'));
        }

        if($id and $curre_user->id == $user_id) {
            return redirect(get_admin_url('profile'));
        }


        $getuser = DB::table(USERS_TABLE)->where([['id', '=', $user_id]])->get();
        if ($getuser->count()) {
            $type               = 'users';
            $user               = $getuser->first();
            $data['user']       = $user;
            $data['type']       = $type;
            $data['page_class'] = $type;
            $data['action']     = 'update';
            $data['page_title'] = admin_lang('profile').' '.$data['user']->username;
            $data['user_meta']  = query_user_meta($data['user']->id);


            $loop_comments  = DB::table(COMMENTS_TABLE)
            ->where([['cuid', '=', $user_id], ['spam_trash', '=', '0']])
            ->orderBy('cstatus', 'ASC')
            ->orderBy('cmodified', 'DESC')
            ->paginate(25);
            if ($request->has('page') and $request->get('page') > $loop_comments->lastPage()) {return redirect($loop_comments->url($loop_comments->lastPage()));}
            $data['loop_comments'] = $loop_comments;
            $data['signintime'] = get_user_meta('signintime', $user->id);
            $data['details']['ip'] = get_user_meta('ip', $user->id);
            $data['details']['useragent'] = get_user_meta('useragent', $user->id);
            $data['details']['platformname'] = get_user_meta('platformname', $user->id);
            $data['details']['browserfamily'] = get_user_meta('browserfamily', $user->id);
            $datauser                   = $user;
            $data['user_userlevel']     = $curre_user->userlevel;
            $data['userlevel']          = $datauser->userlevel;
            $data['type']               = $datauser->userlevel;
            $data['page_class']         = $datauser->userlevel;
            $data['action']             = 'update';
            $data['userid']             = $datauser->id;
            $data['username']           = $datauser->username;
            $data['email']              = $datauser->email;
            $data['contract_id']        = $datauser->contract_id;
            $data['ar_id']              = $datauser->ar_id;
            $data['user_status']        = $datauser->status;
            $data['admin_language']     = get_user_meta('admin_language', $user_id, 'en');
            $permission                 = maybe_unserialize(get_user_meta('permission', $user_id, []));
            $data['user_permission']    = (is_array($permission))? $permission : [];
            return get_admin_view('users.profile_user',["data"=>$data]);
        }
    }

     // index profile driver
     public function index_profile_driver(Request $request,$id = false)
     {
         $curre_user = Auth::user();
         $user_id = ($id)? $id : $curre_user->id;

         if(!is_permission('users') and $curre_user->id != $user_id) {
             return redirect(get_admin_url('driverprofile'));
         }

         if($id and $curre_user->id == $user_id) {
             return redirect(get_admin_url('driverprofile'));
         }


         $getuser = DB::table(USERS_TABLE)->where([['id', '=', $user_id]])->get();

         $driver  = Driver::where('CLIENT_ID',$user_id)->first();

         if ($getuser->count()) {
             $type               = 'users';
             $user               = $getuser->first();
             $data['user']       = $user;
             $data['type']       = $type;
             $data['page_class'] = $type;
             $data['action']     = 'update';
             $data['page_title'] = admin_lang('profile').' '.$data['user']->username;
             $data['user_meta']  = query_user_meta($data['user']->id);


             $loop_comments  = DB::table(COMMENTS_TABLE)
             ->where([['cuid', '=', $user_id], ['spam_trash', '=', '0']])
             ->orderBy('cstatus', 'ASC')
             ->orderBy('cmodified', 'DESC')
             ->paginate(10);
             if ($request->has('page') and $request->get('page') > $loop_comments->lastPage()) {return redirect($loop_comments->url($loop_comments->lastPage()));}
             $data['loop_comments'] = $loop_comments;
             $data['signintime'] = get_user_meta('signintime', $user->id);
             $data['details']['ip'] = get_user_meta('ip', $user->id);
             $data['details']['useragent'] = get_user_meta('useragent', $user->id);
             $data['details']['platformname'] = get_user_meta('platformname', $user->id);
             $data['details']['browserfamily'] = get_user_meta('browserfamily', $user->id);
             $datauser                   = $user;
             $data['user_userlevel']     = $curre_user->userlevel;
             $data['userlevel']          = $datauser->userlevel;
             $data['type']               = $datauser->userlevel;
             $data['page_class']         = $datauser->userlevel;
             $data['action']             = 'update';
             $data['userid']             = $datauser->id;
             $data['username']           = $datauser->username;
             $data['email']              = $datauser->email;
             $data['user_status']        = $datauser->status;
             $data['admin_language']     = get_user_meta('admin_language', $user_id, 'en');
             $permission                 = maybe_unserialize(get_user_meta('permission', $user_id, []));
             $data['user_permission']    = (is_array($permission))? $permission : [];
             $data['driver']             = $driver;
             $data['driver_fund'] = DriverFund::where('driver_id', Auth::user()->id)->get();
             $apiData = [];
                if ($driver->CARD_NUM) {
                    $efsData = [
                        'clientID' => getEFSClientID(),
                        'cardNumber' => $driver->CARD_NUM
                    ];
                    $response = CallApi('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getSmartPayDriver_api.php', $efsData);
                    $responseData = json_decode($response);
                    if (!empty($responseData->ns5getSmartPayDriverResponse->result)) {
                        $apiData = $responseData->ns5getSmartPayDriverResponse->result;
                        $data['driver']->FIRST_NAME = $apiData->firstName;
                        $data['driver']->LAST_NAME = $apiData->lastName;
                        $data['driver']->ADDRESS = $apiData->address;
                        $data['driver']->CITY = $apiData->city;
                        $data['driver']->STATE = $apiData->state;
                        $data['driver']->POSTAL = $apiData->postalCode;
                        $data['driver']->COUNTRY = $apiData->country;
                        $data['driver']->DOB = $apiData->dob;
                        if (empty($data['driver']->SSN_NUM)) {
                            $data['driver']->SSN_NUM = '000-00-'.$apiData->last4ss;
                        }
                        $data['driver']->DRIVER_EMAIL = $apiData->email;
                        $data['driver']->DRIVER_PHONE = $apiData->phone;
                    }
                }
             return get_admin_view('users.profiledriver_user',["data"=>$data, "apiData"=>$apiData]);
         }
     }

    // index profile
    public function index_useradd(Request $request)
    {
        $user = Auth::user();

        $data['page_title']         = admin_lang('add_user');
        $type                       = 'users';
        $data['type']               = $type;
        $data['page_class']         = $type;
        $data['action']             = 'addnew';
        $data['user_userlevel']     = $user->userlevel;
        $data['userlevel']          = 'user';
        $data['user_vip']           = '0';
        $data['user_viptime']       = '';
        $data['userid']             = '0';
        $data['user_status']        = '1';
        $data['username']           = '';
        $data['email']              = '';
        $data['admin_language']     = 'en';
        $data['user_permission']    = [];

        return get_admin_view('users.user_edit',["data"=>$data]);
    }

    // send form
    public function users_sendform(Request $request)
    {

        $user = Auth::user();
        $avatar_upload_path = public_path() . '/uploads/avatar';
        $cover_upload_path = public_path() . '/uploads/usercover';
        $userlevel  = $request->get('userlevel');
        $userid     = $request->get('userid');
        $profileURL = get_admin_url('profile');
        if($user->userlevel == "user"){
            $profileURL = get_admin_url('driverprofile');
        }
        if($user->userlevel != 'admin' and ($request->get('action') != 'update' AND $request->get('action') != 'setcardpin'))
        {
            return redirect($profileURL);
        }


        if($user->userlevel != 'admin' and $user->id != $request->get('userid'))
        {
            return redirect($profileURL);
        }

        /*setPincode*/
        if($request->get('action') == 'setcardpin'){
            $driverId=safe_input($request->get('driverid'), false);
            $driver  = Driver::where('CLIENT_ID',$user->id)->first();
            $driver->CARD_PIN=$request->get('CARD_PIN', null);
            if(!empty($driver->CARD_NUM)){
                //setCard in EFS
                $cardNumber=$driver->CARD_NUM;
                $pin=$request->get('CARD_PIN');
                if(!empty($pin)){
                $efsdata = [
                    'clientID' => getEFSClientID(),
                    'cardNumber' => $cardNumber,
                    'newPin'=>$pin
                ];
                $response = CallAPI('POST','https://tms.tmdashboard.com/api/esfAPIS/setcardpin_api.php',$efsdata);
            }
            }
            $driver->save();
            return redirect($profileURL);
            exit(0);
        }
        /*setPincode*/

        $rules = [
            'username'  => 'required|unique:users,username,'.$userid,
            'email'     => 'required|email|unique:users,email,'.$userid
        ];

        $messages = [
            'username.required'     => admin_lang('username_required'),
            'username.unique'       => admin_lang('username_not_unique'),
            'email.required'        => admin_lang('email_required'),
            'email.email'           => admin_lang('email_correct'),
            'email.unique'          => admin_lang('email_not_unique'),
        ];

        if($request->get('action') == 'addnew'){
            $rules['password']              = 'required|confirmed';
            $messages['password.required']  = admin_lang('password_required');
            $messages['password.confirmed'] = admin_lang('confirm_password_not_match');
            if($userlevel == 'admin'){
                $rules['pincode']               = 'required';
                $messages['pincode.required']   = admin_lang('pincode_required');
            }
        }

        $this->validate($request, $rules, $messages);

        if($request->get('action') == 'update'){
            $user_id = $request->get('userid');
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update([
                'username'          => safe_input($request->get('username'), false),
                'email'             => safe_input($request->get('email'), false),
                'two_factor'        => safe_input($request->get('two_factor'), false),
                'updated_at'        => now(),
            ]);
            if($user->userlevel == "user"){
            $driver = Driver::where('CLIENT_ID', $user_id)->first();
                $driver->DRIVER_EMAIL = safe_input($request->get('email'), false);
                $driver->USERNAME = safe_input($request->get('username'), false);

                $driver->update();
        }
        }
        else {
            $user_id = DB::table(USERS_TABLE)->insertGetId([
                'username'          => safe_input($request->get('username'), false),
                'email'             => safe_input($request->get('email'), false),
                'remember_token'    => NULL,
                'active_key'        => NULL,
                'updated_at'        => now(),
                'created_at'        => now(),
            ]);
        }

        if($user->userlevel == 'admin'){
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update([
                'userlevel' => safe_input($request->get('userlevel'), false),
                'status'    => safe_input($request->get('status'), false)
            ]);

            if($request->has('permission')){
                update_user_meta('permission', maybe_serialize($request->get('permission')), $user_id);
            }
        }

        // update password
        if($request->has('password') and !empty($request->get('password'))){
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update(['password' => Hash::make($request->get('password'))]);
            if($user->userlevel == "user"){
                $driver = Driver::where('CLIENT_ID', $user_id)->first();
                    $driver->PASSWORD = safe_input($request->get('password'), false);

                    $driver->update();
            }
        }

        // update pincode
        if($request->has('pincode') and !empty($request->get('pincode'))){
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update(['pincode' => md5($request->get('pincode'))]);
            if($user->userlevel == "user"){
                $driver = Driver::where('CLIENT_ID', $user_id)->first();
                    $driver->pin_number = safe_input($request->get('pincode'), false);

                    $driver->update();
            }
        }

        // admin language
        update_user_meta('admin_language', safe_input($request->get('admin_language'), false), $user_id);

        // update usermeta
        if ($request->has('usermeta')) {
            foreach ($request->get('usermeta') as $key => $value) {
                update_user_meta($key, $value, $user_id);
            }
        }

        // update avatar
        if($request->hasFile('avatar')) {
            $path_upload = 'uploads/avatar';
            $file        = $request->file('avatar');
            $file_name   = 'avatar-'.$user_id.'.'.$file->getClientOriginalExtension();
            $file->move(public_path($path_upload), $file_name);
            $avatar = Image::canvas(100, 100, '#ffffff');
            $image  = Image::make(public_path($path_upload).'/'.$file_name)->resize(100, 100, function ($c) {$c->aspectRatio();$c->upsize();});
            $avatar->insert($image, 'center');
            $avatar->save(public_path($path_upload).'/'.$file_name);
            update_user_meta('avatar', $file_name, $user_id);
        }

        // update cover
        if ($request->hasFile('cover')) {
            $path_upload = 'uploads/usercover';
            $file_name   = 'cover-'.$user_id.'.'.$request->cover->getClientOriginalExtension();
            $request->cover->move(public_path($path_upload).'/', $file_name);
            update_user_meta('cover', $file_name, $user_id);
        }

        if($request->has('action') == 'update'){
            $success = admin_lang('msg_profile_updated');
        }
        else {
            $success =  admin_lang('msg_user_add');
        }
        // redirect
        if(Auth::user()->userlevel == 'user'){
            return redirect(get_admin_url('driverprofile'))->with("success", $success);
        }
        return redirect(get_admin_url('profile/'.$user_id))->with("success", $success);
    }


    // actions post
    public function users_actions(Request $request)
    {
        if($request->has('query') && $request->get('query') == 'action')
        {
            $marks = $request->get('mark');
            if($request->get('action') == 'enable' and is_array($marks))
            {
                foreach($marks as $markid)
                {
                    DB::table(USERS_TABLE)->where(['id' => $markid])->update(['status' => '1']);
                }
                $success = admin_lang('msg_enable_selected');
            }
            elseif($request->get('action') == 'disable' and is_array($marks))
            {
                foreach($marks as $markid)
                {
                    DB::table(USERS_TABLE)->where(['id' => $markid])->update(['status' => '0']);
                }
                $success = admin_lang('msg_disable_selected');
            }
            elseif($request->get('action') == 'delete' and is_array($marks))
            {
                foreach($marks as $markid)
                {
                    DB::table(USERS_TABLE)->where(['id' => $markid])->delete();
                }
                $success = admin_lang('msg_delete_selected');
            }
            else {
                $success = admin_lang('msg_noselectaction');
            }
            return redirect()->back()->with("success", $success);
        }
    }
    // action enable post
    public function index_enableuser($id)
    {
        DB::table(USERS_TABLE)->where(['id' => $id])->update(['status' => '1']);
        return redirect()->back()->with("success", admin_lang('msg_user_enable'));
    }
    // action disable post
    public function index_disableuser($id)
    {
        DB::table(USERS_TABLE)->where(['id' => $id])->update(['status' => '0']);
        return redirect()->back()->with("success", admin_lang('msg_user_disable'));
    }
    // action delete post
    public function index_deleteuser($id, $token)
    {
        DB::table(USERS_TABLE)->where(['id' => $id])->delete();
        DB::table(USERSMETA_TABLE)->where(['user_id' => $id])->delete();
        return redirect()->back()->with("success", admin_lang('msg_user_delete'));
    }

    public function personalDataAdd(Request $request)
    {
        $this->validate($request, [
            'ADDRESS' => 'required',
            'CITY' => 'required',
            'STATE' => 'required',
            'POSTAL' => 'required',
            'COUNTRY' => 'required',
            'DOB' => 'required',
            'SSN_NUM' => 'required',
            'DRIVER_PHONE' => 'required',
        ]);

        $driver = Driver::find($request->driverid);

        $driver->ADDRESS = $request->ADDRESS;
        $driver->CITY = $request->CITY;
        $driver->STATE = $request->STATE;
        $driver->POSTAL = $request->POSTAL;
        $driver->COUNTRY = $request->COUNTRY;
        $driver->DOB = $request->DOB;
        $driver->SSN_NUM = $request->SSN_NUM;
        $driver->DRIVER_PHONE = $request->DRIVER_PHONE;

        if(!empty($driver->CARD_NUM)) {
            $efsdata = [
                'clientID' => getEFSClientID(),
                'cardNumber' =>$driver->CARD_NUM,
                'firstName'=>$driver->FIRST_NAME,
                'lastName'=>$driver->LAST_NAME,
                'address'=>$driver->ADDRESS,
                'city'=>$driver->CITY,
                'state'=>$driver->STATE,
                'postalCode'=>$driver->POSTAL,
                'country'=>$driver->COUNTRY,
                'dob'=>date('d/m/Y', strtotime($driver->DOB)),
                'last4ss'=>substr($driver->SSN_NUM,-4),
                'email'=>$driver->DRIVER_EMAIL,
                'phone'=>str_replace(['(', ')', '-'], '', $driver->DRIVER_PHONE)
            ];
           $response = CallAPI('POST','https://tms.tmdashboard.com/api/esfAPIS/setSmartPayDriver_api.php',$efsdata);
        }

        $driver->update();

        return redirect()->back()->with('success', 'Personal Data Updated Successfully');

    }


}
