<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use TorMorten\Eventy\Facades\Events as Eventy;
use hisorange\BrowserDetect\Parser as Browser;
use Illuminate\Support\Facades\Auth;
use Mail;
use Illuminate\Support\Str;

class FrontController extends Controller
{

    public $send_username = '';
    public $send_email = '';

    public function __construct()
    {
        parent::__construct();
    }
    
    /**
     * maintenance
     */
    public function maintenance(Request $request)
    {
        if(get_option('maintenance_status'))
        {
            $data['page_title'] = lang('maintenance');
            if(get_option('maintenance_date')){
                $date = explode('-', get_option('maintenance_date'));
                $data['maintenance_day']    = (isset($date['0']))? $date['0'] : date('d');
                $data['maintenance_month']  = (isset($date['1']))? $date['1'] : date('m',strtotime('+10 days'));
                $data['maintenance_year']   = (isset($date['2']))? $date['2'] : date('Y');
            }
            else {
                $data['maintenance_day']    = date('d');
                $data['maintenance_month']  = date('m',strtotime('+10 days'));
                $data['maintenance_year']   = date('Y');
            }

            return get_view('maintenance', $data);
        }
        else {
            return redirect(url('/'));
        }
    }
    
    /**
     * Home
     */
    public function home(Request $request)
    {
        return redirect(url('/admincp'));
        $data['page_title'] =  lang('home');
        $data_def['page_title'] = lang('home');
        $data = Eventy::filter('filter_data_home', $data_def);
        return get_view('home.home', $data);
    }
    
    /**
     * page
     */
    public function page($slug, Request $request)
    {
        $slug = utf8_uri_encode($slug);
        $post = DB::table(POSTS_TABLE)->where(['post_status' => '1', 'post_type' => 'pages', 'post_name' => $slug])->get();
        if ($post->count()) {
            $single     = $post->first();
            update_post_views($single->id);
            $data['single']         = $single;
            $data['page_title']     = $single->post_title;
            $data['sub_header']     = $single->post_title;
            $data['breadcrumbs'][]  = ['link' => false, 'title' => $single->post_title];
            $data['page_style']     = get_post_meta('page_style', $single->id, 'full');
            $data['post_slider']    = false;
            $data['post_type']      = 'pages';
            $data['post_meta']      = query_posts_meta($single->id);
            $data['post_thumbnail'] = get_thumbnail($data['post_meta']['thumbnails']);
            $template               = ($data['post_meta']['template'])? $data['post_meta']['template'] : 'default';

            if($single->comment_status and $template == 'default'){
                $comments           = get_loop_comments_single($single->post_type, $single->id, $request);
                $data['comments']   = $comments;
            }

            $data = Eventy::filter('filter_data_page_'.$template, $data);

            return get_view('pages.page_'.$template, $data);
        } else {
            return redirect('/');
        }
    }

    /**
     * send_comment
     */
    public function send_comment(Request $request)
    {

        if(Auth::check()){
            $rules = [
                'comment' => 'required',
            ];
    
            $message = [
                'required' => lang('the_field_required'),
            ];
        }
        else{
            $rules = [
                'username'  => 'required',
                'email'     => 'required|email',
                'comment'   => 'required',
            ];
    
            $message = [
                'required'      => lang('the_field_required'),
                'email.email'   => lang('error_email'),
            ];
        }

        if(get_option_inarray('apikeys_options', 'captcha_status')){
            $rules['g-recaptcha-response'] = 'required|recaptcha';
            $message['g-recaptcha-response.required']   = lang('complete_the_captcha');
            $message['g-recaptcha-response.recaptcha']  = lang('captcha_verification_failed');
        }

        $this->validate($request, $rules, $message);

        $comment        = safe_input($request->get('comment'));
        $pid            = safe_input(intval($request->get('pid')));
        $commenttype    = safe_input($request->get('commenttype'));
        $cstatus        = (get_option('comment_status_status'))? get_option('comment_status_status') : '0';
    
        $comment_id = DB::table(COMMENTS_TABLE)->insertGetId([
            'cpid'              => $pid,
            'cuid'              => (Auth::check())? Auth::user()->id : 0,
            'cuname'            => (Auth::check())? Auth::user()->username : safe_input($request->get('username')),
            'cuemail'           => (Auth::check())? Auth::user()->email : safe_input($request->get('email')),
            'ccontent'          => $comment,
            'cmodified'         => time(),
            'ctype'             => $commenttype,
            'ip'                => GetRealIp(),
            'useragent'         => Browser::userAgent(),
            'platformname'      => Browser::platformName(),
            'platformfamily'    => Browser::platformFamily(),
            'browserfamily'     => Browser::browserFamily(),
            'cparent'           => '0',
            'cstatus'           => $cstatus,
            'spam_trash'        => '0',
        ]);

        $message = ($cstatus)? lang('comment_has_add') : lang('comment_has_add_and_review');
        return redirect()->back()->with("success", $message);
    }
    
    /**
     * send contact
     */
    public function send_contact(Request $request)
    {

        $rules = [
            'username'  => 'required',
            'email'     => 'required|email',
            'subject'   => 'required',
            'message'   => 'required',
        ];

        $message = [
            'required'      => lang('the_field_required'),
            'email.email'   => lang('error_email'),
        ];

        if(get_option_inarray('apikeys_options', 'captcha_status')){
            $rules['g-recaptcha-response'] = 'required|recaptcha';
            $message['g-recaptcha-response.required']   = lang('complete_the_captcha');
            $message['g-recaptcha-response.recaptcha']  = lang('captcha_verification_failed');
        }

        $this->validate($request, $rules, $message);

        $send_contact  = get_option_inarray('contact', 'send_contact', 'both');

        if(in_array($send_contact, ['email', 'both'])){
            $mail_data = [
                'msg_subject'   => safe_input($request->get('subject')),
                'msg_name'      => safe_input($request->get('username')),
                'msg_email'     => safe_input($request->get('email')),
                'msg_content'   => safe_textarea($request->get('message')),
            ];

            $this->send_username = safe_input($request->get('username'));
            $this->send_email = safe_input($request->get('email'));

            if(env('IS_MAILER')) {
                Mail::send('emails.contact', $mail_data, function ($message) {
                    $message->to(get_option('webmaster_email'))->replyTo($this->send_email, $this->send_username)->subject(lang('email_training_contact', ['name' => $this->send_username]));
                });
            }
        }

        
        
        if(in_array($send_contact, ['database', 'both'])){
            $post_excerpts = maybe_serialize([
                'username'  => safe_input($request->get('username')),
                'email'     => safe_input($request->get('email')),
            ]);

            $message_id = DB::table(POSTS_TABLE)->insertGetId([
                'post_author'       => 0,
                'post_title'        => safe_input($request->get('subject')),
                'post_excerpts'     => $post_excerpts,
                'post_content'      => safe_textarea($request->get('message')),
                'post_status'       => 0,
                'post_type'         => 'contactus',
            ]);

            $browser_detect = [
                'ip'                => GetRealIp(),
                'useragent'         => Browser::userAgent(),
                'platformname'      => Browser::platformName(),
                'platformfamily'    => Browser::platformFamily(),
                'browserfamily'     => Browser::browserFamily(),
            ];
            update_post_meta('browser_detect', maybe_serialize($browser_detect), $message_id);
        }

        return redirect()->back()->with("success", lang('message_has_been_sent'));
    }

}
