<?php

namespace App\Http\Middleware;

use Illuminate\Support\Facades\Auth;
use Closure;
use Illuminate\Http\Request;


class PermissionMiddleware
{
    

    public function __construct()
    {
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */

    public function handle(Request $request, Closure $next, $role)
    {
        $roles=['admin', 'supervisor', 'new', 'user'];
        if (Auth::check() && in_array(Auth::user()->userlevel, $roles)) {
                if(!in_array(Auth::user()->userlevel, ['admin'])){
                    if(!is_permission($role)){
                        return redirect(get_admin_url('/'));
                    }
                }
                return $next($request);
        } else {
            return redirect(get_admin_url('login'));
        }
    }

}
