<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BookRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        
        return [
            'book_no' => 'required|numeric',
            'receipt_start' => 'required|numeric',
            'receipt_end' => 'required|numeric'
        ];


        
    }
    public function messages()
    {
        return [
            'book_no.required' => 'Book Number is required And Enter olny Number',
            'receipt_start.required' => 'Receipt Start is required And Enter olny Number',
            'receipt_end.required' => 'Receipt End is required And Enter olny Number'
        ];
    }
}
