<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Driver;


class DriverFund extends Model
{
    use HasFactory;

    protected $table="driver_fund";
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public $timestamps = false;

    protected $fillable = [
        'driver_id',
        'amount',
        'issue_to',
        'notes',
        'ref_id',
    ];

    public function drivers()
    {
        return $this->belongsTo('App\Models\Driver', 'driver_id', 'SMART_DRIVERID');
    }

}
