<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeceasedInformerTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('deceased_informer', function (Blueprint $table) {
            $table->bigIncrements('id'); 
            $table->bigInteger('deceased_id')->nullable();
            $table->string('informer_name')->nullable();
            $table->string('informer_mobileno')->nullable();
            $table->string('informer_alt_mobileno')->nullable();
            $table->text('informer_address')->nullable();
            $table->integer('informer_area_id')->nullable();            
            $table->integer('informer_city_id')->nullable();
            $table->integer('informer_state_id')->nullable();
            $table->integer('informer_country_id')->nullable();
            $table->integer('informer_pincode')->nullable(); 
            $table->enum('informer_relation',array('father', 'son', 'brother'))->nullable();
            $table->string('informer_id_proof_file')->nullable();            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deceased_informer');
    }
}
