<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeceasedMasterCorrectionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('deceased_master_correction', function (Blueprint $table) {
            $table->bigIncrements('id'); 
            $table->integer('deceased_id')->nullable();            
            $table->string('deceased_name')->nullable();
            $table->string('deceased_surname')->nullable();
            $table->string('deceased_father_husband_name')->nullable();
            $table->string('deceased_name_gj')->nullable();
            $table->string('deceased_surname_gj')->nullable();
            $table->string('deceased_father_husband_name_gj')->nullable();
            $table->timestamp('death_date')->nullable();
            $table->timestamp('dafan_date')->nullable();
            $table->enum('place_death', array('hospital', 'home'))->nullable();
            $table->integer('reason_death')->nullable();
            $table->date('birth_date')->nullable();
            $table->integer('age')->nullable();
            $table->enum('identity_proof', array('Aadhar Card','Voting Card','Passport Copy'))->nullable();
            $table->string('identity_proof_file')->nullable();
            $table->string('hospital_letter_file')->nullable();
            $table->text('address1')->nullable();
            $table->text('address2')->nullable();
            $table->text('address3')->nullable();
            $table->integer('area_id')->nullable();
            $table->integer('city_id')->nullable();
            $table->integer('state_id')->nullable();
            $table->integer('country_id')->nullable();
            $table->integer('pincode')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deceased_master_correction');
    }
}
