﻿// This transliteration service is hosted to be used by MMPs only.
// Author - Mukul Saini // Version : 1.3.2
// Copyright (c) 2015 GIST at CDAC (http://www.cdac.in/index.aspx?id=gist)
function enableTyping(e, t, r, n) {
    glocale='guj';
    
    glocale != n && (setLanguage(glocale), setHashTableName()), null === t || void 0 == typeof t ? typingOnSameTextbox(e, r, glocale) : (null != e || e.length > 0 || void 0 != typeof e && null != t || t.length > 0 || void 0 != typeof t) && typingOnMultiTextbox(e, t, r, glocale), browserName = getBrowserName()
}

function setTypingLayout(e) {
    $.trim(e).length > 0 && (typingLayout = $.trim(e), g_EnableTypingOnlyOnKBDOpen = "inscript" == typingLayout.toLowerCase() ? 0 : 1), browserName = getBrowserName()
}

function setLanguage(e) {
    try {
        switch (e) {
            case "hin":
                e = "hi_in";
                break;
            case "guj":
                e = "gj_in";
                break;
            case "mar":
                e = "mr_in";
                break;
            case "pan":
                e = "pn_in";
                break;
            case "mal":
                e = "ml_in";
                break;
            case "ban":
                e = "bn_in"
        }
        switch (e != glocale && (glocale = e, hashTableName.clear(), hashTableAddress.clear()), glocale) {
            case "hi_in":
                languageName = "hindi";
                break;
            case "gj_in":
                languageName = "gujarati";
                break;
            case "mr_in":
                languageName = "marathi";
                break;
            case "pn_in":
                languageName = "punjabi";
                break;
            case "ml_in":
                languageName = "malayalam";
                break;
            case "bn_in":
                languageName = "bengali";
                break;
            default:
                languageName = "hindi"
        }
        totalTopPos = "pn_in" == glocale ? 43 : "ml_in" == glocale ? 35 : 27, changeKeyboardLanguage(languageName)
    } catch (t) {}
}

function nextPage() {
    try {
        if (totalSuggestionsCount > suggestionsPerPage && totalPageCount > currentPageCounter) {
            $(suggestion_Id).html(""), currentPosition++, currentPageCounter++, $("#prev").removeAttr("disabled");
            var e = suggestionsPerPage;
            suggestionsToShow = 0, currentPosition + e > totalSuggestionsCount && (e = totalSuggestionsCount - currentPosition);
            var t = 0;
            for (firstLimit = currentPosition; e > t;) appendSuggestion(arrSugg[currentPosition]), currentPosition++, suggestionsToShow++, t++;
            currentPosition--, lastLimit = currentPosition, selectSuggestion(firstLimit), currentSelectedIndex = firstLimit, currentPosition == totalSuggestionsCount - 1 && $("#next").attr("disabled", "disabled")
        }
    } catch (r) {}
}

function prevPage() {
    try {
        if (totalSuggestionsCount > suggestionsPerPage && currentPageCounter > 1) {
            $(suggestion_Id).html(""), currentPageCounter > 1 && currentPageCounter--, $("#next").removeAttr("disabled");
            var e = suggestionsPerPage;
            currentPageCounter > 1 ? currentPosition = currentPosition - suggestionsToShow - suggestionsPerPage + 1 : 1 == currentPageCounter && (currentPosition = 0), suggestionsToShow = 0, firstLimit = currentPosition;
            for (var t = 0; e > t;) appendSuggestion(arrSugg[currentPosition]), currentPosition++, suggestionsToShow++, t++;
            currentPosition--, lastLimit = currentPosition, selectSuggestion(firstLimit), currentSelectedIndex = firstLimit, 0 >= currentPosition - suggestionsPerPage && $("#prev").attr("disabled", "disabled")
        }
    } catch (r) {}
}

function typingOnSameTextbox(e, t) {
    try {
        "ADDRESS" == t ? addressIDs = e : "NAME" == t && (nameIDs = e), storePreviousID = ""
    } catch (r) {}
}

function typingOnMultiTextbox(e, t, r) {
    try {
        "ADDRESS" == r ? (sourceAddressIDs = e, targetAddressIDs = t) : "NAME" == r && (sourceNameIDs = e, targetNameIDs = t), storePreviousID = ""
    } catch (n) {}
}

function formatSuggestion(e) {
    e = e.replace(/-/gi, "-#~1#-").replace(/\{/gi, "{#~2#{").replace(/\}/gi, "}#~3#}").replace(/\(/gi, "(#~4#(").replace(/\)/gi, ")#~5#)").replace(/\[/gi, "[#~6#[").replace(/\]/gi, "]#~7#]").replace(/_/gi, "_#~8#_").replace(/\&/gi, "&#~9#&").replace(/,/gi, ",#~10#,").replace(/\"/gi, '"#~11#"').replace(/'/gi, "#~12#");
    var t = "";
    try {
        for (var r = e.split(/[\s\{\}\(\)\[\]\-_\&,'"]/gi), n = 0; n < r.length; n++) {
            var a = r[n]; - 1 == jQuery.inArray(a, uniqueSymbols) && (a += " ");
            var s = r[n].split(";$;");
            s.length > 1 && (a = s[0] + " ", hashTableAddress.put(s[0], s)), t += a
        }
        return t = t.replace(/#~1#/gi, "-").replace(/#~2#/gi, "{").replace(/#~3#/gi, "}").replace(/#~4#/gi, "(").replace(/#~5#/gi, ")").replace(/#~6#/gi, "[").replace(/#~7#/gi, "]").replace(/#~8#/gi, "_").replace(/#~9#/gi, "&").replace(/#~10#/gi, ",").replace(/#~11#/gi, '"').replace(/#~12#/gi, "'"), t = t.replace(/\s-/gi, "-").replace(/\s\{/gi, "{").replace(/\s\}/gi, "}").replace(/\(/gi, "(").replace(/\s\)/gi, ")").replace(/\s\[/gi, "[").replace(/\s\]/gi, "]").replace(/\s_/gi, "_").replace(/\s\&/gi, "&").replace(/\s,/gi, ",").replace(/\s"/gi, '"').replace(/\s'/gi, "'")
    } catch (i) {}
    return t
}

function removePreviousContainers() {
    try {
        var e = $(".element").contents();
        $(".element").replaceWith(e), resetValues()
    } catch (t) {}
}

function executeAfterClickOnTextBox(e) {
    try {
        $(popbox_Id).remove(), element_Id = "#" + e, popbox_Id = "#popupBox_" + e, content_Id = "#PopUpInputBox_" + e, suggestion_Id = "#Suggestions_" + e, container_Id = "#democontainer_" + e, pagingdiv_Id = "#page_" + e, imageDiv_Id = "#cdacImage_" + e;
        var t = "page_" + e;
        if (null == document.getElementById("popupBox_" + e)) {
            var r = $("<div class='Gist_Typing_Popup_MainBX' id='popupBox_" + e + "'></div>"),
                n = $("<div id='PopUpInputBox_" + e + "' class='Gist_Typing_Popup_PopupTypingBox'></div>"),
                a = $("<div id='Suggestions_" + e + "' class='Gist_Typing_Popup_SuggestnBox'></div>"),
                s = $("<div id='" + t + "' class='Gist_Typing_Popup_PagingDiv'><input type='button' value='<' id='prev' class='Gist_Typing_Popup_PagingBtn' style='float:left;' onclick='prevPage()'/><input type='button' value='>' id='next' class='Gist_Typing_Popup_PagingBtn' style='float:right;' onclick='nextPage()'/></div>"),
                i = $("<div id='imageDiv_Id' class='Gist_Typing_Popup_CdacImgDiv'><img src='" + imageFolderPath + "/CDAC-GIST.bmp' alt='CDAC Gist' class='Gist_Typing_Popup_CdacImg'/></div>");
            $(r).append(n), $(r).append(a), $(r).append(s), $(r).append(i), $(container_Id).append(r)
        }
        resetValues(), $(element_Id).attr("autocomplete", "off")
    } catch (o) {}
}

function setFont(e) {
    previousFont = $(e).css("font-family"), $(e).css("font-family", "gist_" + languageName + "_font")
}

function checkIDS(e) {
    try {
        var t = "";
        if (multiTypingEnabled) {
            if (void 0 != sourceNameIDs.length) {
                var r = jQuery.inArray(e, sourceNameIDs);
                if (r > -1) return t = "NAME"
            }
            if (void 0 != sourceAddressIDs.length) {
                var r = jQuery.inArray(e, sourceAddressIDs);
                if (r > -1) return t = "ADDRESS"
            }
            if (void 0 != targetNameIDs.length) {
                var r = jQuery.inArray(e, targetNameIDs);
                if (r > -1) return t = "NAME"
            }
            if (void 0 != targetAddressIDs.length) {
                var r = jQuery.inArray(e, targetAddressIDs);
                if (r > -1) return t = "ADDRESS"
            }
        } else {
            if (void 0 != nameIDs.length) {
                var r = jQuery.inArray(e, nameIDs);
                if (r > -1) return t = "NAME"
            }
            if (void 0 != addressIDs.length) {
                var r = jQuery.inArray(e, addressIDs);
                if (r > -1) return t = "ADDRESS"
            }
        }
        return t
    } catch (n) {}
}

function setPopupBox() {
    try {
        currentSelectedIndex = 0, gettypingCaretPositionForPopup();
        var e = $(element_Id).caret("offset"),
            t = e.left + totalLeftPos,
            r = e.top + totalTopPos;
        $(".Gist_Typing_Popup_MainBX").css("left", t + "px"), $(".Gist_Typing_Popup_MainBX").css("top", r + "px"), $(".Gist_Typing_Popup_MainBX").css("z-index", "999999999")
    } catch (n) {}
}

function typingCaretPosition(e) {
    try {
        var t = e.value.length;
        if (e.createTextRange && !isBrowserAboveIE9()) {
            if ("TEXTAREA" != e.tagName) {
                for (var r = document.selection.createRange().duplicate(); r.parentElement() == e && 1 == r.move("character", 1);) --t;
                return t == e.value.length + 1 ? -1 : t
            }
            var n;
            if (void 0 != document.selection) {
                if ("Text" == document.selection.type) {
                    var a = document.selection.createRange(),
                        s = caretPosExtFun(e);
                    if (void 0 != s) return c = caretPos + a.text.length, selectedTextStart = s, selectedTextEnd = c, s;
                    for (var r = document.selection.createRange().duplicate(); r.parentElement() == e && 1 == r.move("character", 1);) --t;
                    return selectedTextStart = t + 1, selectedTextEnd = t + a.text.length, t + 1
                }
                n = document.selection.createRange();
                var i = n.text;
                if ("" == i) {
                    var o = "#%~";
                    n.text = i + o, n.moveStart("character", 0 - i.length - o.length);
                    var l = e.value;
                    for (n.text = i, t = 0; t <= l.length; t++) {
                        var u = l.substring(t, t + o.length);
                        if (u == o) {
                            var c = t - i.length;
                            return c
                        }
                    }
                }
            }
        } else if (e.selectionStart || "0" == e.selectionStart) return e.selectionStart
    } catch (g) {}
}

function gettypingCaretPositionForPopup() {
    try {
        originalText = $(element_Id).val() || $(element_Id).text();
        var e = originalText.length,
            t = element_Id.substring(1, element_Id.length);
        caretPos = typingCaretPosition(document.getElementById(t)), beforeText = originalText.substring(0, caretPos), afterText = originalText.substring(caretPos, e)
    } catch (r) {}
}

function resetSpan() {
    try {
        $("#widthcalc").html(""), $("#widthcalc").remove()
    } catch (e) {}
}

function setSuggestionToTextbox() {
    try {
        if ("" != $(suggestion_Id).text()) {
            var e = "#" + arrSugg[currentSelectedIndex],
                t = $(e).text();
            putWord(t), resetValues()
        }
        resetSpan()
    } catch (r) {}
}

function putWord(e) {
    try {
        if ("" != e) {
            var t = "";
            if (selectedTextStart != selectedTextEnd && 0 != selectionFlag) {
                var r = $(element_Id).val();
                t = engContainSpace ? r.slice(0, selectedTextStart) + e + " " + r.slice(selectedTextEnd) : r.slice(0, selectedTextStart) + e + r.slice(selectedTextEnd), selectedTextStart = -1, selectedTextEnd = -1, caretPos += e.length
            } else 0 == beforeText.length && 0 == afterText.length ? t = e + " " : 0 == afterText.length && 0 != beforeText.length ? t = beforeText.lastIndexOf(" ") <= beforeText.length - 1 ? beforeText + e + " " : beforeText + " " + e + " " : 0 != afterText.length && 0 == beforeText.length ? t = 0 == afterText.indexOf(" ") ? e + afterText : e + " " + afterText : 0 != afterText.length && 0 != beforeText.length && (t = beforeText.lastIndexOf(" ") <= beforeText.length - 1 ? beforeText + e : beforeText + " " + e, t += 0 == afterText.indexOf(" ") ? afterText : " " + afterText), caretPos = caretPos + e.length + 1;
            if ($(element_Id).val(t), "name" === behavior) changeSuggestionSequence(e);
            else if ("address" === behavior) {
                var n = hashTableAddress.get($.trim(selectedText));
                "undefined" != n && null != n && (hashTableAddress.remove($.trim(selectedText)), hashTableAddress.put($.trim(e), n))
            }
            setCursorToPosition(caretPos)
        }
        selectionFlag = 0
    } catch (a) {}
}

function changeSuggestionSequence(e) {
    try {
        e = $.trim(e);
        var t = $.trim($(content_Id).html());
        if (t != e) {
            var r = hashTableName.get(t),
                n = r.replace(e + "^", ""),
                a = e + "^" + n;
            hashTableName.remove(t), hashTableName.put(t, a), updateSuggestionsFrequency(t, e, glocale)
        }
        hashTableForDblClick.put(e, t)
    } catch (s) {}
}

function putSingleChar(e) {
    try {
        if (gettypingCaretPositionForPopup(), "" != e) {
            var t = beforeText + e + afterText;
            $(element_Id).val(t), caretPos = caretPos + e.length + 1, setCursorToPosition(caretPos)
        }
    } catch (r) {}
}

function setCursorToPosition(e) {
    try {
        if ($(element_Id).get(0).setSelectionRange) $(element_Id).get(0).setSelectionRange(e, e);
        else if ($(element_Id).get(0).createTextRange) {
            var t = $(element_Id).get(0).createTextRange();
            t.collapse(!0), t.moveEnd("character", e), t.moveStart("character", e), t.select()
        }
    } catch (r) {}
}

function selectSuggestion(e) {
    try {
        var t = "#" + arrSugg[e];
        $(t).attr("class", "Gist_Typing_Popup_SelectedText")
    } catch (r) {}
}

function unSelectSuggestion(e) {
    try {
        var t = "#" + arrSugg[e];
        $(t).attr("class", "Gist_Typing_Popup_UnSelectedText")
    } catch (r) {}
}

function getBrowserName() {
    try {
        var e = "",
            t = navigator.userAgent.toLowerCase();
        return -1 != t.indexOf("opera") ? e = "opera" : -1 != t.indexOf("msie") ? e = "msie" : -1 != t.indexOf("safari") ? e = "safari" : -1 != t.indexOf("mozilla") && (e = -1 != t.indexOf("firefox") ? "firefox" : "mozilla"), e
    } catch (r) {}
}

function isBrowserAboveIE9() {
    try {
        var e = (navigator.appVersion, parseInt(navigator.appVersion));
        return 4 >= e ? !1 : !0
    } catch (t) {}
}

function getSuggestionsForSelectedText(e) {
    try {
        var t = document.getElementById(e);
        if (document.selection) {
            var r = document.selection.createRange().getBookmark(),
                n = t.createTextRange(),
                a = n.duplicate();
            n.moveToBookmark(r), a.setEndPoint("EndToStart", n), selectedTextStart = a.text.length, selectedTextEnd = selectedTextStart + n.text.length, selectedText = n.text
        } else if (void 0 != t.selectionStart) {
            var s = t.selectionStart;
            selectedTextStart = s;
            var i = t.selectionEnd;
            selectedTextEnd = i, selectedText = t.value.substring(s, i)
        }
        if (null == $.trim(selectedText) || void 0 == $.trim(selectedText) || "" == $.trim(selectedText)) return void resetValues();
        var o = selectedText.split(" ");
        if (engContainSpace = o.length > 1 ? !0 : !1, "name" == behavior) {
            var l = hashTableForDblClick.get($.trim(selectedText));
            if (void 0 != l && "" != l) {
                setPopupBox(), resetValues();
                var u = hashTableName.get($.trim(l));
                $.trim(u).length > 0 ? showSuggestions(u) : iSuggest("#" + e, null, $.trim(l), !1), $(content_Id).html(l)
            }
        } else if ("address" == behavior) {
            var c = hashTableAddress.get($.trim(selectedText));
            void 0 != c && "" != c && $.trim(c).length > 0 ? (setPopupBox(), resetValues(), showSuggestions(c)) : iSuggest("#" + e, null, $.trim(selectedText), !0)
        }
    } catch (g) {}
}

function iSuggest(e, t, r, n) {
    try {
        if (!($.trim(r).length > 0)) return;
        var a = $.trim(r);
        r = encodeURIComponent(r);
        var s = "",
            i = "",
            o = 0;
        if (n && "address" == behavior) s = Service_Url + "Transliteration.aspx?itext=" + r + "&reverseSuggest=true";
        else if ("name" === behavior)
            if (s = Service_Url + "Transliteration.aspx?itext=" + r + "&transliteration=NAME&locale=" + glocale, i = hashTableName.get(a), multiTypingEnabled || 0 != $.trim(t).length || 0 == $.trim(e).length) {
                if (multiTypingEnabled && 0 != $.trim(e).length && 0 != $.trim(t).length) {
                    if (0 != $.trim(i).length) return void setResultInTarget(t, a, i);
                    o = 3
                }
            } else {
                if (0 != $.trim(i).length) return void showSuggestions(i);
                o = 1
            }
        else if ("address" === behavior)
            if (s = Service_Url + "Transliteration.aspx?itext=" + r + "&transliteration=ADDRESS&locale=" + glocale, i = hashTableAddress.get(a), multiTypingEnabled || 0 != $.trim(t).length || 0 == $.trim(e).length) {
                if (multiTypingEnabled && 0 != $.trim(e).length && 0 != $.trim(t).length) {
                    if (0 != $.trim(i).length) return void $(t).val(i);
                    o = 4
                }
            } else {
                if (0 != $.trim(i).length) return void $(e).val(i);
                o = 2
            } try {
            if (-1 == navigator.appVersion.indexOf("MSIE 7.") && -1 == navigator.appVersion.indexOf("MSIE 8.") && -1 == navigator.appVersion.indexOf("MSIE 9.") && -1 == navigator.appVersion.indexOf("MSIE 10.") && navigator.userAgent.match(/Trident\/7\./)) storeResult = "", $.ajax({
                type: "GET",
                url: s,
                async: !0,
                success: function(e) {
                    storeResult = formatSuggestion(decodeURIComponent(e))
                },
                complete: function() {
                    processSuggestions(e, t, a, o)
                }
            });
            else {
                var l;
                if (l = window.XMLHttpRequest ? new XMLHttpRequest : new ActiveXObject("Microsoft.XMLHTTP"), !l) return void alert("Cannot create an XMLHTTP instance");
                try {
                    l.onreadystatechange = function() {
                        4 == l.readyState && 200 == l.status && (storeResult = formatSuggestion(decodeURIComponent(l.responseText)), processSuggestions(e, t, a, o))
                    }, l.open("GET", s, !0), l.send()
                } catch (u) {
                    XDomainRequest && (l = new XDomainRequest, l.onload = function() {
                        storeResult = decodeURIComponent(formatSuggestion(l.responseText)), processSuggestions(e, t, a, o)
                    }, l.open("GET", s), l.send())
                }
            }
        } catch (u) {}
    } catch (c) {}
}

function processSuggestions(e, t, r, n) {
    try {
        if (storeResult = $.trim(storeResult), r = $.trim(r), "Empty Value." === $.trim(storeResult)) return void resetValues();
        1 == n ? (storeResult = storeResult, hashTableName.put(r, storeResult), showSuggestions(storeResult)) : 2 == n ? ($(e).val(storeResult), feedback("Address", r, storeResult, glocale)) : 3 == n ? (setResultInTarget(t, r, storeResult), feedback("Name", r, storeResult, glocale)) : 4 == n ? ($(t).val(storeResult), feedback("Address", r, storeResult, glocale)) : 5 == n && (hashTableAddress.put(r, storeResult), showSuggestions(storeResult))
    } catch (a) {}
}

function updateSuggestionsFrequency(e, t, r) {
    try {
        var n = Service_Url + "FineTune.aspx?engword=" + e + "&ilword=" + t + "&locale=" + r;
        $.ajax({
            type: "GET",
            url: n,
            async: !0,
            success: function() {},
            complete: function() {}
        }), feedback(behavior, e, t, glocale)
    } catch (a) {}
}

function setResultInTarget(e, t, r) {
    try {
        var n = "",
            a = !1,
            s = "",
            i = "";
        r.length - 1 == r.lastIndexOf(";") && (a = !0);
        var o = t.split(" ");
        r = r.replace(/;$/, "");
        var l = r.split(";");
        if (o.length > 1)
            for (var u = 0; u < o.length; u++)
                if (hashTableName.containsKey(o[u])) {
                    var c = l[u],
                        g = hashTableName.get(o[u]);
                    c != g && (l[u] = g)
                } if (o.length > 1 && l.length > 1 && o.length == l.length)
            for (var d = 0; d < o.length; d++) {
                i = $.trim(o[d]), s = $.trim(a ? l[d] : l[d]);
                var h = s.substring(0, s.indexOf("^"));
                n += h + " ", hashTableName.containsKey(i) || hashTableName.put(i, s), hashTableForDblClick.put(h, i)
            } else {
                s = a ? r : r;
                var h = s.substring(0, s.indexOf("^"));
                n += h + " ", hashTableName.containsKey(t) || hashTableName.put(t, s), hashTableForDblClick.put(h, t)
            }
        n && ($(e).val(""), $(e).val($.trim(n)))
    } catch (p) {}
}

function feedback() {
    try {} catch (e) {}
}

function showSuggestions(e) {
    try {
        if (totalSuggestionsCount = 0, e) {
            if ($(suggestion_Id).html(""), e.split(";").length > 1) {
                var t = e.split(";");
                arrSugg = t[0].split("^"), arrSugg.push(t[1])
            } else arrSugg = e.split("^");
            arrSugg = $.grep(arrSugg, function(e) {
                return "" != e
            }), totalSuggestionsCount = arrSugg.length, totalPageCount = Math.ceil(totalSuggestionsCount / suggestionsPerPage), 1 == totalPageCount ? ($("#prev").css("cursor", "default"), $("#next").css("cursor", "default"), $("#next").attr("disabled", "disabled"), $("#prev").attr("disabled", "disabled")) : ($("#prev").css("cursor", "pointer"), $("#next").css("cursor", "pointer"), $("#prev").attr("disabled", "disabled"), $("#next").removeAttr("disabled")), currentPosition = 0, currentPageCounter = 1;
            var r = 0;
            for (firstLimit = 0; totalSuggestionsCount > r && (appendSuggestion(arrSugg[currentPosition]), currentPosition++, r++, suggestionsToShow++, r != suggestionsPerPage););
            currentPosition--, lastLimit = currentPosition, currentSelectedIndex = firstLimit, selectSuggestion(0), $(suggestion_Id).show(), $(content_Id).show(), $(imageDiv_Id).show(), $(popbox_Id).show(), 1 == totalPageCount ? $(pagingdiv_Id).hide() : $(pagingdiv_Id).show()
        }
    } catch (n) {}
}

function appendSuggestion(e) {
    try {
        var t = $("<div id='" + e + "' class='Gist_Typing_Popup_UnSelectedText'></div>");
        $(t).html("<p style='color:black;margin:0em;' class='optional-suggestion'>" + e + "</p>"), $(t).css("margin", "2px 0px 2px 0px"), $(t).css("font-family", "gist_" + languageName + "_font"), $(suggestion_Id).append(t)
    } catch (r) {}
}

function funClick(e) {
    try {
        $(element_Id).focus(), putWord(e), resetValues()
    } catch (t) {}
}

function resetValues() {
    try {
        $(suggestion_Id).html(""), $(suggestion_Id).hide(), $(content_Id).text(""), $(content_Id).hide(), $(pagingdiv_Id).hide(), $(imageDiv_Id).hide(), $(popbox_Id).hide(), suggestions = null, storeResult = null
    } catch (e) {}
}

function caretPosExtFun(e) {
    try {
        var t = e.value.length;
        if (e.createTextRange && !isBrowserAboveIE9()) {
            if ("TEXTAREA" != e.tagName) {
                for (var r = document.selection.createRange().duplicate(); r.parentElement() == e && 1 == r.move("character", 1);) --t;
                return t == e.value.length + 1 ? -1 : t
            }
            var n = document.selection.createRange(),
                a = n.text;
            if ("" == a) {
                var s = "#%~";
                n.text = a + s, n.moveStart("character", 0 - a.length - s.length);
                var i = e.value;
                for (n.text = a, t = 0; t <= i.length; t++) {
                    var o = i.substring(t, t + s.length);
                    if (o == s) {
                        var l = t - a.length;
                        return l
                    }
                }
            }
        } else if (e.selectionStart || "0" == e.selectionStart) return e.selectionStart
    } catch (u) {}
}

function setHashTableName() {
    try {
        "hi_in" == glocale ? hashTableName = hashtableHI_IN : "gj_in" == glocale ? hashTableName = hashtableGJ_IN : "mr_in" == glocale ? hashTableName = hashtableMR_IN : "pn_in" == glocale ? hashTableName = hashtablePN_IN : "ml_in" == glocale ? hashTableName = hashtableML_IN : "bn_in" == glocale && (hashTableName = hashtableBN_IN)
    } catch (e) {}
}

function Hashtable() {
    this.clear = hashtable_clear, this.containsKey = hashtable_containsKey, this.containsValue = hashtable_containsValue, this.get = hashtable_get, this.isEmpty = hashtable_isEmpty, this.keys = hashtable_keys, this.put = hashtable_put, this.remove = hashtable_remove, this.size = hashtable_size, this.toString = hashtable_toString, this.values = hashtable_values, this.hashtable = new Array
}

function hashtable_clear() {
    this.hashtable = new Array
}

function hashtable_containsKey(e) {
    var t = !1;
    for (var r in this.hashtable)
        if (r == e && null != this.hashtable[r]) {
            t = !0;
            break
        } return t
}

function hashtable_containsValue(e) {
    var t = !1;
    if (null != e)
        for (var r in this.hashtable)
            if (this.hashtable[r] == e) {
                t = !0;
                break
            } return t
}

function hashtable_get(e) {
    return this.hashtable[e]
}

function hashtable_isEmpty() {
    return 0 == parseInt(this.size()) ? !0 : !1
}

function hashtable_keys() {
    var e = new Array;
    for (var t in this.hashtable) null != this.hashtable[t] && e.push(t);
    return e
}

function hashtable_put(e, t) {
    this.hashtable[e] = null == e || null == t ? t : t
}

function hashtable_size() {
    var e = 0;
    for (var t in this.hashtable) null != this.hashtable[t] && e++;
    return e
}

function hashtable_toString() {
    var e = "";
    for (var t in this.hashtable) null != this.hashtable[t] && (e += "{" + t + "},{" + this.hashtable[t] + "}\n");
    return e
}

function hashtable_values() {
    var e = new Array;
    for (var t in this.hashtable) null != this.hashtable[t] && e.push(this.hashtable[t]);
    return e
}

function hashtable_remove(e) {
    var t = this.hashtable[e];
    return this.hashtable[e] = null, t
}
var Service_Url = "http://gisttransserver.in/",
    jsFolderPath = Service_Url + "js",
    cssFolderPath = jsFolderPath + "/css",
    imageFolderPath = jsFolderPath + "/images",
    glocale = "hi_in",
    languageName = "hindi",
    maxTypingLength = 15;
"undefined" != typeof jQuery || window.jQuery ? "undefined" == typeof jQuery && window.jQuery ? jQuery = window.jQuery : "undefined" == typeof jQuery || window.jQuery || (window.jQuery = jQuery) : document.write("<script type='text/javascript' src='" + jsFolderPath + "/jquery.min.js'></script>"), document.write("<script type='text/javascript' src='" + jsFolderPath + "/jquery.caret.js'></script>"), document.write("<link href='" + cssFolderPath + "/CDAC-Typing-Script-Style.css' rel='stylesheet' type='text/css' />"), document.write("<script type='text/javascript' src='" + jsFolderPath + "/KeyboardScript.min.js'></script>");
var typingLayout = "transliteration",
    suggestionsPerPage = 5,
    totalTopPos = 27,
    totalLeftPos = 2,
    element_Id = "",
    content_Id = "",
    popbox_Id = "",
    suggestion_Id = "",
    container_Id = "",
    pagingdiv_Id = "",
    imageDiv_Id = "",
    currentElementId = "",
    targetID = "",
    behavior = "",
    storePreviousID = "",
    originalText = "",
    beforeText = "",
    afterText = "",
    storeResult = "",
    engContainSpace = !0,
    selectionFlag = 0,
    multiTypingEnabled = !1,
    caretPos = 0,
    tempLength = 0,
    arrSugg = new Array,
    browserName = "",
    suggestions = "",
    selectedText = "",
    selectedTextStart = -1,
    selectedTextEnd = -1,
    totalSuggestionsCount = 0,
    totalPageCount = 0,
    currentSelectedIndex = 0,
    currentPosition = 0,
    suggestionsToShow = 0,
    currentPageCounter = 1,
    firstLimit = 0,
    lastLimit = 0,
    previousFont = "",
    uniqueSymbols = ["#~1#", "#~2#", "#~3#", "#~4#", "#~5#", "#~6#", "#~7#", "#~8#", "#~9#", "#~10#", "#~11#", "#~12#"],
    addressIDs = new Array,
    nameIDs = new Array,
    sourceAddressIDs = new Array,
    targetAddressIDs = new Array,
    sourceNameIDs = new Array,
    targetNameIDs = new Array,
    hashtableHI_IN = new Hashtable,
    hashtableGJ_IN = new Hashtable,
    hashtableMR_IN = new Hashtable,
    hashtablePN_IN = new Hashtable,
    hashtableML_IN = new Hashtable,
    hashtableBN_IN = new Hashtable,
    hashTableName = hashtableHI_IN,
    hashTableForDblClick = new Hashtable,
    hashTableAddress = new Hashtable;
$(document).ready(function() {
    var e = "";
    $("input[type='text'], textarea").focus(function(e) {
        try {
            if (currentElementId = this.id, jQuery.inArray(currentElementId, nameIDs) > -1 || jQuery.inArray(currentElementId, addressIDs) > -1) multiTypingEnabled = !1;
            else {
                if (!(jQuery.inArray(currentElementId, sourceNameIDs) > -1 || jQuery.inArray(currentElementId, sourceAddressIDs) > -1 || jQuery.inArray(currentElementId, targetNameIDs) > -1 || jQuery.inArray(currentElementId, targetAddressIDs) > -1)) return;
                multiTypingEnabled = !0
            }
            if (behavior = checkIDS(currentElementId).toLowerCase(), storePreviousID == currentElementId) return void setFont(element_Id);
            removePreviousContainers(), -1 == jQuery.inArray(currentElementId, sourceNameIDs) && -1 == jQuery.inArray(currentElementId, sourceAddressIDs) && ("Netscape" != navigator.appName && "Microsoft Internet Explorer" != navigator.appName || -1 != navigator.appVersion.indexOf("MSIE 11.") ? $("body").prepend("<elem id='democontainer_" + currentElementId + "' class='element'></elem>") : $("body").wrap("<span id='democontainer_" + currentElementId + "' class='element'></span>"), executeAfterClickOnTextBox(currentElementId), storePreviousID = currentElementId, setFont(element_Id), $(e.target).focus())
        } catch (t) {}
    }), $("input[type='text'], textarea").blur(function() {
        try {
            if ("transliteration" != typingLayout || !(jQuery.inArray(this.id, nameIDs) > -1 || jQuery.inArray(this.id, addressIDs) > -1 || jQuery.inArray(this.id, sourceNameIDs) > -1 || jQuery.inArray(this.id, sourceAddressIDs) > -1)) return;
            if (multiTypingEnabled || "address" !== behavior) {
                if (!multiTypingEnabled) return;
                currentElementId = this.id;
                var e = "#" + currentElementId;
                if ("name" === behavior) {
                    if (sourceNameIDs.length != targetNameIDs.length) return void alert("Error in defining the Source ID or its Target ID for Name Translations");
                    var t = jQuery.inArray(currentElementId, sourceNameIDs);
                    if (!(t > -1)) return;
                    targetID = targetNameIDs[t]
                } else if ("address" === behavior) {
                    if (sourceAddressIDs.length != targetAddressIDs.length) return void alert("Error in defining the Source ID or its Target ID for Address Translations");
                    var t = jQuery.inArray(currentElementId, sourceAddressIDs);
                    if (!(t > -1)) return;
                    targetID = targetAddressIDs[t]
                }
                var r = $.trim($(e).val());
                if (!(r.length > 1)) return;
                resetValues(), iSuggest(e, "#" + targetID, r, !1)
            } else if (jQuery.inArray(currentElementId, addressIDs) > -1) {
                var e = "#" + currentElementId,
                    n = $.trim($("#" + currentElementId).val());
                iSuggest(e, null, n, !1)
            }
        } catch (a) {}
    }), $("input[type='text'], textarea").select(function(e) {
        try {
            if (currentElementId = e.target.id, behavior = checkIDS(currentElementId).toLowerCase(), $(popbox_Id).is(":visible") && resetValues(), multiTypingEnabled && (jQuery.inArray(currentElementId, sourceNameIDs) > -1 || jQuery.inArray(currentElementId, sourceAddressIDs) > -1)) return void resetValues();
            if (!(jQuery.inArray(currentElementId, nameIDs) > -1 || jQuery.inArray(currentElementId, targetNameIDs) > -1) || "name" !== behavior || $(popbox_Id).is(":visible")) return selectionFlag = 0, void resetValues();
            selectionFlag = 1, getSuggestionsForSelectedText($(this).attr("id"))
        } catch (e) {}
    }), $(document).on("mousedown", "*", function(e) {
        try {
            $(popbox_Id).is(":visible") && 0 == $(e.target).hasClass("Gist_Typing_Popup_PagingBtn") && 0 == $(e.target).hasClass("optional-suggestion") && (putWord(""), resetValues()), 1 == g_EnableTypingOnlyOnKBDOpen && isKBDOpen && multiTypingEnabled && (jQuery.inArray(e.target.id, sourceNameIDs) > -1 || jQuery.inArray(e.target.id, sourceAddressIDs) > -1) && closeKeyboard()
        } catch (e) {}
    }), $(document).on("click", ".Gist_Typing_Popup_PopupTypingBox", function() {
        try {
            resetValues(), $(element_Id).focus(), setCursorToPosition(caretPos)
        } catch (e) {}
    }), $(document).on("click", ".optional-suggestion", function() {
        funClick($(this).text())
    }), $(document).on("keydown", element_Id, function(t) {
        try {
            if (t.ctrlKey) {
                if (t.ctrlKey) return 89 == t.keyCode && (null == document.getElementById("keyBrd") && $("body").append('<div id="keyBrd"> </div>'), openKeyboard(languageName), hashtable_clear(), $(element_Id).focus()), void resetValues()
            } else {
                if ("transliteration" == typingLayout && !isKBDOpen && !multiTypingEnabled && "name" === behavior && (suggestions = "", t.keyCode > 64 && t.keyCode < 91)) {
                    if (t.preventDefault(), e = String.fromCharCode(t.keyCode), t.shiftKey ? e = e.toUpperCase() : t.shiftKey || (e = e.toLowerCase()), !($(content_Id).text().length < maxTypingLength)) return;
                    $(content_Id).html($(content_Id).html() + e), tempLength = $(content_Id).html().length
                }
                "inscript" == typingLayout && resetValues()
            }
            if ($(popbox_Id).is(":visible"))
                if ("" == $(content_Id).text() && 8 == t.keyCode) t.preventDefault(), resetValues();
                else if (32 != t.keyCode && 13 != t.keyCode || "" == $(suggestion_Id).html())
                if (8 == t.keyCode)
                    if (multiTypingEnabled) resetValues();
                    else {
                        t.preventDefault();
                        var r = $(content_Id).html(),
                            n = r.length;
                        r = r.substr(0, n - 1), $(content_Id).html(r)
                    }
            else if (27 == t.keyCode) resetValues();
            else {
                if (37 == t.keyCode) return t.preventDefault(), void prevPage();
                if (39 == t.keyCode) return t.preventDefault(), void nextPage();
                38 == t.keyCode ? (t.preventDefault(), unSelectSuggestion(currentSelectedIndex), currentSelectedIndex > firstLimit && currentSelectedIndex--, selectSuggestion(currentSelectedIndex)) : 40 == t.keyCode ? (t.preventDefault(), unSelectSuggestion(currentSelectedIndex), lastLimit > currentSelectedIndex && currentSelectedIndex++, selectSuggestion(currentSelectedIndex)) : 46 == t.keyCode ? resetValues() : (t.keyCode > 47 && t.keyCode < 58 || t.keyCode > 185 && t.keyCode < 193 || t.keyCode > 218 && t.keyCode < 223 || t.keyCode >= 109 && t.keyCode <= 111 && (106 == t.keyCode || 107 == t.keyCode)) && 16 != t.keyCode && (setSuggestionToTextbox(), resetValues())
            } else t.preventDefault(), setSuggestionToTextbox()
        } catch (t) {}
    }), $(document).on("keyup", element_Id, function(e) {
        try {
            if (!e.ctrlKey && !isKBDOpen && "transliteration" == typingLayout && !multiTypingEnabled && "name" == behavior)
                if (e.keyCode > 64 && e.keyCode < 91) {
                    if ($(suggestion_Id).html(""), setPopupBox(), iSuggest(content_Id, null, $.trim($(content_Id).text()), !1), !(maxTypingLength > tempLength)) return;
                    tempLength = 0
                } else if ($(popbox_Id).is(":visible")) {
                if (8 == e.keyCode) {
                    if ("" == $(content_Id).text()) return void resetValues();
                    setPopupBox(), $(suggestion_Id).html(""), iSuggest(content_Id, null, $.trim($(content_Id).text()), !1)
                }
                if ((e.keyCode > 47 && e.keyCode < 58 || e.keyCode > 185 && e.keyCode < 193 || e.keyCode > 218 && e.keyCode < 223 || e.keyCode >= 109 && e.keyCode <= 111 && (106 == e.keyCode || 107 == e.keyCode)) && 16 == e.keyCode) {
                    var t = String.fromCharCode(e.keyCode);
                    return e.preventDefault(), void putSingleChar(t)
                }
            }
        } catch (e) {}
    }), $(document).on("mouseenter", ".Gist_Typing_Popup_SuggestnBox", function() {
        unSelectSuggestion(currentSelectedIndex)
    }).on("mouseleave", ".Gist_Typing_Popup_SuggestnBox", function() {
        selectSuggestion(currentSelectedIndex)
    })
}), window.onresize && (window.onresize = function() {
    resetValues()
});
// Copyright (c) 2015 GIST at CDAC (http://www.cdac.in/index.aspx?id=gist)