@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $page_title }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="{{ get_admin_url('comments') }}">{{ admin_lang('comments') }}</a></li>
            <li class="breadcrumb-item active">{{ admin_lang('edit') }} #{{$comment->cid}}</li>
        </ol>
    </div>
</div>
<form method="POST" action="{{ get_admin_url('commentSendForm') }}" class="checkbox_form">
    {{ csrf_field() }}
    <input type="hidden" name="action" value="update" />
    <input type="hidden" name="commentid" value="{{ $comment->cid }}" />
    <div class="post-fixed-toolbar">
        <ul>
            <li>
                <div class="d-inline" title="{{admin_lang('status')}}">
                    <input type="checkbox" name="cstatus" value="1" class="custom-control-input" switch="bool" id="cstatus_switch" @if($comment->cstatus) checked @endif>
                    <label for="cstatus_switch" data-on-label="ON" data-off-label="OFF"></label>
                </div>
            </li>
            <li class="right-toolbar">
                <button type="submit" class="btn btn-primary waves-effect waves-light">{{admin_lang('update')}}</button>
            </li>
        </ul>
    </div>
    @if(session()->has('success'))
    <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{!! session()->get('success') !!}</div>
    @endif
    <div class="tacf-box-container">
        <div class="tacf-box-tabs nav-tabs-cookie" data-cookie="form_comment" data-cookie-tab="tab-edit">
            <a href="#" class="active" data-tab=".tab-edit"><i class="bx bx-pencil"></i> {{ admin_lang('edit') }}</a>
            <a href="#" class="" data-tab=".tab-details"><i class="bx bx-file"></i> {{ admin_lang('details') }}</a>
        </div>
        <div class="tacf-tabs-content">
            <div class="tacf-tab-content tab-edit active">
                <div class="form-group">
                    <textarea class="form-control" style="height: 160px" name="ccontent" >{!!$ccontent!!}</textarea>
                </div>
            </div>
            <div class="tacf-tab-content tab-details p-0">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item"><strong>{{admin_lang('id')}}:</strong> #{{$comment->cid}}</li>
                    <li class="list-group-item"><strong>{{admin_lang('in_response_to')}}:</strong> {!!get_post_title_from_comment($comment->cpid, $comment->ctype)!!}</li>
                    <li class="list-group-item"><strong>{{admin_lang('username')}}:</strong> @if($comment->cuid) <a href="{{get_admin_url('profile/'.$comment->cuid)}}">{{get_username($comment->cuid)}}</a> @else {{$comment->cuname}} @endif</li>
                    <li class="list-group-item"><strong>{{admin_lang('email')}}:</strong> @if($comment->cuid) {{get_user_column($comment->cuid, 'email')}} @else {{$comment->cuemail}} @endif</li>
                    <li class="list-group-item"><strong>{{admin_lang('date')}}:</strong> {{ time_format($comment->cmodified, 'date', 'd/m/Y H:i') }}</li>
                    <li class="list-group-item"><strong>{{admin_lang('ip')}}:</strong> <a href="{{get_admin_url('comments/ip/'.$comment->ip)}}">{{$comment->ip}}</a></li>
                    <li class="list-group-item"><strong>{{admin_lang('useragent')}}:</strong> {{$comment->useragent}}</li>
                    <li class="list-group-item"><strong>{{admin_lang('platformfamily')}}:</strong> <a href="{{get_admin_url('comments/platfrom/'.$comment->platformname)}}">{{$comment->platformname}}</a></li>
                    <li class="list-group-item"><strong>{{admin_lang('browserfamily')}}:</strong> <a href="{{get_admin_url('comments/browser/'.$comment->browserfamily)}}">{{$comment->browserfamily}}</a></li>
                </ul>
            </div>
        </div>
    </div>
</form>
@endsection
@section('style_files')
<link href="{{ asset('libs/tacf/tacf.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('script_files')
<script src="{{ asset('libs/tacf/tacf.min.js') }}"></script>
@endsection