@extends('dashboard.layouts.master')
@section('content')

<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $data['page_title'] }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{get_admin_url('/')}}">{{admin_lang('dashboard')}}</a></li>
            <li class="breadcrumb-item active"> <a href="{{ get_admin_url('deceased') }}">Deceased</a></li>
        </ol>
    </div>
</div>
    @if(session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
            @php session()->forget('success');@endphp
          
            @elseif(session()->has('failure'))
            <div class="alert alert-danger alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('failure') }}</div>  
            @php session()->forget('failure');@endphp
        @endif

        @if($errors->any())
    <div class="alert alert-danger">
        <ul>@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
    </div>
@endif
   <div class="card">
    <div class="card-body">
   
@php $identitys=config('deceasedinfo.IDENTITYS');
$death_places=config('deceasedinfo.PLACE_Of_DEATH');
$reasons=config('deceasedinfo.REASONS');
$informer_relation=config('deceasedinfo.INFORMER_RELATION');
@endphp

<form method="POST" action="{{ get_admin_url('DeceasedActions') }}" class="form-horizontal" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="action" value="{{$data['action']}}">
    <input type="hidden" name="query" value="action">
    <input type="hidden" name="deceased_id" value="{{$deceased->id}}">
    <div class="row">
 

    <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Surname</label><br>
        <input type="text" name="deceased_surname" id="deceased_surname" class="form-control" placeholder="Deceased Surname"  value="{{old('deceased_surname', $deceased->deceased_surname)}}">
        @if ($errors->has('deceased_surname'))
                    <span class="text-danger">{{ $errors->first('deceased_surname') }}</span>
                @endif     
        </div>
        </div>

         <div class="col-md-4">   
        <div class="form-group required">
         <label class="control-label">Deceased Name</label><br>
        <input type="text" name="deceased_name" id="deceased_name" class="form-control " placeholder="Deceased Name"  value="{{old('deceased_name', $deceased->deceased_name)}}">  
        @if ($errors->has('deceased_name'))
                    <span class="text-danger">{{ $errors->first('deceased_name') }}</span>
                @endif       
        </div>
    </div>

      <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Father/Husband Name</label><br>
        <input type="text" name="deceased_father_husband_name" id="deceased_father_husband_name" class="form-control " placeholder="Deceased father_husband_name"  value="{{old('deceased_father_husband_name',$deceased->deceased_father_husband_name)}}"> 
        @if ($errors->has('deceased_father_husband_name'))
                    <span class="text-danger">{{ $errors->first('deceased_father_husband_name') }}</span>
                @endif          
        </div>
        </div>


        <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Surname[Gujarati]</label><br>
        <input type="text" name="deceased_surname_gj" id="deceased_surname_gj" class="form-control col-md-6" placeholder="ગુજરાતીમાં મૃત અટક" value="{{old('deceased_surname_gj',$deceased->deceased_surname_gj)}}">  
        @if ($errors->has('deceased_surname_gj'))
                    <span class="text-danger">{{ $errors->first('deceased_surname_gj') }}</span>
                @endif         
        </div>
        </div>

        <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Deceased Name[Gujarati]</label><br>
        <input type="text" name="deceased_name_gj" id="deceased_name_gj" class="form-control col-md-6" placeholder="મૃતકનું નામ ગુજરાતીમાં" value="{{old('deceased_name_gj',$deceased->deceased_name_gj)}}">  
        @if ($errors->has('deceased_name_gj'))
                    <span class="text-danger">{{ $errors->first('deceased_name_gj') }}</span>
                @endif        
        </div>
        </div>
     

        <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Father/Husband Name[Gujarati]</label><br>
        <input type="text" name="deceased_father_husband_name_gj" id="deceased_father_husband_name_gj" class="form-control col-md-6 guj_text" placeholder="મૃત પિતા, પતિનું ગુજરાતીમાં નામ" value="{{old('deceased_father_husband_name_gj',$deceased->deceased_father_husband_name_gj)}}"> 
        @if ($errors->has('deceased_father_husband_name_gj'))
                    <span class="text-danger">{{ $errors->first('deceased_father_husband_name_gj') }}</span>
                @endif        
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Birth Date</label><br>
        <input type="date" name="birth_date" id="birth_date" class="form-control" placeholder="Date Of Birth" value="{{old('birth_date',$deceased->birth_date)}}">     
      @if ($errors->has('birth_date'))
                    <span class="text-danger">{{ $errors->first('birth_date') }}</span>
                @endif  
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Age</label><br>
        <input type="text" name="age" id="age" class="form-control" style="width:70px;" placeholder="Age"  maxlength="3" value="{{old('age',$deceased->age)}}" readonly>  
        @if ($errors->has('age'))
                    <span class="text-danger">{{ $errors->first('age') }}</span>
                @endif      
     
        </div>
        </div>

</div>        
</div>
</div>
            <div class="card">
            <div class="card-body">
            <h5 class="font-size-15 mb-2">Deceased Identity Information</h5>
            </div>
            <div class="row" style="margin-top:2px; margin-left:3px;">

            <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Identity Proof</label><br>
         @php $selected=$deceased->identity_proof;  @endphp
         <select name="identity_proof" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select Proof</option>
        @foreach($identitys as $key=>$identity) 
            @if($selected==$identity)
                <option value="{{$key}}" selected>{{$identity}}</option>
                @else
                <option value="{{$key}}">{{$identity}}</option>
            @endif
        @endforeach
      </select>
      @if ($errors->has('identity_proof'))
                    <span class="text-danger">{{ $errors->first('identity_proof') }}</span>
                @endif    
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Identity Proof File</label><br>
      
        <input type="file" name="identity_proof_file" cLass="form-control"  value="{{old('',$deceased->identity_proof_file)}}">   
        @if ($errors->has('identity_proof_file'))
                    <span class="text-danger">{{ $errors->first('identity_proof_file') }}</span>
                @endif       
        </div>
        </div>

</div>
</div>


<div class="card">
<div class="card-body">
<h5 class="font-size-15">Deceased Address</h5>  
</div>
<div class="row" style="margin-top:2px; margin-left:3px;">

         <div class="col-md-4">   
        <div class="form-group required">
         <label class="control-label">Address1</label><br>
        <textarea  name="address1" class="form-control" placeholder="Address 1" >{{old('address1',$deceased['deceased_address']->address1)}}</textarea> 
        @if ($errors->has('address1'))
                    <span class="text-danger">{{ $errors->first('address1') }}</span>
                @endif     
        </div>
    </div>

      <div class="col-md-4">
        <div class="form-group">
         <label>Address2</label><br>
        <textarea name="address2" class="form-control" placeholder="Address 2" > {{old('address2',$deceased['deceased_address']->address12)}}</textarea>    
        @if ($errors->has('address2'))
                    <span class="text-danger">{{ $errors->first('address2') }}</span>
                @endif   
        </div>
        </div>

        <div class="col-md-4">
        <div class="form-group">
         <label>Address3</label><br>
        <textarea name="address3" class="form-control" placeholder="Address 3">{{old('address3',$deceased['deceased_address']->address3)}}</textarea>   
        @if ($errors->has('address3'))
                    <span class="text-danger">{{ $errors->first('address3') }}</span>
                @endif   
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Counrty</label><br>
         <select name="country_id" id="deceased_country_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
         <option value="">Select Country</option>
        @foreach($deceased['country'] as $key=>$country)
        @if($deceased['country_info']->id==$country->id)
        <option value="{{$country->id}}" selected>{{$country->country_name}}</option>
        @else
        <option value="{{$country->id}}">{{$country->country_name}}</option>
        @endif
        @endforeach
         </select>   
         @if ($errors->has('country_id'))
                    <span class="text-danger">{{ $errors->first('country_id') }}</span>
                @endif   
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">State</label><br>
        <select name="state_id" id="deceased_state_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select State</option> 
        @foreach($deceased['state'] as $key=>$state)
        @if($deceased['state_info']->id==$state->id)
        <option value="{{$state->id}}" selected>{{$state->state_name}}</option>
        @else
        <option value="{{$state->id}}">{{$state->state_name}}</option>
        @endif
        @endforeach
        </select>
        @if ($errors->has('state_id'))
                    <span class="text-danger">{{ $errors->first('state_id') }}</span>
                @endif   
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">City</label><br>
        <select name="city_id" id="deceased_city_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select City</option> 
        @foreach($deceased['city'] as $key=>$city)
        @if($deceased['city_info']->id==$city->id)
        <option value="{{$city->id}}" selected>{{$city->city_name}}</option>
        @else
        <option value="{{$city->id}}">{{$city->city_name}}</option>
        @endif
        @endforeach
        </select>
        @if ($errors->has('city_id'))
                    <span class="text-danger">{{ $errors->first('city_id') }}</span>
                @endif   
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Area</label><br>
        <select name="area_id" id="deceased_area_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select Area</option> 
        @foreach($deceased['area'] as $key=>$area)
        @if($deceased['area_info']->id==$area->id)
        <option value="{{$area->id}}" selected>{{$area->area_name}}</option>
        @else
        <option value="{{$area->id}}">{{$area->area_name}}</option>
        @endif
        @endforeach
        </select>
        @if ($errors->has('area_id'))
                    <span class="text-danger">{{ $errors->first('area_id') }}</span>
                @endif  
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Pincode</label><br>
        <input type="text" name="pincode" style="height:29px;" class="form-control " placeholder="Pincode" value="{{old('pincode',$deceased['deceased_address']->pincode)}}">
        @if ($errors->has('pincode'))
                    <span class="text-danger">{{ $errors->first('pincode') }}</span>
                @endif         
        </div>
        </div>
</div>

</div>


<div class="card">
  <div class="card-body">
    <h5 class="font-size-15">Death Information</h5>
</div>
    <div class="row" style="margin-top:2px; margin-left:3px;">
    <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Reason Death</label><br>
        <select name="reason_death" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
       @foreach($reasons as $key=>$reason)
       @if($selected==$key)
                <option value="{{$key}}" selected>{{$reason}}</option>
                @else
                <option value="{{$key}}">{{$reason}}</option>
            @endif
    
       @endforeach
  </select> 
  @if ($errors->has('reason_death'))
                    <span class="text-danger">{{ $errors->first('reason_death') }}</span>
                @endif  
        </div>
        </div>
        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Place Death</label><br>
         <select name="place_death" class="form-control  custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select Place Death</option>
        @php $selected=ucfirst($deceased->place_death);  @endphp
         @foreach($death_places as $key=>$death_place)
      
         @if($selected==$death_place)
                 <option value="{{$key}}" selected>{{$death_place}}</option>
                @else
                <option value="{{$key}}">{{$death_place}}</option>
            @endif
       
         @endforeach
      </select>     
      @if ($errors->has('place_death'))
                    <span class="text-danger">{{ $errors->first('place_death') }}</span>
                @endif  
        </div>
        </div>
        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Death Date</label><br>
         <input type="datetime-local" name="death_date" cLass="form-control" placeholder="Death Date"  value="{{old('death_date',$deceased->death_date)}}">  
         @if ($errors->has('death_date'))
                    <span class="text-danger">{{ $errors->first('death_date') }}</span>
                @endif       
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Dafan Date</label><br>
         <input type="datetime-local" name="dafan_date" cLass="form-control" placeholder="Death Date"  value="{{old('death_date',$deceased->death_date)}}">  
         @if ($errors->has('death_date'))
                    <span class="text-danger">{{ $errors->first('death_date') }}</span>
                @endif       
        </div>
        </div>


        </div>
        </div>
        <div class="card">
          <div class="card-body">
            <h5 class="font-size-15">Hospital Information</h5>
            </div>
            <div class="row" style="margin-top:2px; margin-left:3px;">
            <div class="col-md-2">
            <div class="form-group required">
         <label class="control-label"> Hospital Letter File</label><br>
        <input type="file" name="hospital_letter_file" class="form-control" placeholder="Hospital Letter File" value=""/>
        @if ($errors->has('hospital_letter_file'))
                    <span class="text-danger">{{ $errors->first('hospital_letter_file') }}</span>
                @endif 
        </div>
        </div>


</div>
    </div>


       
        <div class="form-group mt-2">
        <button type="submit" class="btn btn-primary"><span></span>Correct</button>
        <a href="{{get_admin_url('deceased')}}" class="btn btn-danger"><span></span>Cancel</a>
        </div>
        
          
</form>
<script>
$(document).ready(function(){

    loadGujarati('deceased_surname_gj');
    loadGujarati('deceased_name_gj');
    loadGujarati('deceased_father_husband_name_gj');

    $("#birth_date").on("change",function(){
    var userDateinput = $(this).val();  
    var today = new Date();
    var birthDate = new Date(userDateinput);
    var age = today.getFullYear() - birthDate.getFullYear();
    var m = today.getMonth() - birthDate.getMonth();
    if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) 
    {
        age--;
    }
    $("#age").val(age);
  });

 
    $("#graveyard_book_no").on("blur",function(){
        var book_no=$("#graveyard_book_no").val();     
         url = "{{get_admin_url('ajax_book')}}";
        params = {id:book_no};
			getlistajax(url,params); 
    });

    $("#graveyard_receipt_no").on("blur",function(){     
      var receipt_no=$("#graveyard_receipt_no").val();
      var book_no=$("#graveyard_book_no").val();
      url = "{{get_admin_url('ajax_book_receipt')}}";
      params = {id:book_no,receipt_no:receipt_no};
      getlistajax(url,params);   
    });


    $("#deceased_country_id").on("change",function(){
        var Id=$(this).val();
        url = "{{get_admin_url('ajax_state')}}";
        params = {id:Id};
        getlistajax(url,params,'deceased_state_id');   
    });

    $("#deceased_state_id").on("change",function(){
        var Id=$(this).val();
        url = "{{get_admin_url('ajax_city')}}";
        params = {id:Id};
        getlistajax(url,params,'deceased_city_id');
        
    });

    $("#deceased_city_id").on("change",function(){
        var Id=$(this).val();
        url = "{{get_admin_url('ajax_area')}}";
        params = {id:Id};
        getlistajax(url,params,'deceased_area_id');
    });
    

    $("#informer_country_id").on("change",function(){
        var Id=$(this).val();
        url = "{{get_admin_url('ajax_state')}}";
        params = {id:Id};
        getlistajax(url,params,'informer_state_id');   
    });


    $("#informer_state_id").on("change",function(){
      var Id=$(this).val();
        url = "{{get_admin_url('ajax_city')}}";
        params = {id:Id};
        getlistajax(url,params,'informer_city_id');

    });

    $("#informer_city_id").on("change",function(){
      var Id=$(this).val();
        url = "{{get_admin_url('ajax_area')}}";
        params = {id:Id};
        getlistajax(url,params,'informer_area_id');

    });
    
});

 </script>  
@endsection