@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{$data['page_title']}}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="{{ get_admin_url('deceased') }}">Deceased</a></li>
            @if($data['userid'])
            <li class="breadcrumb-item"><a href="{{ get_admin_url('profile/'.$data['userid']) }}">{{ admin_lang('profile') }} :: {{ $data['username'] }}</a></li>
            @elseif((isset($deceased_view)) and $deceased_view =='true')
            <li class="breadcrumb-item"><a  href="{{get_admin_url('deceased_correction/'.$deceased->id)}}"><i class="fa fa-check" style="font-size:20px;"></i></a></li>
            <li class="breadcrumb-item"><a  href="{{get_admin_url('deceased_pdf/'.$deceased->id.'/lang/'.'1')}}" id="confirm_language" ><i class="fa fa-file-pdf-o red" style="font-size:25px;"></i></a></li>
            @else
            <li class="breadcrumb-item active">{{ admin_lang('add_new')}}</li>
            @endif
           
        </ol>
    </div>
</div>


@if(session()->has('success'))
<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
@php session()->forget('success');@endphp
@endif
@if($errors->any())
<div class="alert alert-danger">
    <ul>@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
</div>
@endif

<div class="card">
    <div class="card-body">
    @if(isset($deceased_view))
    @include('dashboard.deceased.view_deceased')
        @else
        @include('dashboard.deceased.deceased_form')
        @endif
    </div>
</div>
@endsection
@section('style_files')
<link href="{{ asset('libs/multiselect/css/multiselect.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('script_files')
<script src="{{ asset('libs/multiselect/js/jquery.multiselect.js') }}"></script>
<script src="{{ asset('dashboard/js/custom-file-input.min.js') }}"></script>
<script type="text/javascript">
bsCustomFileInput.init();
$(function() {$('#permission').multiSelect();});
</script>

@endsection