<style>
    .control-label:after {
        content: "*";
        color: red;
    }

    .no-after::after {
        content: none;
    }
</style>
@extends('dashboard.layouts.master')
@section('content')
    <div class="page-title-box d-flex align-items-center justify-content-between">
        <h4 class="mb-0 font-size-18">{{ $data['page_title'] }}</h4>
        <div class="page-title-right">
            <ol class="breadcrumb m-0">
                <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
                <li class="breadcrumb-item active">{{ $data['page_title'] }}</li>
            </ol>
        </div>
    </div>
    @if ($data['driver']->CARD_NUM && $data['status'] == 'ACTIVE')
        <form method="POST" action="{{ get_admin_url('storeLoadFunds') }}" class="form-horizontal"
            enctype="multipart/form-data">
            {{ csrf_field() }}
            <input type="hidden" name="driver_id" value="{{ $data['driver']->SMART_DRIVERID }}">
            <div class="row">

                <div class="col-md-3">
                    <div class="form-group">
                        <label class="control-label">Amount</label><br>
                        <input type="number" step="0.01" name="amount" id="amount" class="form-control col-md-6"
                            placeholder="Amount" value="{{ old('amount') }}" required>
                        @if ($errors->has('amount'))
                            <span class="text-danger">{{ $errors->first('amount') }}</span>
                        @endif
                        @if (session()->has('error'))
                            <span class="text-danger">{{ session()->get('error') }}</span>
                            @php
                                session()->forget('error');
                            @endphp
                        @endif
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label class="control-label">Issue To</label><br>
                        <input type="hidden" name="issue_to" id="issue_to" cLass="form-control col-md-6"
                            placeholder="Issue To"
                            value="{{ old('issue_to', $data['driver']->FIRST_NAME . '_' . $data['driver']->LAST_NAME) }}">
                        <div class="mt-1">{{ $data['driver']->FIRST_NAME . '_' . $data['driver']->LAST_NAME }}</div>
                        @if ($errors->has('issue_to'))
                            <span class="text-danger">{{ $errors->first('issue_to') }}</span>
                        @endif
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label class="control-label no-after">Notes</label><br>
                        <input type="text" name="notes" id="notes" cLass="form-control col-md-6"
                            placeholder="Notes" value="{{ old('notes', '') }}">
                        @if ($errors->has('notes'))
                            <span class="text-danger">{{ $errors->first('notes') }}</span>
                        @endif
                    </div>
                </div>

            </div>

            <div class="form-group mt-2">
                <button type="submit" class="btn btn-primary"><span></span>Add</button>
                <a href="{{ get_admin_url('driver') }}" class="btn btn-danger"><span></span>Cancel</a>
            </div>
        </form>
    @else
        <div class="form-group mt-2">
            <p style="color: red">
                {{ substr($data['driver']->CARD_NUM, 0, 6) }}******{{ substr($data['driver']->CARD_NUM, -4) }} Is
                Currently InActive</p>
            <a href="{{ route('addLoadFunds', $data['driver']->SMART_DRIVERID) }}"
                class="btn btn-primary"><span></span>Retry</a>
        </div>
    @endif
    <p>
        Electronic Funds Source LLC (EFS) Payment Instructions – U.S. Customers
        Instructions for Customer-Initiated Wires and ACH Payments
        <br><br>
        ***Fifth Third Bank has two different routing numbers, please make sure to use the appropriate routing number
        depending on payment type (Wire vs. ACH). If the incorrect routing number is used, the payment will be rejected by
        the bank.
        <br><br>
        <strong><b>Wire Instructions:</b></strong>
        <br><br>
        <b>Bank Name:</b> Fifth Third Bank <br>
        <b>Bank Address:</b> 38 Fountain Square, Cincinnati, OH 45263 <br>
        <b>Account Name:</b> WEX Bank <br>
        <b>Account Address:</b> 1104 Country Hills Drive, Ogden, Utah 84403 <br>
        <b>Account Number:</b> 7361767473 <br>
        <b>Wire Routing Number:</b> 042000314 <br>
        Please make sure to include Company Number (AR #) and Invoice Number (if desired) in the payment remittance
        information (“OBI Fields”). We cannot apply your payment without this information. Please follow the example
        illustrated below:
        <br><br>
        <strong><b>OBI Line 1:</b> AR # {{ $data['user']->ar_id }}</strong>
        <br><br>
        <strong><b>OBI Line 2:</b>
            ACH Instructions:</strong>
        <br><br>
        <b>Bank Name:</b> Fifth Third Bank <br>
        <b>Bank Address:</b> 38 Fountain Square,Cincinnati, OH 45263 <br>
        <b>Account Name:</b> WEX BANK <br>
        <b>Account Address:</b> 1104 Country Hills Drive, Ogden, Utah 84403 <br>
        <b>Account Number:</b> 7361767473 <br>
        <b>ACH Routing Number:</b> 064103833 <br>
        To the extent available with your banking provider, please include Company Number AND Statement Number in the ACH
        payment remittance information <br>
        Payment via Western Union:
        <br><br>
        <strong><b>Quick Collect Instructions:</b></strong> <br>
        <b>Code City:</b> ELECFS UT <br>
        <b>Company Name:</b> WEX BANK <br>
        Make sure to include your EFS Customer Number (typically 13 digits)
    </p>
@endsection
