
@extends('dashboard.layouts.master')
@section('content')
<style>
    .red{
        color: red;
    }
</style>
@action('admin_dashboard_before_counter')
@if(Auth::user()->userlevel == 'supervisor')
<div class="row">
    @action('admin_dashboard_counter')
    @if(session()->has('success'))
        <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
    @php session()->forget('success');@endphp
    @endif
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">Balance</p>
                        <h4 class="mb-0 {{Auth::user()->credit_available < Auth::user()->low_limit_threshold ? 'red' : ''}}" >$ {{ get_balance() }}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-file font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">Total Drivers</p>
                        <h4 class="mb-0">{{get_driver_count()}}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">Total Card</p>
                        <h4 class="mb-0">{{ get_card_count() }}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">Low Limit Threshold</p>
                        <form action="{{ route('low_limit_threshold', Auth::user()->id) }}" method="POST">
                            @csrf
                        <input type="text" class="mb-2" name="low_limit_threshold" value="{{Auth::user()->low_limit_threshold ? Auth::user()->low_limit_threshold : ''}}" placeholder="Low Limit Threshold">
                        <button type="submit" class="btn btn-primary btn-sm">Update</button>
                        </form>
                    </div>
                    <!-- <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-user font-size-24"></i></span>
                        </div>
                    </div> -->
                </div>
            </div>
        </div>
    </div>
</div>
@elseif(Auth::user()->userlevel == 'admin')
<div class="row">
    @action('admin_dashboard_counter')
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">Balance</p>
                        <h4 class="mb-0">$ {{ get_sum_of_all_company_user() }}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-file font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">Total Drivers</p>
                        <h4 class="mb-0">{{get_driver_count()}}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">Total Cards</p>
                        <h4 class="mb-0">{{ get_card_count() }}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">Total Company</p>
                        <h4 class="mb-0">{{ get_company_count() }}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-user font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@else
<div class="row">
    @action('admin_dashboard_counter')
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">{{admin_lang('pages')}}</p>
                        <h4 class="mb-0">{{get_post_count('pages')}}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-file font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">{{admin_lang('administrator')}}</p>
                        <h4 class="mb-0">{{get_user_level_count('admin')}}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">{{admin_lang('supervisor')}}</p>
                        <h4 class="mb-0">{{get_user_level_count('supervisor')}}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">{{admin_lang('users')}}</p>
                        <h4 class="mb-0">{{get_user_level_count('user')}}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-user font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card mini-stats-wid">
            <div class="card-body">
                <div class="d-flex">
                    <div class="flex-grow-1">
                        <p class="text-muted fw-medium">{{admin_lang('media_library')}}</p>
                        <h4 class="mb-0">{{get_media_count()}}</h4>
                    </div>
                    <div class="flex-shrink-0 align-self-center">
                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                            <span class="avatar-title"><i class="bx bx-camera font-size-24"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
@action('admin_dashboard_after_counter')

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="d-sm-flex flex-wrap"><h4 class="card-title mb-4">{{admin_lang('visits')}}</h4></div>
                <div id="stacked-column-chart" class="apex-charts" dir="ltr"></div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script_code')
<script type="text/javascript" src="{{ asset('dashboard/js/apexcharts.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('dashboard/js/echarts.min.js') }}"></script>
<script>
var options_visitors = {
    chart: {height: 270,type: "bar",stacked: !0,toolbar: {show: !1},zoom: {enabled: !0}},
    plotOptions: {bar: {horizontal: !1,columnWidth: "15%",endingShape: "rounded"}},
    dataLabels: {enabled: !1},
    series: [{name: "",data: [@foreach($visitors as $item) "{{$item['total']}}", @endforeach]}],
    xaxis: {categories: [@foreach($visitors as $item) "{{$item['day']}}", @endforeach]},
    colors: ["#556ee6"],
    legend: {position: "bottom"},
    fill: {opacity: 1}
};
chart_visitors = new ApexCharts(document.querySelector("#stacked-column-chart"), options_visitors);
chart_visitors.render();
</script>
@endsection
