@extends('dashboard.layouts.master')
@section('content')
    <style>
        .control-label:after {
            content: "*";
            color: red;
        }
    </style>
    @if ($mode)
        <div class="page-title-box d-flex align-items-center justify-content-between">
            <h4 class="mb-0 font-size-18">{{ $data['page_title'] }}</h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
                    <li class="breadcrumb-item active"> <a
                            href="{{ get_admin_url('property') }}">{{ $data['page_title'] }}</a></li>
                </ol>
            </div>
        </div>
        <form id="frmUpdate" method="POST" action="{{ get_admin_url('driverCardDetails') }}" class="form-horizontal"
            enctype="multipart/form-data">
            {{ csrf_field() }}
            <input type="hidden" name="id" value="{{ $driver->SMART_DRIVERID }}">

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-body">
                            <div class="account_info row">
                                <div class="account_info-group col-md-6"><label>{{ admin_lang('first_name') }}:</label>
                                    {{ $driver->FIRST_NAME }}</div>
                                <div class="account_info-group col-md-6"><label>{{ admin_lang('last_name') }}:</label>
                                    {{ $driver->LAST_NAME }}</div>
                                <div class="account_info-group col-md-6"><label>{{ admin_lang('username') }}:</label>
                                    {{ $driver->USERNAME }}</div>
                                <div class="account_info-group col-md-6"><label>{{ admin_lang('email') }}:</label>
                                    {{ $driver->DRIVER_EMAIL }}</div>
                                <div class="account_info-group col-md-6"><label>{{ admin_lang('phone') }}:</label>
                                    {{ $driver->DRIVER_PHONE }}</div>

                                <div class="account_info-group col-md-6"><label>{{ admin_lang('address') }}:</label>
                                    {{ $driver->ADDRESS }}</div>
                                <div class="account_info-group col-md-6"><label>{{ admin_lang('city') }}:</label>
                                    {{ $driver->CITY }}</div>
                                <div class="account_info-group col-md-6"><label>{{ admin_lang('state') }}:</label>
                                    {{ $driver->STATE }}</div>
                                <div class="account_info-group col-md-6"><label>{{ admin_lang('postalcode') }}:</label>
                                    {{ $driver->POSTAL }}</div>
                                <div class="account_info-group col-md-6"><label>{{ admin_lang('DOB') }}:</label>
                                    {{ $driver->DOB != '' ? date('m/d/Y', strtotime($driver->DOB)) : '' }}</div>
                                <div class="account_info-group col-md-6
                            ">
                                    <label>{{ admin_lang('SSN') }}:</label> {{ $driver->SSN_NUM }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label class="control-label">Card No</label><br>
                        <input type="number" name="CARD_NUM" id="CARD_NUM"
                            value="{{ old('CARD_NUM', $driver->CARD_NUM) }}" cLass="form-control col-md-6">
                        @if ($errors->has('CARD_NUM'))
                            <span class="text-danger">{{ $errors->first('CARD_NUM') }}</span>
                        @endif
                    </div>
                </div>

                <div class="col-md-1">
                    <div class="form-group">
                        <label class="control-label">CSV</label><br>
                        <input type="text" name="CSV_NUM" id="CSV_NUM" value="{{ old('CSV_NUM', $driver->CSV_NUM) }}"
                            cLass="form-control col-md-6">
                        <div><span class="hint">XXX(check back of your card)</span></div>
                        @if ($errors->has('CSV_NUM'))
                            <span class="text-danger">{{ $errors->first('CSV_NUM') }}</span>
                        @endif
                    </div>
                </div>

                <div class="col-md-1">
                    <div class="form-group">
                        <label class="control-label">Expires</label><br>
                        <input type="text" name="EXPIRES" id="EXPIRES" value="{{ old('EXPIRES', $driver->EXPIRES) }}"
                            cLass="form-control col-md-6" placeholder="MM/YY">
                        <div><span class="hint">MM/YY</span></div>
                        @if ($errors->has('EXPIRES'))
                            <span class="text-danger">{{ $errors->first('EXPIRES') }}</span>
                        @endif
                    </div>
                </div>
            </div>

            <div class="form-group mt-2">
                <button type="submit" class="btn btn-primary">Update</button>
                <a href="{{ get_admin_url('driver') }}" class="btn btn-danger">Cancel</a>
            </div>
        </form>
    @else
        <div class="page-title-box d-flex align-items-center justify-content-between">
            <h4 class="mb-0 font-size-18">{{ admin_lang('profile') }} :: {{ $data['username'] }}</h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('driver') }}">Driver</a></li>
                    <li class="breadcrumb-item active">{{ $data['username'] }}</li>
                </ol>
            </div>
        </div>
        @if (session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close"
                    data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
            @php session()->forget('success');@endphp
        @endif
        @if (session()->has('error'))
            <div class="alert alert-danger alert-dismissible fade show"><button type="button" class="btn-close"
                    data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('error') }}</div>
            @php session()->forget('error');@endphp
        @endif
        <div class="row">
            <div class="col-xl-4">
                <div class="card overflow-hidden">
                    <div class="bg-soft-primary bg-soft-usercover"
                        style="background-image: url({{ get_user_cover($data['userid']) }})">
                        <div class="row">
                            <div class="col-12">
                                <div class="text-primary p-3">
                                    <h5 class="text-primary">
                                        {{ $data['driver']->FIRST_NAME . ' ' . $data['driver']->LAST_NAME }}
                                    </h5>
                                    <p>{{ $data['email'] }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="avatar-md profile-user-wid mb-4">
                                    <img src="{{ get_user_avatar($data['userid']) }}" alt=""
                                        class="img-thumbnail rounded-circle">
                                </div>
                                <h5 class="font-size-15 text-truncate">
                                    @if (!empty($data['driver']->CARD_NUM))
                                        Card # :
                                        @if (Auth::user()->userlevel == 'admin')
                                            {{ $data['driver']->CARD_NUM }}
                                        @else
                                            {{ substr($data['driver']->CARD_NUM, 0, 6) }}******{{ substr($data['driver']->CARD_NUM, -4) }}
                                        @endif
                                        <p class="mt-1 mb-0">
                                            PIN : <span>{{ $data['driver']->CARD_PIN }}</span>
                                        </p>
                                        <p class="mt-1">
                                            Cash Available :
                                            <span id="get_cashavailable">

                                            </span>

                                            <span class='loader' style='display: none;'>
                                                <i class="fas fa-spinner fa-spin"></i>
                                            </span>
                                        </p>
                                        <a href="{{ route('addLoadFunds', $data['driver']->SMART_DRIVERID) }}"
                                            class="btn btn-primary">load Cash</a>
                                    @endif
                                </h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <div class="account_info">
                            <div class="account_info-group"><label>{{ admin_lang('username') }}:</label>
                                {{ $data['username'] }}</div>
                            <div class="account_info-group"><label>User/Email:</label> <a
                                    href="mailto:{{ $data['email'] }}">{{ $data['email'] }}</a></div>
                            <div class="account_info-group"><label>{{ admin_lang('created') }}:</label>
                                {{ date('m/d/Y', strtotime($data['user']->created_at)) }}</div>
                            <div class="account_info-group"><label>{{ admin_lang('updated') }}:</label>
                                {{ date('m/d/Y', strtotime($data['user']->updated_at)) }}</div>
                            <div class="account_info-group"><label>{{ admin_lang('last_seen') }}:</label>
                                @if ($data['signintime'])
                                    {{ date('m/d/Y', $data['signintime']) }}@else{{ admin_lang('none') }}
                                @endif
                            </div>
                            <div class="account_info-group"><label>Card Status: </label>
                                <span class='loader' style='display: none;'>
                                    <i class="fas fa-spinner fa-spin"></i>
                                </span>

                                <span id="card_status">

                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @if (session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close"
                    data-bs-dismiss="alert" aria-label="Close"></button>{!! session()->get('success') !!}</div>
        @endif
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        @action('admin_user_profile_before_container')
        <div class="tacf-box-container">
            <div class="tacf-box-tabs nav-tabs-cookie" data-cookie="profile_user" data-cookie-tab="tab-details">
                <a href="#" class="active" data-tab=".tab-edit"><i class="bx bx-pencil"></i>
                    User Login</a>
                <a href="#" class="" data-tab=".tab-card"><i class="bx bx-card"></i>
                    {{ admin_lang('card') }}</a>
                <a href="#" class="" data-tab=".tab-liveSmartDriverData" id="liveSmartDriverData"><i
                        class="bx bx-card"></i>Live
                    Smart Driver
                    Data</a>
                <a href="#" class="" data-tab=".tab-personalData"><i class="bx bx-card"></i>Personal
                    Data</a>
                <a href="#" class="" data-tab=".tab-cardInfo"><i class="bx bx-card"></i>Card Info</a>
                <a href="#" class="" data-tab=".tab-loadHistory"><i class="bx bx-card"></i>Load History</a>
                <a href="#" class="" data-tab=".tab-details"><i class="bx bx-file"></i>
                    {{ admin_lang('details') }}</a>
                @action('admin_user_profile_tabs', $data['user'])
            </div>
            <div class="tacf-tabs-content">
                <div class="tacf-tab-content tab-details p-0 ">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item"><strong>{{ admin_lang('id') }}:</strong> {{ $data['user']->id }}</li>
                        <li class="list-group-item"><strong>{{ admin_lang('first_name') }}:</strong>
                            {{ $data['driver']->FIRST_NAME }}</li>
                        <li class="list-group-item"><strong>{{ admin_lang('last_name') }}:</strong>
                            {{ $data['driver']->LAST_NAME }}</li>
                        <li class="list-group-item"><strong>Two Factor Auth:</strong>
                            {{ $data['driver']->two_factor == 1 ? 'YES' : 'NO' }}</li>
                        <li class="list-group-item"><strong>{{ admin_lang('username') }}:</strong>
                            {{ $data['user']->username }}</li>
                        <li class="list-group-item"><strong>{{ admin_lang('email') }}:</strong> <a
                                href="mailto:{{ $data['user']->email }}">{{ $data['user']->email }}</a></li>
                        <li class="list-group-item"><strong>{{ admin_lang('role') }}:</strong>
                            @if ($data['user']->userlevel == 'admin')
                                <span
                                class="badge badge-pill bg-danger">{{ admin_lang('userlevel_' . $data['user']->userlevel) }}</span>@else<span
                                    class="badge badge-pill bg-info">{{ admin_lang('userlevel_' . $data['user']->userlevel) }}</span>
                            @endif
                        </li>
                        @action('admin_user_profile_details', $data['user'])
                        <li class="list-group-item"><strong>{{ admin_lang('created') }}:</strong>
                            {{ date('m/d/Y', strtotime($data['user']->created_at)) }}</li>
                        <li class="list-group-item"><strong>{{ admin_lang('updated') }}:</strong>
                            {{ date('m/d/Y', strtotime($data['user']->updated_at)) }}</li>
                        <li class="list-group-item"><strong>{{ admin_lang('last_seen') }}:</strong>
                            @if ($data['signintime'])
                                {{ date('m/d/Y', $data['signintime']) }}@else{{ admin_lang('none') }}
                            @endif
                        </li>
                        <li class="list-group-item"><strong>{{ admin_lang('ip') }}:</strong> <a
                                href="{{ get_admin_url('users/platform/' . $data['details']['ip']) }}">{{ $data['details']['ip'] }}</a>
                        </li>
                        <li class="list-group-item"><strong>{{ admin_lang('useragent') }}:</strong>
                            {{ $data['details']['useragent'] }}</li>
                        <li class="list-group-item"><strong>{{ admin_lang('platformname') }}:</strong> <a
                                href="{{ get_admin_url('users/platform/' . $data['details']['platformname']) }}">{{ $data['details']['platformname'] }}</a>
                        </li>
                        <li class="list-group-item"><strong>{{ admin_lang('browserfamily') }}:</strong> <a
                                href="{{ get_admin_url('users/browser/' . $data['details']['browserfamily']) }}">{{ $data['details']['browserfamily'] }}</a>
                        </li>
                    </ul>
                </div>

                <div class="tacf-tab-content tab-edit active">
                    <form method="POST" action="{{ get_admin_url('driverActions') }}" class="form-horizontal"
                        enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <input type="hidden" name="action" value="{{ $data['action'] }}">
                        <input type="hidden" name="userid" value="{{ $data['userid'] }}">
                        <div class="row">
                            <div class="col-md-12">
                                @action('admin_user_form_before', $data['userid'])
                                <h4 class="card-title"><i class="bx bx-id-card"></i> {{ admin_lang('personal_data') }}
                                </h4>
                                <hr />
                                <div class="row">

                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="email">User/Email</label>
                                            <div class="frm-input">
                                                <input class="form-control" name="email" type="email" id="email"
                                                    value="@if (old('email')) {{ old('email') }}@else{{ $data['email'] }} @endif"
                                                    placeholder="{{ admin_lang('email') }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label>Two Factor</label>
                                            <div>
                                                <input type="checkbox" name="two_factor" value="1"
                                                    class="custom-control-input" switch="bool" id="status_switch"
                                                    @if ($data['user']->two_factor == 1) checked @endif>
                                                <label for="status_switch" data-on-label="YES"
                                                    data-off-label="NO"></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @action('admin_user_form_personal_data', $data['userid'])
                                <h4 class="card-title"><i class="bx bx-lock-alt"></i> {{ admin_lang('password') }}
                                    <small>{{ admin_lang('leave_field_change') }}</small>
                                </h4>
                                <hr />
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="password">{{ admin_lang('password') }}</label>
                                            <div class="input-group">
                                                <input class="form-control" name="password" type="text"
                                                    id="password"
                                                    value="{{ old('password', $data['driver']->PASSWORD) }}"
                                                    placeholder="{{ admin_lang('password') }}">
                                                <span class="input-group-text"><i class="bx bx-lock"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="confirm_password">{{ admin_lang('confirm_password') }}</label>
                                            <div class="input-group">
                                                <input class="form-control" name="password_confirmation" type="text"
                                                    id="confirm_password"
                                                    value="{{ old('password_confirmation', $data['driver']->PASSWORD) }}"
                                                    placeholder="{{ admin_lang('confirm_password') }}">
                                                <span class="input-group-text"><i class="bx bx-lock"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="pin_number">{{ admin_lang('pincode') }}
                                                <small>{{ admin_lang('admin_only') }}</small></label>
                                            <div class="input-group">
                                                <input class="form-control" name="pin_number" type="text"
                                                    id="pin_number"
                                                    value="{{ old('pin_number', $data['driver']->pin_number) }}"
                                                    placeholder="{{ admin_lang('pincode') }}">
                                                <span class="input-group-text"><i class="bx bx-dialpad"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @action('admin_user_form_password_data', $data['userid'])

                                @action('admin_user_form_after', $data['userid'])
                            </div>
                        </div>
                        <hr />
                        <div class="form-group mb-0">
                            <button type="submit" class="btn btn-primary"><span></span>
                                @if ($data['action'] == 'update')
                                    {{ admin_lang('update') }}
                                @else
                                    {{ admin_lang('add_new') }}
                                @endif
                            </button>
                        </div>
                    </form>
                </div>

                <div class="tacf-tab-content tab-card">
                    <form method="POST" action="{{ get_admin_url('driver_card_pin') }}" class="form-horizontal"
                        enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <input type="hidden" name="action" value="setcardpin">
                        <input type="hidden" name="userid" value="{{ $data['userid'] }}">
                        <input type="hidden" name="driverid" value="{{ $data['driver']->SMART_DRIVERID }}">
                        <div class="row">
                            <div class="col-md-12">
                                @action('admin_user_form_before', $data['userid'])
                                <h4 class="card-title"><i class="bx bx-id-card"></i> {{ admin_lang('card_data') }}</h4>
                                <hr />


                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="username">{{ admin_lang('CARD_NUM') }}</label>
                                            <div class="frm-input">
                                                @if (Auth::user()->userlevel == 'admin')
                                                    {{ $data['driver']->CARD_NUM }}
                                                @else
                                                    @if (!empty($data['driver']->CARD_NUM))
                                                        {{ substr($data['driver']->CARD_NUM, 0, 6) }}******{{ substr($data['driver']->CARD_NUM, -4) }}
                                                    @endif
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="username">{{ admin_lang('CSV_NUM') }}</label>
                                            <div class="frm-input">
                                                {{ $data['driver']->CSV_NUM }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="username">{{ admin_lang('EXPIRES') }}</label>
                                            <div class="frm-input">
                                                {{ $data['driver']->EXPIRES }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label">Status</label>
                                            <span class='loader' style='display: none;'>
                                                <i class="fas fa-spinner fa-spin"></i>
                                            </span>
                                            <br>
                                            <input type="radio" value="1" name="STATUS" id="active">
                                            <label for="active">Active</label>
                                            <input type="radio" value="0" name="STATUS" id="inactive"> <label
                                                for="inactive">InActive</label>
                                            @if ($errors->has('STATUS'))
                                                <span class="text-danger">{{ $errors->first('STATUS') }}</span>
                                            @endif
                                        </div>
                                        <div><span class="hint">Active/Dective Status will Active/Dective CARD #</span>
                                        </div>
                                    </div>


                                    <div class="col-md-1">
                                        <div class="form-group mb-4">
                                            <label for="CARD_PIN">{{ admin_lang('CARD_PIN') }}</label>
                                            <div class="frm-input">
                                                <input class="form-control" name="CARD_PIN" type="text"
                                                    id="CARD_PIN"
                                                    value="@if (old('CARD_PIN')) {{ old('CARD_PIN') }}@else{{ $data['driver']->CARD_PIN }} @endif"
                                                    placeholder="{{ admin_lang('CARD_PIN') }}" required>
                                                @if ($errors->has('CARD_PIN'))
                                                    <span class="text-danger">{{ $errors->first('CARD_PIN') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @action('admin_user_form_personal_data', $data['userid'])
                            </div>
                        </div>
                        <hr />
                        <div class="form-group mb-0">
                            <button type="submit" class="btn btn-primary"><span></span>
                                @if ($data['action'] == 'update')
                                    {{ admin_lang('set_pin') }}
                                @else
                                    {{ admin_lang('add_new') }}
                                @endif
                            </button>
                        </div>

                    </form>
                </div>

                <div class="tacf-tab-content tab-liveSmartDriverData">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item"><strong>Address : </strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_Address"></span>
                        </li>
                        <li class="list-group-item"><strong>City : </strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_City"></span>
                        </li>
                        <li class="list-group-item"><strong>State :</strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_State"></span>
                        </li>
                        <li class="list-group-item"><strong>Postal Code :</strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_Postal"></span>
                        </li>
                        <li class="list-group-item"><strong>Country : </strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_Country"></span>
                        </li>
                        <li class="list-group-item"><strong>DOB : </strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_DOB"></span>
                        </li>
                        <li class="list-group-item"><strong>Social Security No. :</strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_Last4ss"></span>
                        </li>
                        <li class="list-group-item"><strong>Phone :</strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_Phone"></span>
                        </li>
                    </ul>
                </div>

                <div class="tacf-tab-content tab-personalData">
                    <form method="POST" action="{{ get_admin_url('driver_personal_data') }}" class="form-horizontal"
                        enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <input type="hidden" name="action" value="{{ $data['action'] }}">
                        <input type="hidden" name="userid" value="{{ $data['userid'] }}">
                        <input type="hidden" name="driverid" value="{{ $data['driver']->SMART_DRIVERID }}">
                        <div class="row">

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Address</label><br>
                                    <input type="text" name="ADDRESS" id="ADDRESS"
                                        value="{{ old('ADDRESS', $data['driver']->ADDRESS) }}"
                                        cLass="form-control col-md-6" required>
                                    @if ($errors->has('ADDRESS'))
                                        <span class="text-danger">{{ $errors->first('ADDRESS') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">City</label><br>
                                    <input type="text" name="CITY" id="CITY" cLass="form-control col-md-6"
                                        value="{{ old('CITY', $data['driver']->CITY) }}" required>
                                    @if ($errors->has('CITY'))
                                        <span class="text-danger">{{ $errors->first('CITY') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">State</label><br>
                                    <?php $state = ['AL', 'AK', 'AZ', 'AR', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 'ID', 'IL', 'IN', 'IA', 'KS', 'KY', 'LA', 'ME', 'MD', 'MA', 'MI', 'MN', 'MS', 'MO', 'MT', 'NE', 'NV', 'NH', 'NJ', 'NM', 'NY', 'NC', 'ND', 'OH', 'OK', 'OR', 'PA', 'RI', 'SC', 'SD', 'TN', 'TX', 'UT', 'VT', 'VA', 'WA', 'WV', 'WI', 'WY']; ?>
                                    <select name="STATE" id="STATE"
                                        class="form-control custom-select form-select custom-select-sm form-control form-control-sm"
                                        required>
                                        @foreach ($state as $item)
                                            <option
                                                value="{{ $item }}"{{ $item == $data['driver']->STATE ? 'selected' : '' }}>
                                                {{ $item }}</option>
                                        @endforeach
                                    </select>
                                    @if ($errors->has('STATE'))
                                        <span class="text-danger">{{ $errors->first('STATE') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Postal Code</label><br>
                                    <input type="text" name="POSTAL" id="POSTAL" cLass="form-control col-md-6"
                                        value="{{ old('POSTAL', $data['driver']->POSTAL) }}" required>
                                    @if ($errors->has('POSTAL'))
                                        <span class="text-danger">{{ $errors->first('POSTAL') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Country</label><br>
                                    <input type="text" name="COUNTRY" id="COUNTRY" cLass="form-control col-md-6"
                                        value="{{ old('COUNTRY', $data['driver']->COUNTRY) }}" required>
                                    @if ($errors->has('COUNTRY'))
                                        <span class="text-danger">{{ $errors->first('COUNTRY') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Dob</label><br>
                                    <input type="date" name="DOB" id="DOB" cLass="form-control col-md-6"
                                        value="{{ old('DOB', $data['driver']->DOB != '' ? date('Y-m-d', strtotime($data['driver']->DOB)) : '') }}"
                                        required>
                                    @if ($errors->has('DOB'))
                                        <span class="text-danger">{{ $errors->first('DOB') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Social Security No.</label><br>
                                    <input type="text" name="SSN_NUM" id="SSN_NUM"
                                        cLass="form-control col-md-6 SSN_NUM"
                                        value="{{ old('SSN_NUM', $data['driver']->SSN_NUM) }}" required>
                                    @if ($errors->has('SSN_NUM'))
                                        <span class="text-danger">{{ $errors->first('SSN_NUM') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Phone</label><br>
                                    <input type="text" name="DRIVER_PHONE" id="DRIVER_PHONE"
                                        cLass="form-control col-md-6 DRIVER_PHONE"
                                        value="{{ old('DRIVER_PHONE', $data['driver']->DRIVER_PHONE) }}" required>
                                    @if ($errors->has('DRIVER_PHONE'))
                                        <span class="text-danger">{{ $errors->first('DRIVER_PHONE') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Sub Status</label><br>
                                    <select name="SUB_STATUS" id="SUB_STATUS"
                                        class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
                                        <option value="New Card Order"
                                            {{ $data['driver']->SUB_STATUS == 'New Card Order' ? 'selected' : '' }}>
                                            New
                                            Card
                                            Order</option>
                                        <option value="Processed"
                                            {{ $data['driver']->SUB_STATUS == 'Processed' ? 'selected' : '' }}>
                                            Processed
                                        </option>
                                        <option value="Active"
                                            {{ $data['driver']->SUB_STATUS == 'Active' ? 'selected' : '' }}>Active
                                        </option>
                                        <option value="Inactive"
                                            {{ $data['driver']->SUB_STATUS == 'Inactive' ? 'selected' : '' }}>Inactive
                                        </option>
                                    </select>
                                    @if ($errors->has('SUB_STATUS'))
                                        <span class="text-danger">{{ $errors->first('SUB_STATUS') }}</span>
                                    @endif
                                </div>
                            </div>

                        </div>
                        <div class="col-md-3">
                            <div class="form-group mt-2">
                                <button type="submit" class="btn btn-primary">Update</button>
                                <button type="button" id="set_default_data" class="btn btn-primary">Set Default
                                    Data</button>
                            </div>
                        </div>


                    </form>
                </div>

                <div class="tacf-tab-content tab-cardInfo">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item"><strong>Status : </strong>
                            <span class='loader' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="card_info_status"></span>
                        </li>
                        <li class="list-group-item"><strong>Card Number : </strong>
                            <span class='loader' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="card_info_card_no"></span>
                        </li>
                        <li class="list-group-item"><strong>Last Transaction # :</strong>
                            <span class='loader' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="card_info_last_tr"></span>
                        </li>
                        <li class="list-group-item"><strong>Last Transaction Date :</strong>
                            <span class='loader' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="card_info_last_tr_date"></span>
                        </li>
                    </ul>
                </div>

                <div class="tacf-tab-content tab-loadHistory">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-sm-flex flex-wrap">
                                <h4 class="card-title">Load History</h4>
                            </div>
                            <table id="jq-table" class="table table-striped table-bordered drivertable mt-4">
                                <thead>
                                    <tr>
                                        <th>Driver Name</th>
                                        <th>Amount</th>
                                        <th>Issue To</th>
                                        <th>Notes</th>
                                        <th>Ref ID</th>
                                        <th>Created Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($data['driver_fund'] as $driver)
                                        <tr>
                                            <td>
                                                {{ $driver->drivers->USERNAME }}
                                            </td>
                                            <td>
                                                $ {{ number_format($driver->amount, 2) }}
                                            </td>
                                            <td>
                                                {{ $driver->issue_to }}
                                            </td>
                                            <td>
                                                {{ $driver->notes }}
                                            </td>
                                            <td>
                                                {{ $driver->ref_id }}
                                            </td>
                                            <td>
                                                {{ date('m-d-Y', strtotime($driver->created_at)) }}
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                @action('admin_user_profile_tabs_content', $data['user'])
            </div>
        </div>
        @action('admin_user_profile_after_container', $data['user'])
    @endif

@endsection
@section('style_files')
    <link href="{{ asset('libs/tacf/tacf.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('libs/multiselect/css/multiselect.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('script_files')
    <script src="{{ asset('libs/tacf/tacf.min.js') }}"></script>
    <script src="{{ asset('libs/multiselect/js/jquery.multiselect.js') }}"></script>
    <script src="{{ asset('dashboard/js/custom-file-input.min.js') }}"></script>
    <script type="text/javascript">
        bsCustomFileInput.init();
        $(function() {
            $('#permission').multiSelect();
        });
    </script>
    <script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyD5BQa0hFcyKzBa_dA2cbKt3QvdiWhxOvY&libraries&callback=initAutocomplete&libraries=places&v=weekly"
        defer></script>

    <script>
        // This sample uses the Places Autocomplete widget to:
        // 1. Help the user select a place
        // 2. Retrieve the address components associated with that place
        // 3. Populate the form fields with those address components.
        // This sample requires the Places library, Maps JavaScript API.
        // Include the libraries=places parameter when you first load the API.
        // For example: <script
        // src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places">
        let autocomplete;
        let address1Field;
        let address2Field;
        let postalField;

        function initAutocomplete() {
            address1Field = document.querySelector("#ADDRESS");
            postalField = document.querySelector("#POSTAL");
            // Create the autocomplete object, restricting the search predictions to
            // addresses in the US and Canada.
            autocomplete = new google.maps.places.Autocomplete(address1Field, {
                componentRestrictions: {
                    country: ["us"]
                },
                fields: ["address_components", "geometry"],
                types: ["address"],
            });
            address1Field.focus();
            // When the user selects an address from the drop-down, populate the
            // address fields in the form.
            autocomplete.addListener("place_changed", fillInAddress);
        }

        function fillInAddress() {
            // Get the place details from the autocomplete object.
            const place = autocomplete.getPlace();
            let address1 = "";
            let postcode = "";

            // Get each component of the address from the place details,
            // and then fill-in the corresponding field on the form.
            // place.address_components are google.maps.GeocoderAddressComponent objects
            // which are documented at http://goo.gle/3l5i5Mr
            for (const component of place.address_components) {
                // @ts-ignore remove once typings fixed
                const componentType = component.types[0];

                switch (componentType) {
                    case "street_number": {
                        address1 = `${component.long_name} ${address1}`;
                        break;
                    }

                    case "route": {
                        address1 += component.short_name;
                        break;
                    }

                    case "postal_code": {
                        postcode = `${component.long_name}${postcode}`;
                        break;
                    }

                    case "postal_code_suffix": {
                        postcode = `${postcode}-${component.long_name}`;
                        break;
                    }
                    case "locality":
                        document.querySelector("#CITY").value = component.long_name;
                        break;
                    case "administrative_area_level_1": {
                        document.querySelector("#STATE").value = component.short_name;
                        break;
                    }
                    case "POSTAL":
                        document.querySelector("#POSTAL").value = component.postcode;
                        break;
                }
            }

            address1Field.value = address1;
            postalField.value = postcode;
            // After filling the form with address components from the Autocomplete
            // prediction, set cursor focus on the second address line to encourage
            // entry of subpremise information such as apartment, unit, or floor number.
        }

        window.initAutocomplete = initAutocomplete;
    </script>
    <script>
        $(document).ready(function() {
            $('.DRIVER_PHONE').inputmask('(999)-999-9999');
            $('.SSN_NUM').inputmask('999-99-9999');
        });
    </script>
    <script>
        $(document).ready(function() {
            var url = "{{ route('get_cashavailable', '@') }}";
            url = url.replace('@', '{{ $data['driver']->SMART_DRIVERID }}');
            $.ajax({
                url: url,
                type: "GET",
                beforeSend: function() {
                    $("#load_cash").hide();
                    $(".loader").show();
                },
                success: function(data) {
                    var cashAvailable = parseFloat(data);
                    var formattedCash = cashAvailable.toFixed(2);
                    $('#get_cashavailable').html('$ ' + formattedCash);
                },
                complete: function(data) {
                    $(".loader").hide();
                }
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            var url = "{{ route('card_info', '@') }}";
            url = url.replace('@', '{{ $data['driver']->SMART_DRIVERID }}');
            console.log(url);
            $.ajax({
                url: url,
                type: "GET",
                beforeSend: function() {
                    $(".loader").show();
                },
                success: function(data) {
                    if (data != []) {
                        $('#card_info_last_tr_date').html(data['header']['lastUsedDate']);
                        $('#card_info_last_tr').html(data['header']['lastTransaction']);
                        $('#card_info_status').html(data['header']['status']);
                        $('#card_status').html(data['header']['status']);
                        if (data['header']['status'] == 'ACTIVE') {
                            $('#active').val(1);
                            $('#active').attr('checked', 'checked');
                        } else if (data['header']['status'] == 'INACTIVE') {
                            $('#inactive').val(0);
                            $('#inactive').attr('checked', 'checked');
                        }
                        if ("{{ Auth::user()->userlevel }}" == 'admin') {
                            $('#card_info_card_no').html(data['cardNumber']);
                        } else {
                            var cardNumber = data['cardNumber'];
                            var formattedCardNumber = cardNumber.substr(0, 6) + "******" + cardNumber
                                .substr(-4);
                            $('#card_info_card_no').html(formattedCardNumber);
                        }
                    }
                },
                complete: function(data) {
                    $(".loader").hide();
                }
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#set_default_data').on('click', function() {
                $('#ADDRESS').val('P.O. box 680');
                $('#CITY').val('Murrayville');
                $('#STATE').val('GA');
                $('#POSTAL').val('30564');
                $('#COUNTRY').val('USA');
                $('#DOB').val('1988-09-21');
                $('#SSN_NUM').val('555-25-4878');
                $('#DRIVER_PHONE').val('945-250-9945');
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#liveSmartDriverData').on('click', function() {
                var url = "{{ route('liveSmartDriverData', '@') }}";
                url = url.replace('@', '{{ $data['driver']->SMART_DRIVERID }}');
                $.ajax({
                    url: url,
                    type: "GET",
                    beforeSend: function() {
                        $("#load_cash").hide();
                        $(".loader1").show();
                    },
                    success: function(data) {
                        $('#live_Address').html(data.address);
                        $('#live_City').html(data.city);
                        $('#live_State').html(data.state);
                        $('#live_Postal').html(data.postalCode);
                        $('#live_Country').html(data.country);
                        $('#live_DOB').html(new Date(data.dob).toLocaleDateString('en-US', {
                            month: '2-digit',
                            day: '2-digit',
                            year: 'numeric'
                        }));
                        $('#live_Last4ss').html(data.last4ss);
                        $('#live_Phone').html(data.phone);
                    },
                    complete: function(data) {
                        $(".loader1").hide();
                    }
                });
            });
        });
    </script>
@endsection
