@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $page_title }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            <li class="breadcrumb-item active">{{ $page_title }}</li>
        </ol>
    </div>
</div>
@if(session()->has('success'))
<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{!! session()->get('success') !!}</div>
@endif
<div class="row">
    @foreach ( $fetched_extensions as $directory => $extension )
    <div class="col-md-6 col-xl-3">
        <div class="card text-center">
            <div class="card-body p-3"><h4 class="card-title m-0">{{$extension['name']}}</h4></div>
            <div class="extension-screenshot">
                <img class="img-fluid list-group-item" src="{{$extension['screenshot']}}" alt="">
                @if($extension['license'] == 'free')
                <span class="license free">{{admin_lang('free')}}</span>
                @elseif($extension['license'] == 'paid')
                <span class="license paid">{{admin_lang('paid')}}</span>
                @endif
            </div>
            <div class="p-2">
                {{admin_lang('version')}} {{$extension['version']}} | {{admin_lang('author')}} <a href="{{$extension['authoruri']}}" target="_blank">{{$extension['author']}}</a>
            </div>
            <div class="card-body pl-3 pr-3 pb-3 pt-2">
                @if ( $extension['compatible'] ) 
                    @if ( $extension['activated'] )
                        <a class="card-link btn btn-sm waves-effect waves-light btn-danger" href="{{get_admin_url('extensions/deactivate/'.$directory.'/'.csrf_token())}}">{{admin_lang('deactivate')}}</a>
                    @else
                        <a class="card-link btn btn-sm waves-effect waves-light btn-success" href="{{get_admin_url('extensions/activate/'.$directory.'/'.csrf_token())}}">{{admin_lang('activate' )}}</a>
                    @endif
                @else 
                    <a class="card-link btn btn-sm waves-effect waves-light btn-success" href="https://codecanyon.net/item/php-help-manager/12031944?ref=themearabia" target="_blank">{{admin_lang('requires_version')}} {{$extension['requires']}}</a>
                @endif
                <a class="card-link btn btn-sm waves-effect waves-light btn-info" href="{{$extension['website']}}" target="_blank">{{admin_lang('extension_page')}}</a>
            </div>
        </div>
    </div>
    @endforeach
</div>
@endsection