@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $data['page_title'] }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{get_admin_url('/')}}">{{admin_lang('dashboard')}}</a></li>
            <li class="breadcrumb-item active"> <a href="{{ get_admin_url('state') }}">State</a></li>
        </ol>
    </div>
</div>
    @if(session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
            @php session()->forget('success');@endphp
            
            @elseif(session()->has('failure'))
            <div class="alert alert-warning alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('failure') }}</div>  
            @php session()->forget('failure');@endphp
        @endif
   @php 
    $statecountry=$state->country;
   @endphp
   <div class="card">
    <div class="card-body">
     
<form method="POST" action="{{ get_admin_url('StateActions') }}" class="form-horizontal" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="action" value="{{$data['action']}}">
    <input type="hidden" name="query" value="action">
    <input type="hidden" name="id" value="{{$state->id}}">
    <div class="row">
        
         <div class="col-md-12">   
         <div class="form-group required">
         <label class="control-label">Country</label><br>
         <select name="country_id" class="custom-select form-select custom-select-sm form-control form-control-sm" style="width: 150px;">
         <option value="" selected>Select Country</option>  
         @if(isset($statecountry->id))   
         <option value="{{$statecountry->id}}" selected>{{$statecountry->country_name}}</option>  
         @endif   
         @foreach($countrys as $country)
         <option value="{{$country->id}}">{{$country->country_name}}</option> 
         @endforeach
         </select>
        </div>
    </div>



    <div class="col-md-5">
        <div class="form-group required">
         <label class="control-label">State Name</label><br>
        <input type="text" name="state_name" id="state_name" class="form-control col-md-6" placeholder="State Name"  value="{{$state->state_name}}">       
        </div>
    </div>
       
            <div class="col-md-5">
        <div class="form-group required">
         <label class="control-label">State Name[Gujarati]</label><br>
        <input type="text" name="state_name_gj" id="state_name_gj"  cLass="form-control col-md-6 " placeholder="રાજ્ય નામ"  value="{{$state->state_name_gj}}">       
        </div>
    </div>

</div>

        <div class="form-group mt-2">
        <button type="submit" class="btn btn-primary"><span></span>Update</button>
        <a href="{{get_admin_url('state')}}" class="btn btn-danger"><span></span>Cancel</a>
    </div>
        
          
</form>
</div>
</div>
<script>
$(document).ready(function () {
    loadGujarati('state_name_gj');
});
</script>

@endsection