<!DOCTYPE html>
<html lang="en" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ get_option('sitename') }} - {{ (isset($page_title))? $page_title : '' }}</title>
    <link rel="icon" href="{{ get_asset('images/favicon.ico') }}">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500">
    <link href="{{ asset('dashboard/css/bootstrap-rtl.min.css') }}" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="{{ asset('dashboard/css/login.min.css') }}" type="text/css" />
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    <style>
        .rtl .signin-form-wrap .form-control{
            padding-left: 10px;
        }
    </style>
</head>
<body class="signin rtl">
<div class="container padding_60">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6 col-xl-5">
            <div class="card overflow-hidden">
                <div class="bg-cover">
                    <div class="row">
                        <div class="col-7">
                            <div class="text-primary p-4">
                                <h5 class="text-primary">{{ get_option('sitename') }}</h5>
                                <p>Two Factor Authentication</p>
                            </div>
                        </div>
                        <div class="col-5 align-self-end">
                            <img src="{{ asset('dashboard/images/cover-profile.png') }}" alt="" class="img-fluid">
                        </div>
                    </div>
                </div>
                <div class="card-body signin-form-wrap">
                    <a href="{{url('/')}}" class="linkhome">
                        <div class="home-icon-wid mb-4">
                            <span class="home-icon rounded-circle">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" width="24"><path fill="currentColor" d="M541 229.16l-61-49.83v-77.4a6 6 0 0 0-6-6h-20a6 6 0 0 0-6 6v51.33L308.19 39.14a32.16 32.16 0 0 0-40.38 0L35 229.16a8 8 0 0 0-1.16 11.24l10.1 12.41a8 8 0 0 0 11.2 1.19L96 220.62v243a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-128l64 .3V464a16 16 0 0 0 16 16l128-.33a16 16 0 0 0 16-16V220.62L520.86 254a8 8 0 0 0 11.25-1.16l10.1-12.41a8 8 0 0 0-1.21-11.27zm-93.11 218.59h.1l-96 .3V319.88a16.05 16.05 0 0 0-15.95-16l-96-.27a16 16 0 0 0-16.05 16v128.14H128V194.51L288 63.94l160 130.57z" class=""></path></svg>
                            </span>
                        </div>
                    </a>
                    <br />
                    @if(session()->has('errorlogin'))<div class="alert alert-warning">{{ admin_other_lang('error_login') }}</div>@endif
                    @if($errors->any())
                        <div class="alert alert-warning">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <p id="message_error" style="color:red;"></p>
                    <p id="message_success" style="color:green;"></p>
                    <form class="form-horizontal" method="POST" id="verificationForm">
                        {{ csrf_field() }}
                        <input type="hidden" name="user_id" value="{{ $user_id }}">
                        <div class="form-group">
                            <input type="number" class="form-control" name="token" id="token" placeholder="Enter 6 Digits Otp" required>
                        </div>

                        <div class="mt-3">
                            <p class="time"></p>
                        </div>

                        <div class="mt-3">
                            <button class="btn btn-primary btn-block" type="submit">Verify</button>
                            <button type="button" class="btn btn-primary btn-block" id="resendOtpVerification" style="opacity: 0.5;">Resend</button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
<script>
    $(document).ready(function(){
        $('#verificationForm').submit(function(e){
            e.preventDefault();

            var formData = $(this).serialize();

            $.ajax({
                url:"{{ route('verifiedOtp') }}",
                type:"POST",
                data: formData,
                success:function(res){
                    if(res.success){
                        if(res.data.userlevel == 'user'){
                            window.location.href = "{{ route('driverprofileById') }}";
                        }
                        window.location.href = "{{route('otp_dashboard')}}";
                    }
                    else{
                        $('#message_error').text(res.msg);
                        setTimeout(() => {
                            $('#message_error').text('');
                        }, 3000);
                    }
                }
            });

        });

        $('#resendOtpVerification').click(function(){
            $(this).text('Wait...');
            var userID = @json($user_id);

            $.ajax({
                url:"{{ route('resendOtp') }}",
                type:"GET",
                data: {user_id:userID },
                success:function(res){
                    $('#resendOtpVerification').text('Resend');
                    if(res.success){
                        timer();
                        $('#resendOtpVerification').css('opacity', '0.5');

                        $('#message_success').text(res.msg);
                        setTimeout(() => {
                            $('#message_success').text('');
                        }, 3000);
                    }
                    else{
                        $('#message_error').text(res.msg);
                        setTimeout(() => {
                            $('#message_error').text('');
                        }, 3000);
                    }
                }
            });

        });
    });

    function timer()
    {
        var seconds = 60;
        var minutes = 0;

        var timer = setInterval(() => {

            if(minutes < 0){
                $('.time').text('');
                $('#resendOtpVerification').css('opacity', '1');
                clearInterval(timer);
            }
            else{
                let tempMinutes = minutes.toString().length > 1? minutes:'0'+minutes;
                let tempSeconds = seconds.toString().length > 1? seconds:'0'+seconds;
                $('#resendOtpVerification').css('opacity', '0.5');
                $('.time').text(tempMinutes+':'+tempSeconds);
            }

            if(seconds <= 0){
                minutes--;
                seconds = 59;
            }

            seconds--;

        }, 1000);
    }

    timer();
</script>
</body>
</html>
