@extends(get_extends('layouts.master'))
@section('sub_header')
@include(get_extends('knowledgebase.search_form'))
@endsection
@section('content')
<div class="container padding_80">
    @if($kb_template == 'template1')
    <div class="row">
        @foreach ($categories as $cate)
        <div class="{{$kb_column}} col-12">
            <div class="topics-list">
                <h5><a href="{{url('kbc/'.$cate->slug)}}">{{$cate->name}} <span class="badge">{{$cate->posts_count}}</span></a></h5>
                <ul>
                    @foreach (get_posts(['cid' => $cate->id, 'type' => 'knowledgebase', 'limit' => $kb_post_per_page]) as $item)
                    <li><a href="{{url('kb/'.$item->post_name)}}"><i class="pe-7s-note2"></i> {{$item->post_title}}</a></li>
                    @endforeach
                </ul>
                <a href="{{url('kbc/'.$cate->slug)}}" class="readmore">{{lang('read_more')}} <i class="fas fa-angle-right"></i></a>
            </div>
        </div>
        @endforeach
    </div>
    @elseif($kb_template == 'template2')
    <div class="row feature-box-full">
        @foreach ($categories as $cate)
        <div class="{{$kb_column}} col-12">
            <div class="item-box">
                <div class="icon"><img src="{{get_attachment_url($cate->image)}}" alt="{{$cate->name}}"></div>
                <h3>{{$cate->name}}</h3>
                <p>{{$cate->description}}</p>
                <a href="{{url('kbc/'.$cate->slug)}}" class="button-more">{{lang('read_more')}}</a>
            </div>
        </div>
        @endforeach
    </div>
    @elseif($kb_template == 'template3')
    <div class="row">
        @foreach ($categories as $cate)
        <div class="{{$kb_column}} col-12">
            <div class="feature-box">
                <div class="icon"><img src="{{get_attachment_url($cate->image)}}" alt="{{$cate->name}}"></div>
                <h3>{{$cate->name}}</h3>
                <p>{{$cate->description}}</p>
                <a href="{{url('kbc/'.$cate->slug)}}" class="button-more">{{lang('read_more')}}</a>
            </div>
        </div>
        @endforeach
    </div>
    @endif
</div>
@endsection