@extends(get_extends('layouts.master'))
@section('content')
@if(get_option_inarray('contact', 'mapstatus'))
<div class="contact-iframe">
    <iframe height="480" src="{{get_option_inarray('contact', 'mapurl')}}"></iframe>
</div>
@endif
<div class="container padding_80">
    <div class="row">
        <div class="col-lg-8 col-md-7 col-sm-12">
            @if(get_option_inarray('contact', 'contactform_title'))<div class="head-title"><h4>{{get_option_inarray('contact', 'contactform_title')}}</h4></div>@endif
            <div class="contact-form">
                @if(get_option_inarray('contact', 'contactform_subtitle'))<p>{{get_option_inarray('contact', 'contactform_subtitle')}}</p>@endif
                @if(session()->has('success'))<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{!! session()->get('success') !!}</div>@endif
                <form action="{{url('sendcontact')}}" method="post" class="contactForm">
                    {{ csrf_field() }}
                    <div class="row">
                        <div class="form-group col-md-6">
                            <div class="frm-input frm-icon">
                                <i class="lnr lnr-user"></i>
                                <input type="text" name="username" class="form-control" placeholder="{{lang('username')}}" value="{{old('username')}}" autocomplete="off">
                            </div>
                            @if($errors->has('username'))<div class="validation">{{ $errors->first('username') }}</div>@endif
                        </div>
                        <div class="form-group col-md-6">
                            <div class="frm-input frm-icon">
                                <i class="lnr lnr-envelope"></i>
                                <input type="email" class="form-control" name="email" placeholder="{{lang('email')}}" value="{{old('email')}}" autocomplete="off">
                            </div>
                            @if($errors->has('email'))<div class="validation">{{ $errors->first('email') }}</div>@endif
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="frm-input frm-icon">
                            <i class="fas fa-tag"></i>
                            <input type="text" class="form-control" name="subject" id="subject" placeholder="{{lang('subject')}}" value="{{old('subject')}}" maxlength="150">
                        </div>
                        @if($errors->has('subject'))<div class="validation">{{ $errors->first('subject') }}</div>@endif
                    </div>
                    <div class="form-group">
                        <textarea class="form-control" name="message" placeholder="{{lang('message')}}">{{old('message')}}</textarea>
                        @if($errors->has('message'))<div class="validation">{{ $errors->first('message') }}</div>@endif
                    </div>
                    @if(get_option_inarray('apikeys_options', 'captcha_status'))
                        <div class="form-group">
                            <div class="g-recaptcha" data-sitekey="{{get_option_inarray('apikeys_options', 'recaptcha_key')}}"></div>
                            @if($errors->has('g-recaptcha-response'))<div class="validation">{{ $errors->first('g-recaptcha-response') }}</div>@endif
                        </div>
                    @endif
                    <button type="submit" class="button btn-block"><span>{{lang('send_message')}}</span></button>
                </form>
            </div>
        </div>
        <div class="col-lg-4 col-md-5 col-sm-12 sidebar">
            @if(get_option_inarray('contact', 'information_title'))<div class="head-title"><h4>{{get_option_inarray('contact', 'information_title')}}</h4></div>@endif
            <div class="contact-information">
                @if(get_option_inarray('contact', 'information_subtitle'))<p>{{get_option_inarray('contact', 'information_subtitle')}}</p>@endif
                <ul>
                    @if(get_option_inarray('contact', 'address'))<li><i class="pe-7s-map-marker"></i> <span>{{get_option_inarray('contact', 'address')}}</span></li>@endif
                    @if(get_option_inarray('contact', 'phone'))<li><i class="pe-7s-call"></i> <span>{{get_option_inarray('contact', 'phone')}}</span></li>@endif
                    @if(get_option_inarray('contact', 'phone2'))<li><i class="pe-7s-phone"></i> <span>{{get_option_inarray('contact', 'phone2')}}</span></li>@endif
                    @if(get_option_inarray('contact', 'email'))<li><i class="pe-7s-mail"></i> <span>{{get_option_inarray('contact', 'email')}}</span></li>@endif
                    @if(get_option_inarray('contact', 'email2'))<li><i class="pe-7s-mail"></i> <span>{{get_option_inarray('contact', 'email2')}}</span></li>@endif
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
@if($errors->any() or session()->has('success'))
<script>$('html').animate({scrollTop: $('.contact-form').offset().top - 80}, 500);</script>
@endif
@if(get_option_inarray('apikeys_options', 'captcha_status'))
@if(site_config('language') == 'ar')
<script src="https://www.google.com/recaptcha/api.js?hl=ar"></script>
@else
<script src="https://www.google.com/recaptcha/api.js"></script>
@endif
@endif
@endpush