<style>
    .control-label:after {
        content: "*";
        color: red;
    }

    .no-after::after {
        content: none;
    }
</style>

<?php $__env->startSection('content'); ?>
    <div class="page-title-box d-flex align-items-center justify-content-between">
        <h4 class="mb-0 font-size-18"><?php echo e($data['page_title']); ?></h4>
        <div class="page-title-right">
            <ol class="breadcrumb m-0">
                <li class="breadcrumb-item"><a href="<?php echo e(get_admin_url('/')); ?>"><?php echo e(admin_lang('dashboard')); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e($data['page_title']); ?></li>
            </ol>
        </div>
    </div>
    <?php if($data['driver']->CARD_NUM && $data['status'] == 'ACTIVE'): ?>
        <form method="POST" action="<?php echo e(get_admin_url('storeLoadFunds')); ?>" class="form-horizontal"
            enctype="multipart/form-data">
            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="driver_id" value="<?php echo e($data['driver']->SMART_DRIVERID); ?>">
            <div class="row">

                <div class="col-md-3">
                    <div class="form-group">
                        <label class="control-label">Amount</label><br>
                        <input type="number" step="0.01" name="amount" id="amount" class="form-control col-md-6"
                            placeholder="Amount" value="<?php echo e(old('amount')); ?>" required>
                        <?php if($errors->has('amount')): ?>
                            <span class="text-danger"><?php echo e($errors->first('amount')); ?></span>
                        <?php endif; ?>
                        <?php if(session()->has('error')): ?>
                            <span class="text-danger"><?php echo e(session()->get('error')); ?></span>
                            <?php
                                session()->forget('error');
                            ?>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label class="control-label">Issue To</label><br>
                        <input type="hidden" name="issue_to" id="issue_to" cLass="form-control col-md-6"
                            placeholder="Issue To"
                            value="<?php echo e(old('issue_to', $data['driver']->FIRST_NAME . '_' . $data['driver']->LAST_NAME)); ?>">
                        <div class="mt-1"><?php echo e($data['driver']->FIRST_NAME . '_' . $data['driver']->LAST_NAME); ?></div>
                        <?php if($errors->has('issue_to')): ?>
                            <span class="text-danger"><?php echo e($errors->first('issue_to')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label class="control-label no-after">Notes</label><br>
                        <input type="text" name="notes" id="notes" cLass="form-control col-md-6"
                            placeholder="Notes" value="<?php echo e(old('notes', '')); ?>">
                        <?php if($errors->has('notes')): ?>
                            <span class="text-danger"><?php echo e($errors->first('notes')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>

            </div>

            <div class="form-group mt-2">
                <button type="submit" class="btn btn-primary"><span></span>Add</button>
                <a href="<?php echo e(get_admin_url('driver')); ?>" class="btn btn-danger"><span></span>Cancel</a>
            </div>
        </form>
    <?php else: ?>
        <div class="form-group mt-2">
            <p style="color: red">
                <?php echo e(substr($data['driver']->CARD_NUM, 0, 6)); ?>******<?php echo e(substr($data['driver']->CARD_NUM, -4)); ?> Is
                Currently InActive</p>
            <a href="<?php echo e(route('addLoadFunds', $data['driver']->SMART_DRIVERID)); ?>"
                class="btn btn-primary"><span></span>Retry</a>
        </div>
    <?php endif; ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tmstmdashboard/master.tmdashboard.com/backoffice/resources/views/dashboard/driver/add_load_funds.blade.php ENDPATH**/ ?>