<?php $__env->startSection('content'); ?>
    <style>
        .control-label:after {
            content: "*";
            color: red;
        }
    </style>
    <?php if($mode): ?>
        <div class="page-title-box d-flex align-items-center justify-content-between">
            <h4 class="mb-0 font-size-18"><?php echo e($data['page_title']); ?></h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(get_admin_url('/')); ?>"><?php echo e(admin_lang('dashboard')); ?></a></li>
                    <li class="breadcrumb-item active"> <a
                            href="<?php echo e(get_admin_url('property')); ?>"><?php echo e($data['page_title']); ?></a></li>
                </ol>
            </div>
        </div>
        <form id="frmUpdate" method="POST" action="<?php echo e(get_admin_url('driverCardDetails')); ?>" class="form-horizontal"
            enctype="multipart/form-data">
            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="id" value="<?php echo e($driver->SMART_DRIVERID); ?>">

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-body">
                            <div class="account_info row">
                                <div class="account_info-group col-md-6"><label><?php echo e(admin_lang('first_name')); ?>:</label>
                                    <?php echo e($driver->FIRST_NAME); ?></div>
                                <div class="account_info-group col-md-6"><label><?php echo e(admin_lang('last_name')); ?>:</label>
                                    <?php echo e($driver->LAST_NAME); ?></div>
                                <div class="account_info-group col-md-6"><label><?php echo e(admin_lang('username')); ?>:</label>
                                    <?php echo e($driver->USERNAME); ?></div>
                                <div class="account_info-group col-md-6"><label><?php echo e(admin_lang('email')); ?>:</label>
                                    <?php echo e($driver->DRIVER_EMAIL); ?></div>
                                <div class="account_info-group col-md-6"><label><?php echo e(admin_lang('phone')); ?>:</label>
                                    <?php echo e($driver->DRIVER_PHONE); ?></div>

                                <div class="account_info-group col-md-6"><label><?php echo e(admin_lang('address')); ?>:</label>
                                    <?php echo e($driver->ADDRESS); ?></div>
                                <div class="account_info-group col-md-6"><label><?php echo e(admin_lang('city')); ?>:</label>
                                    <?php echo e($driver->CITY); ?></div>
                                <div class="account_info-group col-md-6"><label><?php echo e(admin_lang('state')); ?>:</label>
                                    <?php echo e($driver->STATE); ?></div>
                                <div class="account_info-group col-md-6"><label><?php echo e(admin_lang('postalcode')); ?>:</label>
                                    <?php echo e($driver->POSTAL); ?></div>
                                <div class="account_info-group col-md-6"><label><?php echo e(admin_lang('DOB')); ?>:</label>
                                    <?php echo e($driver->DOB != '' ? date('m/d/Y', strtotime($driver->DOB)) : ''); ?></div>
                                <div class="account_info-group col-md-6
                            ">
                                    <label><?php echo e(admin_lang('SSN')); ?>:</label> <?php echo e($driver->SSN_NUM); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label class="control-label">Card No</label><br>
                        <input type="number" name="CARD_NUM" id="CARD_NUM"
                            value="<?php echo e(old('CARD_NUM', $driver->CARD_NUM)); ?>" cLass="form-control col-md-6">
                        <?php if($errors->has('CARD_NUM')): ?>
                            <span class="text-danger"><?php echo e($errors->first('CARD_NUM')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-md-1">
                    <div class="form-group">
                        <label class="control-label">CSV</label><br>
                        <input type="text" name="CSV_NUM" id="CSV_NUM" value="<?php echo e(old('CSV_NUM', $driver->CSV_NUM)); ?>"
                            cLass="form-control col-md-6">
                        <div><span class="hint">XXX(check back of your card)</span></div>
                        <?php if($errors->has('CSV_NUM')): ?>
                            <span class="text-danger"><?php echo e($errors->first('CSV_NUM')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-md-1">
                    <div class="form-group">
                        <label class="control-label">Expires</label><br>
                        <input type="text" name="EXPIRES" id="EXPIRES" value="<?php echo e(old('EXPIRES', $driver->EXPIRES)); ?>"
                            cLass="form-control col-md-6" placeholder="MM/YY">
                        <div><span class="hint">MM/YY</span></div>
                        <?php if($errors->has('EXPIRES')): ?>
                            <span class="text-danger"><?php echo e($errors->first('EXPIRES')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="form-group mt-2">
                <button type="submit" class="btn btn-primary">Update</button>
                <a href="<?php echo e(get_admin_url('driver')); ?>" class="btn btn-danger">Cancel</a>
            </div>
        </form>
    <?php else: ?>
        <div class="page-title-box d-flex align-items-center justify-content-between">
            <h4 class="mb-0 font-size-18"><?php echo e(admin_lang('profile')); ?> :: <?php echo e($data['username']); ?></h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(get_admin_url('/')); ?>"><?php echo e(admin_lang('dashboard')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('driver')); ?>">Driver</a></li>
                    <li class="breadcrumb-item active"><?php echo e($data['username']); ?></li>
                </ol>
            </div>
        </div>
        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close"
                    data-bs-dismiss="alert" aria-label="Close"></button><?php echo e(session()->get('success')); ?></div>
            <?php session()->forget('success');?>
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show"><button type="button" class="btn-close"
                    data-bs-dismiss="alert" aria-label="Close"></button><?php echo e(session()->get('error')); ?></div>
            <?php session()->forget('error');?>
        <?php endif; ?>
        <div class="row">
            <div class="col-xl-4">
                <div class="card overflow-hidden">
                    <div class="bg-soft-primary bg-soft-usercover"
                        style="background-image: url(<?php echo e(get_user_cover($data['userid'])); ?>)">
                        <div class="row">
                            <div class="col-12">
                                <div class="text-primary p-3">
                                    <h5 class="text-primary">
                                        <?php echo e($data['driver']->FIRST_NAME . ' ' . $data['driver']->LAST_NAME); ?>

                                    </h5>
                                    <p><?php echo e($data['email']); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="avatar-md profile-user-wid mb-4">
                                    <img src="<?php echo e(get_user_avatar($data['userid'])); ?>" alt=""
                                        class="img-thumbnail rounded-circle">
                                </div>
                                <h5 class="font-size-15 text-truncate">
                                    <?php if(!empty($data['driver']->CARD_NUM)): ?>
                                        Card # :
                                        <?php if(Auth::user()->userlevel == 'admin'): ?>
                                            <?php echo e($data['driver']->CARD_NUM); ?>

                                        <?php else: ?>
                                            <?php echo e(substr($data['driver']->CARD_NUM, 0, 6)); ?>******<?php echo e(substr($data['driver']->CARD_NUM, -4)); ?>

                                        <?php endif; ?>
                                        <p class="mt-1 mb-0">
                                            PIN : <span><?php echo e($data['driver']->CARD_PIN); ?></span>
                                        </p>
                                        <p class="mt-1">
                                            Cash Available :
                                            <span id="get_cashavailable">

                                            </span>

                                            <span class='loader' style='display: none;'>
                                                <i class="fas fa-spinner fa-spin"></i>
                                            </span>
                                        </p>
                                        <?php if($data['driver']->STATUS == '1'): ?>
                                            <a href="<?php echo e(route('addLoadFunds', $data['driver']->SMART_DRIVERID)); ?>"
                                                class="btn btn-primary">load Cash</a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <div class="account_info">
                            <div class="account_info-group"><label><?php echo e(admin_lang('username')); ?>:</label>
                                <?php echo e($data['username']); ?></div>
                            <div class="account_info-group"><label>User/Email:</label> <a
                                    href="mailto:<?php echo e($data['email']); ?>"><?php echo e($data['email']); ?></a></div>
                            <div class="account_info-group"><label><?php echo e(admin_lang('created')); ?>:</label>
                                <?php echo e(date('m/d/Y', strtotime($data['user']->created_at))); ?></div>
                            <div class="account_info-group"><label><?php echo e(admin_lang('updated')); ?>:</label>
                                <?php echo e(date('m/d/Y', strtotime($data['user']->updated_at))); ?></div>
                            <div class="account_info-group"><label><?php echo e(admin_lang('last_seen')); ?>:</label>
                                <?php if($data['signintime']): ?>
                                    <?php echo e(date('m/d/Y', $data['signintime'])); ?><?php else: ?><?php echo e(admin_lang('none')); ?>

                                <?php endif; ?>
                            </div>
                            <div class="account_info-group"><label>Card Status: </label>
                                <span class='loader' style='display: none;'>
                                    <i class="fas fa-spinner fa-spin"></i>
                                </span>

                                <span id="card_status">

                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close"
                    data-bs-dismiss="alert" aria-label="Close"></button><?php echo session()->get('success'); ?></div>
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <?php app('eventy')->action('admin_user_profile_before_container'); ?>
        <div class="tacf-box-container">
            <div class="tacf-box-tabs nav-tabs-cookie" data-cookie="profile_user" data-cookie-tab="tab-details">
                <a href="#" class="active" data-tab=".tab-edit"><i class="bx bx-pencil"></i>
                    User Login</a>
                <a href="#" class="" data-tab=".tab-card"><i class="bx bx-card"></i>
                    <?php echo e(admin_lang('card')); ?></a>
                <a href="#" class="" data-tab=".tab-liveSmartDriverData" id="liveSmartDriverData"><i
                        class="bx bx-card"></i>Live
                    Smart Driver
                    Data</a>
                <a href="#" class="" data-tab=".tab-personalData"><i class="bx bx-card"></i>Personal
                    Data</a>
                <a href="#" class="" data-tab=".tab-cardInfo"><i class="bx bx-card"></i>Card Info</a>
                <a href="#" class="" data-tab=".tab-loadHistory"><i class="bx bx-card"></i>Load History</a>
                <a href="#" class="" data-tab=".tab-details"><i class="bx bx-file"></i>
                    <?php echo e(admin_lang('details')); ?></a>
                <?php app('eventy')->action('admin_user_profile_tabs', $data['user']); ?>
            </div>
            <div class="tacf-tabs-content">
                <div class="tacf-tab-content tab-details p-0 ">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item"><strong><?php echo e(admin_lang('id')); ?>:</strong> <?php echo e($data['user']->id); ?></li>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('first_name')); ?>:</strong>
                            <?php echo e($data['driver']->FIRST_NAME); ?></li>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('last_name')); ?>:</strong>
                            <?php echo e($data['driver']->LAST_NAME); ?></li>
                        <li class="list-group-item"><strong>Two Factor Auth:</strong>
                            <?php echo e($data['driver']->two_factor == 1 ? 'YES' : 'NO'); ?></li>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('username')); ?>:</strong>
                            <?php echo e($data['user']->username); ?></li>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('email')); ?>:</strong> <a
                                href="mailto:<?php echo e($data['user']->email); ?>"><?php echo e($data['user']->email); ?></a></li>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('role')); ?>:</strong>
                            <?php if($data['user']->userlevel == 'admin'): ?>
                                <span
                                class="badge badge-pill bg-danger"><?php echo e(admin_lang('userlevel_' . $data['user']->userlevel)); ?></span><?php else: ?><span
                                    class="badge badge-pill bg-info"><?php echo e(admin_lang('userlevel_' . $data['user']->userlevel)); ?></span>
                            <?php endif; ?>
                        </li>
                        <?php app('eventy')->action('admin_user_profile_details', $data['user']); ?>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('created')); ?>:</strong>
                            <?php echo e(date('m/d/Y', strtotime($data['user']->created_at))); ?></li>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('updated')); ?>:</strong>
                            <?php echo e(date('m/d/Y', strtotime($data['user']->updated_at))); ?></li>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('last_seen')); ?>:</strong>
                            <?php if($data['signintime']): ?>
                                <?php echo e(date('m/d/Y', $data['signintime'])); ?><?php else: ?><?php echo e(admin_lang('none')); ?>

                            <?php endif; ?>
                        </li>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('ip')); ?>:</strong> <a
                                href="<?php echo e(get_admin_url('users/platform/' . $data['details']['ip'])); ?>"><?php echo e($data['details']['ip']); ?></a>
                        </li>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('useragent')); ?>:</strong>
                            <?php echo e($data['details']['useragent']); ?></li>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('platformname')); ?>:</strong> <a
                                href="<?php echo e(get_admin_url('users/platform/' . $data['details']['platformname'])); ?>"><?php echo e($data['details']['platformname']); ?></a>
                        </li>
                        <li class="list-group-item"><strong><?php echo e(admin_lang('browserfamily')); ?>:</strong> <a
                                href="<?php echo e(get_admin_url('users/browser/' . $data['details']['browserfamily'])); ?>"><?php echo e($data['details']['browserfamily']); ?></a>
                        </li>
                    </ul>
                </div>

                <div class="tacf-tab-content tab-edit active">
                    <form method="POST" action="<?php echo e(get_admin_url('driverActions')); ?>" class="form-horizontal"
                        enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden" name="action" value="<?php echo e($data['action']); ?>">
                        <input type="hidden" name="userid" value="<?php echo e($data['userid']); ?>">
                        <div class="row">
                            <div class="col-md-12">
                                <?php app('eventy')->action('admin_user_form_before', $data['userid']); ?>
                                <h4 class="card-title"><i class="bx bx-id-card"></i> <?php echo e(admin_lang('personal_data')); ?>

                                </h4>
                                <hr />
                                <div class="row">

                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="email">User/Email</label>
                                            <div class="frm-input">
                                                <input class="form-control" name="email" type="email" id="email"
                                                    value="<?php if(old('email')): ?> <?php echo e(old('email')); ?><?php else: ?><?php echo e($data['email']); ?> <?php endif; ?>"
                                                    placeholder="<?php echo e(admin_lang('email')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label>Two Factor</label>
                                            <div>
                                                <input type="checkbox" name="two_factor" value="1"
                                                    class="custom-control-input" switch="bool" id="status_switch"
                                                    <?php if($data['user']->two_factor == 1): ?> checked <?php endif; ?>>
                                                <label for="status_switch" data-on-label="YES"
                                                    data-off-label="NO"></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php app('eventy')->action('admin_user_form_personal_data', $data['userid']); ?>
                                <h4 class="card-title"><i class="bx bx-lock-alt"></i> <?php echo e(admin_lang('password')); ?>

                                    <small><?php echo e(admin_lang('leave_field_change')); ?></small>
                                </h4>
                                <hr />
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="password"><?php echo e(admin_lang('password')); ?></label>
                                            <div class="input-group">
                                                <input class="form-control" name="password" type="text"
                                                    id="password"
                                                    value="<?php echo e(old('password', $data['driver']->PASSWORD)); ?>"
                                                    placeholder="<?php echo e(admin_lang('password')); ?>">
                                                <span class="input-group-text"><i class="bx bx-lock"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="confirm_password"><?php echo e(admin_lang('confirm_password')); ?></label>
                                            <div class="input-group">
                                                <input class="form-control" name="password_confirmation" type="text"
                                                    id="confirm_password"
                                                    value="<?php echo e(old('password_confirmation', $data['driver']->PASSWORD)); ?>"
                                                    placeholder="<?php echo e(admin_lang('confirm_password')); ?>">
                                                <span class="input-group-text"><i class="bx bx-lock"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="pin_number"><?php echo e(admin_lang('pincode')); ?>

                                                <small><?php echo e(admin_lang('admin_only')); ?></small></label>
                                            <div class="input-group">
                                                <input class="form-control" name="pin_number" type="text"
                                                    id="pin_number"
                                                    value="<?php echo e(old('pin_number', $data['driver']->pin_number)); ?>"
                                                    placeholder="<?php echo e(admin_lang('pincode')); ?>">
                                                <span class="input-group-text"><i class="bx bx-dialpad"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php app('eventy')->action('admin_user_form_password_data', $data['userid']); ?>

                                <?php app('eventy')->action('admin_user_form_after', $data['userid']); ?>
                            </div>
                        </div>
                        <hr />
                        <div class="form-group mb-0">
                            <button type="submit" class="btn btn-primary"><span></span>
                                <?php if($data['action'] == 'update'): ?>
                                    <?php echo e(admin_lang('update')); ?>

                                <?php else: ?>
                                    <?php echo e(admin_lang('add_new')); ?>

                                <?php endif; ?>
                            </button>
                        </div>
                    </form>
                </div>

                <div class="tacf-tab-content tab-card">
                    <form method="POST" action="<?php echo e(get_admin_url('driver_card_pin')); ?>" class="form-horizontal"
                        enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden" name="action" value="setcardpin">
                        <input type="hidden" name="userid" value="<?php echo e($data['userid']); ?>">
                        <input type="hidden" name="driverid" value="<?php echo e($data['driver']->SMART_DRIVERID); ?>">
                        <div class="row">
                            <div class="col-md-12">
                                <?php app('eventy')->action('admin_user_form_before', $data['userid']); ?>
                                <h4 class="card-title"><i class="bx bx-id-card"></i> <?php echo e(admin_lang('card_data')); ?></h4>
                                <hr />


                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="username"><?php echo e(admin_lang('CARD_NUM')); ?></label>
                                            <div class="frm-input">
                                                <?php if(Auth::user()->userlevel == 'admin'): ?>
                                                    <?php echo e($data['driver']->CARD_NUM); ?>

                                                <?php else: ?>
                                                    <?php if(!empty($data['driver']->CARD_NUM)): ?>
                                                        <?php echo e(substr($data['driver']->CARD_NUM, 0, 6)); ?>******<?php echo e(substr($data['driver']->CARD_NUM, -4)); ?>

                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="username"><?php echo e(admin_lang('CSV_NUM')); ?></label>
                                            <div class="frm-input">
                                                <?php echo e($data['driver']->CSV_NUM); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group mb-4">
                                            <label for="username"><?php echo e(admin_lang('EXPIRES')); ?></label>
                                            <div class="frm-input">
                                                <?php echo e($data['driver']->EXPIRES); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label">Status</label>
                                            <span class='loader' style='display: none;'>
                                                <i class="fas fa-spinner fa-spin"></i>
                                            </span>
                                            <br>
                                            <input type="radio" value="1" name="STATUS" id="active">
                                            <label for="active">Active</label>
                                            <input type="radio" value="0" name="STATUS" id="inactive"> <label
                                                for="inactive">InActive</label>
                                            <?php if($errors->has('STATUS')): ?>
                                                <span class="text-danger"><?php echo e($errors->first('STATUS')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div><span class="hint">Active/Dective Status will Active/Dective CARD #</span>
                                        </div>
                                    </div>


                                    <div class="col-md-1">
                                        <div class="form-group mb-4">
                                            <label for="CARD_PIN"><?php echo e(admin_lang('CARD_PIN')); ?></label>
                                            <div class="frm-input">
                                                <input class="form-control" name="CARD_PIN" type="text"
                                                    id="CARD_PIN"
                                                    value="<?php if(old('CARD_PIN')): ?> <?php echo e(old('CARD_PIN')); ?><?php else: ?><?php echo e($data['driver']->CARD_PIN); ?> <?php endif; ?>"
                                                    placeholder="<?php echo e(admin_lang('CARD_PIN')); ?>" required>
                                                <?php if($errors->has('CARD_PIN')): ?>
                                                    <span class="text-danger"><?php echo e($errors->first('CARD_PIN')); ?></span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php app('eventy')->action('admin_user_form_personal_data', $data['userid']); ?>
                            </div>
                        </div>
                        <hr />
                        <div class="form-group mb-0">
                            <button type="submit" class="btn btn-primary"><span></span>
                                <?php if($data['action'] == 'update'): ?>
                                    <?php echo e(admin_lang('set_pin')); ?>

                                <?php else: ?>
                                    <?php echo e(admin_lang('add_new')); ?>

                                <?php endif; ?>
                            </button>
                        </div>

                    </form>
                </div>

                <div class="tacf-tab-content tab-liveSmartDriverData">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item"><strong>Address : </strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_Address"></span>
                        </li>
                        <li class="list-group-item"><strong>City : </strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_City"></span>
                        </li>
                        <li class="list-group-item"><strong>State :</strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_State"></span>
                        </li>
                        <li class="list-group-item"><strong>Postal Code :</strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_Postal"></span>
                        </li>
                        <li class="list-group-item"><strong>Country : </strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_Country"></span>
                        </li>
                        <li class="list-group-item"><strong>DOB : </strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_DOB"></span>
                        </li>
                        <li class="list-group-item"><strong>Social Security No. :</strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_Last4ss"></span>
                        </li>
                        <li class="list-group-item"><strong>Phone :</strong>
                            <span class='loader1' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="live_Phone"></span>
                        </li>
                    </ul>
                </div>

                <div class="tacf-tab-content tab-personalData">
                    <form method="POST" action="<?php echo e(get_admin_url('driver_personal_data')); ?>" class="form-horizontal"
                        enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden" name="action" value="<?php echo e($data['action']); ?>">
                        <input type="hidden" name="userid" value="<?php echo e($data['userid']); ?>">
                        <input type="hidden" name="driverid" value="<?php echo e($data['driver']->SMART_DRIVERID); ?>">
                        <div class="row">

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Address</label><br>
                                    <input type="text" name="ADDRESS" id="ADDRESS"
                                        value="<?php echo e(old('ADDRESS', $data['driver']->ADDRESS)); ?>"
                                        cLass="form-control col-md-6" required>
                                    <?php if($errors->has('ADDRESS')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('ADDRESS')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">City</label><br>
                                    <input type="text" name="CITY" id="CITY" cLass="form-control col-md-6"
                                        value="<?php echo e(old('CITY', $data['driver']->CITY)); ?>" required>
                                    <?php if($errors->has('CITY')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('CITY')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">State</label><br>
                                    <?php $state = ['AL', 'AK', 'AZ', 'AR', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 'ID', 'IL', 'IN', 'IA', 'KS', 'KY', 'LA', 'ME', 'MD', 'MA', 'MI', 'MN', 'MS', 'MO', 'MT', 'NE', 'NV', 'NH', 'NJ', 'NM', 'NY', 'NC', 'ND', 'OH', 'OK', 'OR', 'PA', 'RI', 'SC', 'SD', 'TN', 'TX', 'UT', 'VT', 'VA', 'WA', 'WV', 'WI', 'WY']; ?>
                                    <select name="STATE" id="STATE"
                                        class="form-control custom-select form-select custom-select-sm form-control form-control-sm"
                                        required>
                                        <?php $__currentLoopData = $state; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                value="<?php echo e($item); ?>"<?php echo e($item == $data['driver']->STATE ? 'selected' : ''); ?>>
                                                <?php echo e($item); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php if($errors->has('STATE')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('STATE')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Postal Code</label><br>
                                    <input type="text" name="POSTAL" id="POSTAL" cLass="form-control col-md-6"
                                        value="<?php echo e(old('POSTAL', $data['driver']->POSTAL)); ?>" required>
                                    <?php if($errors->has('POSTAL')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('POSTAL')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Country</label><br>
                                    <input type="text" name="COUNTRY" id="COUNTRY" cLass="form-control col-md-6"
                                        value="<?php echo e(old('COUNTRY', $data['driver']->COUNTRY)); ?>" required>
                                    <?php if($errors->has('COUNTRY')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('COUNTRY')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Dob</label><br>
                                    <input type="date" name="DOB" id="DOB" cLass="form-control col-md-6"
                                        value="<?php echo e(old('DOB', $data['driver']->DOB != '' ? date('Y-m-d', strtotime($data['driver']->DOB)) : '')); ?>"
                                        required>
                                    <?php if($errors->has('DOB')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('DOB')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Social Security No.</label><br>
                                    <input type="text" name="SSN_NUM" id="SSN_NUM"
                                        cLass="form-control col-md-6 SSN_NUM"
                                        value="<?php echo e(old('SSN_NUM', $data['driver']->SSN_NUM)); ?>" required>
                                    <?php if($errors->has('SSN_NUM')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('SSN_NUM')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Phone</label><br>
                                    <input type="text" name="DRIVER_PHONE" id="DRIVER_PHONE"
                                        cLass="form-control col-md-6 DRIVER_PHONE"
                                        value="<?php echo e(old('DRIVER_PHONE', $data['driver']->DRIVER_PHONE)); ?>" required>
                                    <?php if($errors->has('DRIVER_PHONE')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('DRIVER_PHONE')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Sub Status</label><br>
                                    <select name="SUB_STATUS" id="SUB_STATUS"
                                        class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
                                        <option value="New Card Order"
                                            <?php echo e($data['driver']->SUB_STATUS == 'New Card Order' ? 'selected' : ''); ?>>
                                            New
                                            Card
                                            Order</option>
                                        <option value="Processed"
                                            <?php echo e($data['driver']->SUB_STATUS == 'Processed' ? 'selected' : ''); ?>>
                                            Processed
                                        </option>
                                        <option value="Active"
                                            <?php echo e($data['driver']->SUB_STATUS == 'Active' ? 'selected' : ''); ?>>Active
                                        </option>
                                        <option value="Inactive"
                                            <?php echo e($data['driver']->SUB_STATUS == 'Inactive' ? 'selected' : ''); ?>>Inactive
                                        </option>
                                    </select>
                                    <?php if($errors->has('SUB_STATUS')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('SUB_STATUS')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                        </div>
                        <div class="col-md-3">
                            <div class="form-group mt-2">
                                <button type="submit" class="btn btn-primary">Update</button>
                                <button type="button" id="set_default_data" class="btn btn-primary">Set Default
                                    Data</button>
                            </div>
                        </div>


                    </form>
                </div>

                <div class="tacf-tab-content tab-cardInfo">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item"><strong>Status : </strong>
                            <span class='loader' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="card_info_status"></span>
                        </li>
                        <li class="list-group-item"><strong>Card Number : </strong>
                            <span class='loader' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="card_info_card_no"></span>
                        </li>
                        <li class="list-group-item"><strong>Last Transaction # :</strong>
                            <span class='loader' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="card_info_last_tr"></span>
                        </li>
                        <li class="list-group-item"><strong>Last Transaction Date :</strong>
                            <span class='loader' style='display: none;'>
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                            <span id="card_info_last_tr_date"></span>
                        </li>
                    </ul>
                </div>

                <div class="tacf-tab-content tab-loadHistory">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-sm-flex flex-wrap">
                                <h4 class="card-title">Load History</h4>
                            </div>
                            <table id="jq-table" class="table table-striped table-bordered drivertable mt-4">
                                <thead>
                                    <tr>
                                        <th>Driver Name</th>
                                        <th>Amount</th>
                                        <th>Issue To</th>
                                        <th>Notes</th>
                                        <th>Ref ID</th>
                                        <th>Created Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $data['driver_fund']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <?php echo e($driver->drivers->USERNAME); ?>

                                            </td>
                                            <td>
                                                $ <?php echo e(number_format($driver->amount, 2)); ?>

                                            </td>
                                            <td>
                                                <?php echo e($driver->issue_to); ?>

                                            </td>
                                            <td>
                                                <?php echo e($driver->notes); ?>

                                            </td>
                                            <td>
                                                <?php echo e($driver->ref_id); ?>

                                            </td>
                                            <td>
                                                <?php echo e(date('m-d-Y', strtotime($driver->created_at))); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <?php app('eventy')->action('admin_user_profile_tabs_content', $data['user']); ?>
            </div>
        </div>
        <?php app('eventy')->action('admin_user_profile_after_container', $data['user']); ?>
    <?php endif; ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('style_files'); ?>
    <link href="<?php echo e(asset('libs/tacf/tacf.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('libs/multiselect/css/multiselect.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script_files'); ?>
    <script src="<?php echo e(asset('libs/tacf/tacf.min.js')); ?>"></script>
    <script src="<?php echo e(asset('libs/multiselect/js/jquery.multiselect.js')); ?>"></script>
    <script src="<?php echo e(asset('dashboard/js/custom-file-input.min.js')); ?>"></script>
    <script type="text/javascript">
        bsCustomFileInput.init();
        $(function() {
            $('#permission').multiSelect();
        });
    </script>
    <script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyD5BQa0hFcyKzBa_dA2cbKt3QvdiWhxOvY&libraries&callback=initAutocomplete&libraries=places&v=weekly"
        defer></script>

    <script>
        // This sample uses the Places Autocomplete widget to:
        // 1. Help the user select a place
        // 2. Retrieve the address components associated with that place
        // 3. Populate the form fields with those address components.
        // This sample requires the Places library, Maps JavaScript API.
        // Include the libraries=places parameter when you first load the API.
        // For example: <script
        // src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places">
        let autocomplete;
        let address1Field;
        let address2Field;
        let postalField;

        function initAutocomplete() {
            address1Field = document.querySelector("#ADDRESS");
            postalField = document.querySelector("#POSTAL");
            // Create the autocomplete object, restricting the search predictions to
            // addresses in the US and Canada.
            autocomplete = new google.maps.places.Autocomplete(address1Field, {
                componentRestrictions: {
                    country: ["us"]
                },
                fields: ["address_components", "geometry"],
                types: ["address"],
            });
            address1Field.focus();
            // When the user selects an address from the drop-down, populate the
            // address fields in the form.
            autocomplete.addListener("place_changed", fillInAddress);
        }

        function fillInAddress() {
            // Get the place details from the autocomplete object.
            const place = autocomplete.getPlace();
            let address1 = "";
            let postcode = "";

            // Get each component of the address from the place details,
            // and then fill-in the corresponding field on the form.
            // place.address_components are google.maps.GeocoderAddressComponent objects
            // which are documented at http://goo.gle/3l5i5Mr
            for (const component of place.address_components) {
                // @ts-ignore remove once typings fixed
                const componentType = component.types[0];

                switch (componentType) {
                    case "street_number": {
                        address1 = `${component.long_name} ${address1}`;
                        break;
                    }

                    case "route": {
                        address1 += component.short_name;
                        break;
                    }

                    case "postal_code": {
                        postcode = `${component.long_name}${postcode}`;
                        break;
                    }

                    case "postal_code_suffix": {
                        postcode = `${postcode}-${component.long_name}`;
                        break;
                    }
                    case "locality":
                        document.querySelector("#CITY").value = component.long_name;
                        break;
                    case "administrative_area_level_1": {
                        document.querySelector("#STATE").value = component.short_name;
                        break;
                    }
                    case "POSTAL":
                        document.querySelector("#POSTAL").value = component.postcode;
                        break;
                }
            }

            address1Field.value = address1;
            postalField.value = postcode;
            // After filling the form with address components from the Autocomplete
            // prediction, set cursor focus on the second address line to encourage
            // entry of subpremise information such as apartment, unit, or floor number.
        }

        window.initAutocomplete = initAutocomplete;
    </script>
    <script>
        $(document).ready(function() {
            $('.DRIVER_PHONE').inputmask('(999)-999-9999');
            $('.SSN_NUM').inputmask('999-99-9999');
        });
    </script>
    <script>
        $(document).ready(function() {
            var url = "<?php echo e(route('get_cashavailable', '@')); ?>";
            url = url.replace('@', '<?php echo e($data['driver']->SMART_DRIVERID); ?>');
            $.ajax({
                url: url,
                type: "GET",
                beforeSend: function() {
                    $("#load_cash").hide();
                    $(".loader").show();
                },
                success: function(data) {
                    var cashAvailable = parseFloat(data);
                    var formattedCash = cashAvailable.toFixed(2);
                    $('#get_cashavailable').html('$ ' + formattedCash);
                },
                complete: function(data) {
                    $(".loader").hide();
                }
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            var url = "<?php echo e(route('card_info', '@')); ?>";
            url = url.replace('@', '<?php echo e($data['driver']->SMART_DRIVERID); ?>');
            console.log(url);
            $.ajax({
                url: url,
                type: "GET",
                beforeSend: function() {
                    $(".loader").show();
                },
                success: function(data) {
                    if (data != []) {
                        $('#card_info_last_tr_date').html(data['header']['lastUsedDate']);
                        $('#card_info_last_tr').html(data['header']['lastTransaction']);
                        $('#card_info_status').html(data['header']['status']);
                        $('#card_status').html(data['header']['status']);
                        if (data['header']['status'] == 'ACTIVE') {
                            $('#active').val(1);
                            $('#active').attr('checked', 'checked');
                        } else if (data['header']['status'] == 'INACTIVE') {
                            $('#inactive').val(0);
                            $('#inactive').attr('checked', 'checked');
                        }
                        if ("<?php echo e(Auth::user()->userlevel); ?>" == 'admin') {
                            $('#card_info_card_no').html(data['cardNumber']);
                        } else {
                            var cardNumber = data['cardNumber'];
                            var formattedCardNumber = cardNumber.substr(0, 6) + "******" + cardNumber
                                .substr(-4);
                            $('#card_info_card_no').html(formattedCardNumber);
                        }
                    }
                },
                complete: function(data) {
                    $(".loader").hide();
                }
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#set_default_data').on('click', function() {
                $('#ADDRESS').val('P.O. box 680');
                $('#CITY').val('Murrayville');
                $('#STATE').val('GA');
                $('#POSTAL').val('30564');
                $('#COUNTRY').val('USA');
                $('#DOB').val('1988-09-21');
                $('#SSN_NUM').val('555-25-4878');
                $('#DRIVER_PHONE').val('945-250-9945');
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#liveSmartDriverData').on('click', function() {
                var url = "<?php echo e(route('liveSmartDriverData', '@')); ?>";
                url = url.replace('@', '<?php echo e($data['driver']->SMART_DRIVERID); ?>');
                $.ajax({
                    url: url,
                    type: "GET",
                    beforeSend: function() {
                        $("#load_cash").hide();
                        $(".loader1").show();
                    },
                    success: function(data) {
                        $('#live_Address').html(data.address);
                        $('#live_City').html(data.city);
                        $('#live_State').html(data.state);
                        $('#live_Postal').html(data.postalCode);
                        $('#live_Country').html(data.country);
                        $('#live_DOB').html(new Date(data.dob).toLocaleDateString('en-US', {
                            month: '2-digit',
                            day: '2-digit',
                            year: 'numeric'
                        }));
                        $('#live_Last4ss').html(data.last4ss);
                        $('#live_Phone').html(data.phone);
                    },
                    complete: function(data) {
                        $(".loader1").hide();
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tmstmdashboard/master.tmdashboard.com/backoffice/resources/views/dashboard/driver/profile_driver.blade.php ENDPATH**/ ?>