
<style>
    .control-label:after {
        content: "*";
        color: red;
    }
</style>
<form method="POST" action="<?php echo e(get_admin_url('personalDataAdd')); ?>" class="form-horizontal" enctype="multipart/form-data">
    <?php echo e(csrf_field()); ?>

    <input type="hidden" name="action" value="<?php echo e($data['action']); ?>">
    <input type="hidden" name="userid" value="<?php echo e($data['userid']); ?>">
    <input type="hidden" name="driverid" value="<?php echo e($data['driver']->SMART_DRIVERID); ?>">
    <div class="row">

        <div class="col-md-3">
            <div class="form-group">
                <label class="control-label">Address</label><br>
                <input type="text" name="ADDRESS" id="ADDRESS"
                    value="<?php echo e(old('ADDRESS', $data['driver']->ADDRESS)); ?>" cLass="form-control col-md-6" required>
                <?php if($errors->has('ADDRESS')): ?>
                    <span class="text-danger"><?php echo e($errors->first('ADDRESS')); ?></span>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-md-3">
            <div class="form-group">
                <label class="control-label">City</label><br>
                <input type="text" name="CITY" id="CITY" cLass="form-control col-md-6"
                    value="<?php echo e(old('CITY', $data['driver']->CITY)); ?>" required>
                <?php if($errors->has('CITY')): ?>
                    <span class="text-danger"><?php echo e($errors->first('CITY')); ?></span>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-md-3">
            <div class="form-group">
                <label class="control-label">State</label><br>
                <?php $state = ['AL', 'AK', 'AZ', 'AR', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 'ID', 'IL', 'IN', 'IA', 'KS', 'KY', 'LA', 'ME', 'MD', 'MA', 'MI', 'MN', 'MS', 'MO', 'MT', 'NE', 'NV', 'NH', 'NJ', 'NM', 'NY', 'NC', 'ND', 'OH', 'OK', 'OR', 'PA', 'RI', 'SC', 'SD', 'TN', 'TX', 'UT', 'VT', 'VA', 'WA', 'WV', 'WI', 'WY']; ?>
                <select name="STATE" id="STATE"
                    class="form-control custom-select form-select custom-select-sm form-control form-control-sm"
                    required>
                    <?php $__currentLoopData = $state; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($item); ?>"<?php echo e($item == $data['driver']->STATE ? 'selected' : ''); ?>>
                            <?php echo e($item); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('STATE')): ?>
                    <span class="text-danger"><?php echo e($errors->first('STATE')); ?></span>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-md-3">
            <div class="form-group">
                <label class="control-label">Postal Code</label><br>
                <input type="text" name="POSTAL" id="POSTAL" cLass="form-control col-md-6"
                    value="<?php echo e(old('POSTAL', $data['driver']->POSTAL)); ?>" required>
                <?php if($errors->has('POSTAL')): ?>
                    <span class="text-danger"><?php echo e($errors->first('POSTAL')); ?></span>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-md-3">
            <div class="form-group">
                <label class="control-label">Country</label><br>
                <input type="text" name="COUNTRY" id="COUNTRY" cLass="form-control col-md-6"
                    value="<?php echo e(old('COUNTRY', $data['driver']->COUNTRY)); ?>" required>
                <?php if($errors->has('COUNTRY')): ?>
                    <span class="text-danger"><?php echo e($errors->first('COUNTRY')); ?></span>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="form-group">
                <label class="control-label">Dob</label><br>
                <input type="date" name="DOB" id="DOB" cLass="form-control col-md-6"
                    value="<?php echo e(old('DOB', date("Y-m-d", strtotime($data['driver']->DOB)))); ?>" required>
                <?php if($errors->has('DOB')): ?>
                    <span class="text-danger"><?php echo e($errors->first('DOB')); ?></span>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-md-3">
            <div class="form-group">
                <label class="control-label">Social Security No.</label><br>
                <input type="text" name="SSN_NUM" id="SSN_NUM" cLass="form-control col-md-6"
                    value="<?php echo e(old('SSN_NUM', $data['driver']->SSN_NUM)); ?>" required>
                <?php if($errors->has('SSN_NUM')): ?>
                    <span class="text-danger"><?php echo e($errors->first('SSN_NUM')); ?></span>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-md-3">
            <div class="form-group">
                <label class="control-label">Phone</label><br>
                <input type="number" name="DRIVER_PHONE" id="DRIVER_PHONE" cLass="form-control col-md-6"
                    value="<?php echo e(old('DRIVER_PHONE', $data['driver']->DRIVER_PHONE)); ?>" required>
                <?php if($errors->has('DRIVER_PHONE')): ?>
                    <span class="text-danger"><?php echo e($errors->first('DRIVER_PHONE')); ?></span>
                <?php endif; ?>
            </div>
        </div>

    </div>

    <div class="form-group mt-2">
        <button type="submit" class="btn btn-primary"><span></span>Update</button>
    </div>


</form>

<script
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyD5BQa0hFcyKzBa_dA2cbKt3QvdiWhxOvY&libraries&callback=initAutocomplete&libraries=places&v=weekly"
    defer></script>

<script>
    // This sample uses the Places Autocomplete widget to:
    // 1. Help the user select a place
    // 2. Retrieve the address components associated with that place
    // 3. Populate the form fields with those address components.
    // This sample requires the Places library, Maps JavaScript API.
    // Include the libraries=places parameter when you first load the API.
    // For example: <script
    // src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places">
    let autocomplete;
    let address1Field;
    let address2Field;
    let postalField;

    function initAutocomplete() {
        address1Field = document.querySelector("#ADDRESS");
        postalField = document.querySelector("#POSTAL");
        // Create the autocomplete object, restricting the search predictions to
        // addresses in the US and Canada.
        autocomplete = new google.maps.places.Autocomplete(address1Field, {
            componentRestrictions: {
                country: ["us"]
            },
            fields: ["address_components", "geometry"],
            types: ["address"],
        });
        address1Field.focus();
        // When the user selects an address from the drop-down, populate the
        // address fields in the form.
        autocomplete.addListener("place_changed", fillInAddress);
    }

    function fillInAddress() {
        // Get the place details from the autocomplete object.
        const place = autocomplete.getPlace();
        let address1 = "";
        let postcode = "";

        // Get each component of the address from the place details,
        // and then fill-in the corresponding field on the form.
        // place.address_components are google.maps.GeocoderAddressComponent objects
        // which are documented at http://goo.gle/3l5i5Mr
        for (const component of place.address_components) {
            // @ts-ignore remove once typings fixed
            const componentType = component.types[0];

            switch (componentType) {
                case "street_number": {
                    address1 = `${component.long_name} ${address1}`;
                    break;
                }

                case "route": {
                    address1 += component.short_name;
                    break;
                }

                case "postal_code": {
                    postcode = `${component.long_name}${postcode}`;
                    break;
                }

                case "postal_code_suffix": {
                    postcode = `${postcode}-${component.long_name}`;
                    break;
                }
                case "locality":
                    document.querySelector("#CITY").value = component.long_name;
                    break;
                case "administrative_area_level_1": {
                    document.querySelector("#STATE").value = component.short_name;
                    break;
                }
                case "POSTAL":
                    document.querySelector("#POSTAL").value = component.postcode;
                    break;
            }
        }

        address1Field.value = address1;
        postalField.value = postcode;
        // After filling the form with address components from the Autocomplete
        // prediction, set cursor focus on the second address line to encourage
        // entry of subpremise information such as apartment, unit, or floor number.
    }

    window.initAutocomplete = initAutocomplete;
</script>
<?php /**PATH /home/tmstmdashboard/master.tmdashboard.com/backoffice/resources/views/dashboard/users/user_form_personalData.blade.php ENDPATH**/ ?>