<?php
/**
 * Extension Name: Fun Facts
 * Extension URI: http://themearabia.net/extension/funfacts
 * license: free
 * Version: 1.0
 * Requires: 5.0
 * Description: Fun Facts
 * Author: Themearabia
 * Author URI: http://themearabia.net
*/

if (!class_exists('extensions_funfacts')) {
    class extensions_funfacts
    {

        protected $veiwdir      = 'posts.funfacts';
        protected $ex_id        = 'funfacts';
        protected $ex_type      = 'funfacts';
        protected $option_name  = 'options_funfacts';
        protected $path         = '';
        protected $ex_url       = '';
        protected $ex_lang      = 'funfacts';
        protected $ex_icon      = 'bx bx-grid-horizontal';
        protected $ex_order     = '82';
        protected $version      = '1.0';

        /**
         * __construct()
         */
        function __construct()
        {
            $this->path     = extension_path($this->ex_id);
            $this->ex_url   = extension_url($this->ex_id);
            $this->options  = maybe_unserialize(get_option($this->option_name));
            if(is_admin())
            {
                Eventy::addAction('admin_options_menu', [$this, 'admin_options_menu'], $this->ex_order, 1);
                Eventy::addAction('admin_options_content', [$this, 'admin_options_content'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_homepage_options', [$this, 'widgets_homepage_options'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_options_funfacts_boxs', [$this, 'widgets_options_funfacts_boxs_echo'], $this->ex_order, 1);
                Eventy::addFilter('action_widgets_options_funfacts_boxs', [$this, 'widgets_options_funfacts_boxs'], $this->ex_order, 1);
                Eventy::addFilter('action_widget_get_boxs_element_funfacts_boxs', [$this, 'widget_get_boxs_element_funfacts_boxs'], $this->ex_order, 1);
            }
            else
            {
                Eventy::addFilter('widgets_homepage_start', [$this, 'widgets_homepage_start'], $this->ex_order, 1);
                Eventy::addFilter('widgets_homepage_data_funfacts_boxs', [$this, 'filter_data_home'], $this->ex_order, 1);
            }
        }

        /**
         * filter_data_home($data = [])
         */
        public function filter_data_home($data = [])
        {
            if(is_extensions('funfacts'))
            {
                $default_options['title']           = '';
                $default_options['description']     = '';
                $default_options['more_button']     = false;
                $default_options['more_icon']       = '';
                $default_options['more_txt']        = '';
                $default_options['more_url']        = false;
                $default_options['bgclass']         = 'bg_white';
                $default_options['bgattachment']    = 'fixed';
                $default_options['bgrepeat']        = 'no_repeat';
                $default_options['bgsize']          = 'cover';
                $default_options['image']           = false;
                $default_options['image_style']     = '';
                $default_options['style']           = 'style1';
                $default_options['column']          = 'col-md-3';
                $options = mega_parse_args($data, $default_options);
                $newdata = [];
                $options['bgclass'] = (in_array($options['bgclass'], ['bg_black', 'bg_color']))? $options['bgclass'].' title-white' : $options['bgclass'];
                if($options['bgclass'] == 'bg_img')
                {
                    $options['bgclass'] = 'bg-image title-white '.$options['bgattachment'].' '.$options['bgrepeat'].' '.$options['bgsize'];
                    $options['image_style'] = ' style="background-image: url('.$options['image'].')"';
                }
                $boxs = [];
                $newdefboxs = [];
                $defboxs = (isset($this->options['boxs']))? $this->options['boxs'] : [];
                if(isset($defboxs) and is_array($defboxs)){
                    foreach($defboxs as $defbox){
                        $newdefboxs[$defbox['uqid']] = $defbox;
                    }
                }

                if(isset($data['boxs']) and is_array($data['boxs'])){
                    foreach($data['boxs'] as $uqid) {
                        if(isset($newdefboxs[$uqid]))
                        {
                            $boxs[] = $newdefboxs[$uqid];
                        }
                    }
                }
                
                $options['boxs']    = $boxs;
                $newdata['options'] = $options;
                $newdata['column']  = $options['column'];
                return $newdata;
            }
            else
            {
                return $data;
            }
        }

        /**
         * widgets_homepage_options($value)
         */
        public function widgets_homepage_options($value)
        {
            $options = [
                'funfacts_boxs' => [
                    'title' => extension_lang($this->ex_lang, 'funfacts'), 
                    'option' => 'funfacts_boxs'
                ]
            ];
            echo foreach_widgets_homepage_options($options, $value, extension_lang($this->ex_lang, 'funfacts'));
        }

        /**
         * widget_get_boxs_element_funfacts_boxs()
         */
        public function widget_get_boxs_element_funfacts_boxs($data)
        {
            $option_boxs = [];
            if(isset($this->options['boxs']) and is_array($this->options['boxs']))
            {
                foreach($this->options['boxs'] as $box)
                {
                    $option_boxs[] = ['id' => $box['uqid'], 'title' => $box['title']];
                }
            }
            return $option_boxs;
        }

        /**
         * widgets_options_funfacts_boxs()
         */
        public function widgets_options_funfacts_boxs($data)
        {
            $newdefboxs     = [];
            $option_boxs    = [];    
            $defboxs        = (isset($this->options['boxs']))? $this->options['boxs'] : [];
            $style          = (isset($data['widget']['style']))? $data['widget']['style'] : 'style1';
            $column         = (isset($data['widget']['column']))? $data['widget']['column'] : 'col-md-3';
            $boxs           = (isset($data['widget']['boxs']))? $data['widget']['boxs'] : [];
            if(isset($defboxs) and is_array($defboxs)){
                foreach($defboxs as $key => $defbox){
                    $newdefboxs[$defbox['uqid']] = ['id' => $defbox['uqid'], 'title' => $defbox['title']];
                }
            }
            foreach($boxs as $key){
                if(isset($newdefboxs[$key])){
                    $option_boxs[] = $newdefboxs[$key];
                }
            }
            $option_style = ['id' => $data['option_name'].'['.$data['key'].'][style]', 'box_class' => 'form-group', 'name' => admin_lang('style'), 'value' => $style, 'options' => [
                'style1' => admin_lang('style'). ' 1', 
                'style2' => admin_lang('style'). ' 2'
            ]];
            $option_column = ['id' => $data['option_name'].'['.$data['key'].'][column]', 'box_class' => 'form-group', 'name' => admin_lang('column'), 'value' => $column, 'options' => [
                'col-md-2' => '6 '.admin_lang('column'),
                'col-md-3' => '4 '.admin_lang('column'),
                'col-md-4' => '3 '.admin_lang('column'),
                'col-md-6' => '2 '.admin_lang('column')
            ]];
            $options_boxs = ['id' => $data['option_name'].'['.$data['key'].'][boxs][]', 'modal_title' => admin_lang('add_box'), 'modal_size' => 'smaller', 'modal_search' => '1', 'option_action' => 'funfacts_boxs', 'option_key' => $data['key'], 'option_name' => $data['option_name'], 'box_class' => 'form-group', 'name' => admin_lang('boxs'), 'options' => $option_boxs];
            return '
            <div class="row">
                <div class="col-md-6">
                    '.field_radio_input($option_style, false).'
                    '.field_radio_input($option_column, false).'
                </div>
                <div class="col-md-6">
                    '.field_boxs_sortable_input($options_boxs, false).'
                </div>
            </div>
            ';
        }

        /**
         * widgets_options_funfacts_boxs_echo($data)
         */
        public function widgets_options_funfacts_boxs_echo($data)
        {
            echo $this->widgets_options_funfacts_boxs($data);
        }

        /**
         * widgets_homepage_start($value)
         */
        public function widgets_homepage_start($arg)
        {
            $support = [
                'funfacts_boxs'    => 'widgets.widget_funfacts'
            ];
            return mega_parse_args( $support, $arg );
        }

        /**
         * admin_options_menu()
         */
        public function admin_options_menu()
        {
            $data = ['id' => $this->ex_id, 'icon' => $this->ex_icon, 'title' => extension_lang($this->ex_lang, 'funfacts')];
            echo get_admin_view('hooks.admin_options_menu_tab', $data)->render();
        }

        /**
         * admin_options_content()
         */
        public function admin_options_content()
        {
            $data['options'][$this->ex_id]['funfacts'] = [
                'title'     => admin_lang('funfacts'),
                'options'   => [
                    ['type' => 'hidden', 'id' => $this->option_name.'[extension_version]', 'value' => $this->version],
                    ['type' => 'html', 'html' => $this->get_funfacts()]
                ]
            ];
            echo get_admin_view('hooks.admin_options_menu_content', $data)->render();
        }

        /**
         * get_funfacts()
         */
        public function get_funfacts()
        {
            $data['boxs'] = (isset($this->options['boxs']) and is_array($this->options['boxs']))? $this->options['boxs'] : [];
            $data['option_name'] = $this->option_name.'[boxs]';
            return get_admin_view('hooks.admin_extension_funfacts_boxs', $data)->render();
        }

    }

    new extensions_funfacts();
}
