<?php
/**
 * Extension Name: KnowledgeBase
 * Extension URI: http://themearabia.net/extension/knowledgebase
 * license: free
 * Version: 3.0
 * Requires: 5.0
 * Description: knowledge base
 * Author: Themearabia
 * Author URI: http://themearabia.net
 */

if (!class_exists('extensions_knowledgebase')) {
    class extensions_knowledgebase
    {

        protected $veiwdir      = 'posts.knowledgebase';
        protected $ex_id        = 'knowledgebase';
        protected $ex_type      = 'knowledgebase';
        protected $option_name  = 'options_knowledgebase';
        protected $path         = '';
        protected $ex_url       = '';
        protected $ex_lang      = 'knowledgebase';
        protected $ex_icon      = 'bx bx-receipt';
        protected $ex_order     = '20';

        function __construct()
        {
            $this->path     = extension_path($this->ex_id);
            $this->ex_url   = extension_url($this->ex_id);
            $this->options  = maybe_unserialize(get_option($this->option_name));
            if(is_admin())
            {
                Eventy::addAction('admin_dashboard_counter', [$this, 'admin_dashboard_counter'], $this->ex_order, 1);
                Eventy::addAction('admin_sidebar_menu', [$this, 'admin_sidebar_menu'], $this->ex_order, 1);
                Eventy::addAction('admin_options_menu', [$this, 'admin_options_menu'], $this->ex_order, 1);
                Eventy::addAction('admin_options_content', [$this, 'admin_options_content'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_identifier_types', [$this, 'supports_post_type'], $this->ex_order, 1);
                Eventy::addFilter('admin_permissions_args', [$this, 'admin_permissions_args'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_extension_url', [$this, 'admin_extension_url'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_homepage_options', [$this, 'widgets_homepage_options'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_options_knowledgebase_posts', [$this, 'widgets_options_knowledgebase_posts_echo'], $this->ex_order, 1);
                Eventy::addFilter('action_widgets_options_knowledgebase_posts', [$this, 'widgets_options_knowledgebase_posts'], $this->ex_order, 1);
            }
            else {
                Eventy::addFilter('widgets_homepage_start', [$this, 'widgets_homepage_start'], $this->ex_order, 1);
                Eventy::addFilter('widgets_homepage_data_knowledgebase_posts', [$this, 'filter_data_home'], $this->ex_order, 1);
            }
        }

        /**
         * filter_data_home($data = [])
         */
        public function filter_data_home($data = [])
        {
            if(is_extensions('knowledgebase'))
            {
                $default_options['title']           = '';
                $default_options['description']     = '';
                $default_options['more_button']     = false;
                $default_options['more_icon']       = '';
                $default_options['more_txt']        = '';
                $default_options['more_url']        = false;
                $default_options['bgclass']         = 'bg_white';
                $default_options['bgattachment']    = 'fixed';
                $default_options['bgrepeat']        = 'no_repeat';
                $default_options['bgsize']          = 'cover';
                $default_options['image']           = false;
                $default_options['image_style']     = '';
                $default_options['style']           = 'style1';
                $default_options['column']          = 'col-md-2';
                $default_options['cate']            = [];
                $default_options['limit']           = 4;
                $options = mega_parse_args($data, $default_options);
                $newdata = [];
                $options['bgclass'] = (in_array($options['bgclass'], ['bg_black', 'bg_color']))? $options['bgclass'].' title-white' : $options['bgclass'];
                if($options['bgclass'] == 'bg_img')
                {
                    $options['bgclass'] = 'bg-image title-white '.$options['bgattachment'].' '.$options['bgrepeat'].' '.$options['bgsize'];
                    $options['image_style'] = ' style="background-image: url('.$options['image'].')"';
                }
                $newdata['options'] = $options;
                $newdata['column'] = $options['column'];
                $newdata['kb_categories'] = $this->get_query($options['cate'])->limit($options['limit'])->get();
                return $newdata;
            }
            else
            {
                return $data;
            }
        }

        /**
         * get_query()
         */
        public function get_query($terms = [])
        {
            $query = DB::table(TERMS_TABLE)
            ->leftJoin('posts', 'posts.term_id', '=', 'terms.id')
            ->selectRaw(
                db_select_column_as('terms', 'id').
                db_select_column_as('terms', 'slug').
                db_select_column_as('terms', 'name').
                db_select_column_as('terms', 'description').
                db_select_column_as('terms', 'image').
                db_select_column_as_count('posts', 'id', 'posts_count', '')
            )
            ->where('type', $this->ex_type)
            ->where('post_type', $this->ex_type);
            if(is_array($terms) and count($terms)){
                $query->whereIn('term_id', $terms);
            }
            $query->groupBy('posts.term_id')->orderBy('orders', 'ASC');
            return $query;
        }

        /**
         * widgets_homepage_options($value)
         */
        public function widgets_homepage_options($value)
        {
            $options = [
                'knowledgebase_posts' => [
                    'title' => extension_lang($this->ex_lang, 'knowledgebase'), 
                    'option' => 'knowledgebase_posts'
                ]
            ];
            echo foreach_widgets_homepage_options($options, $value, extension_lang($this->ex_lang, 'knowledgebase'));
        }

        /**
         * widgets_options_knowledgebase_posts()
         */
        public function widgets_options_knowledgebase_posts($data)
        {
            $categories = [];
            foreach(get_categories_type($this->ex_type) as $cate)
            {
                if(get_post_count_status($this->ex_type, $cate->id))
                {
                    $categories[] = [
                        'name'  => $cate->name,
                        'id'    => $data['option_name'].'['.$data['key'].'][cate]['.$cate->id.']',
                        'value' => $cate->id,
                    ];
                }
            }
            $limit  = (isset($data['widget']['limit']))? $data['widget']['limit'] : 4;
            $style  = (isset($data['widget']['style']))? $data['widget']['style'] : 'style1';
            $column = (isset($data['widget']['column']))? $data['widget']['column'] : 'col-md-6';
            $cate   = (isset($data['widget']['cate']))? $data['widget']['cate'] : [];
            $option_style = ['id' => $data['option_name'].'['.$data['key'].'][style]', 'box_class' => 'form-group', 'name' => admin_lang('style'), 'value' => $style, 'options' => [
                'style1' => admin_lang('style'). ' 1', 
                'style2' => admin_lang('style'). ' 2', 
                'style3' => admin_lang('style'). ' 3'
            ]];
            $option_column = ['id' => $data['option_name'].'['.$data['key'].'][column]', 'box_class' => 'form-group', 'name' => admin_lang('column'), 'value' => $column, 'options' => [
                'col-md-4' => '3 '.admin_lang('column'),
                'col-md-6' => '2 '.admin_lang('column'),
                'col-md-12' => '1 '.admin_lang('column'),
            ]];
            $option_limit = ['id' => $data['option_name'].'['.$data['key'].'][limit]', 'box_class' => 'form-group', 'name' => admin_lang('post_per_page'), 'value' => $limit, 'min' => '1', 'max' => '32', 'step' => '1'];
            $options_cate = ['id' => $data['option_name'].'['.$data['key'].'][cate]', 'box_class' => 'form-group', 'name' => admin_lang('categories'), 'options' => $categories, 'value' => $cate];
            return '
            <div class="row">
                <div class="col-md-6">
                    '.field_radio_input($option_style, false).'
                </div>
                <div class="col-md-6">
                    '.field_radio_input($option_column, false).'
                </div>
                <div class="col-md-6">
                    '.field_checkbox_array_input($options_cate, false).'
                </div>
                <div class="col-md-6">
                    '.field_slider_number_input($option_limit, false).'
                </div>
            </div>
            ';
        }

        /**
         * widgets_options_knowledgebase_posts_echo($data)
         */
        public function widgets_options_knowledgebase_posts_echo($data)
        {
            echo $this->widgets_options_knowledgebase_posts($data);
        }

        /**
         * widgets_homepage_start($value)
         */
        public function widgets_homepage_start($arg)
        {
            $support = [
                'knowledgebase_posts'    => 'widgets.widget_knowledgebase'
            ];
            return mega_parse_args( $support, $arg );
        }

        /**
         * admin_extension_url
         */
        public function admin_extension_url()
        {
            $url    = url('kb');
            $title  = extension_lang($this->ex_lang, 'knowledgebase');
            $icon   = 'pe-7s-help2';
            $key    = 'knowledgebase';
            echo '
            <li>
                <div class="form-check">
                    <input class="form-check-input menu-item-checkbox" type="checkbox" id="menu-item-extension-'.$key.'" name="menu-item" data-url="'.$url.'" data-title="'.$title.'" data-icon="'.$icon.'">
                    <label class="form-check-label" for="menu-item-extension-'.$key.'">'.$title.'</label>
                </div>
            </li>
            ';
        }

        /**
         * supports_post_type($arg)
         */
        public function supports_post_type($arg = [])
        {
            $support = [$this->ex_type => ['slug' => 'kb']];
            return mega_parse_args( $support, $arg );
        }

        /**
         * admin_permissions_args($arg = [])
         */
        public function admin_permissions_args($arg = [])
        {
            $permission = [
                $this->ex_id  => [
                    'title' => extension_lang($this->ex_lang, 'knowledgebase'), 
                    'permission' => [
                        $this->ex_type => extension_lang($this->ex_lang, 'knowledgebase'),
                    ]
                ]
            ];
            return mega_parse_args( $permission, $arg );
        }

        /**
         * admin_dashboard_counter()
         */
        public function admin_dashboard_counter()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'count'     => get_post_count($this->ex_type),
                'title'     => extension_lang($this->ex_lang, 'knowledgebase'),
            ];
            echo get_admin_view('hooks.admin_dashboard_counter', $data)->render();
        }

        /**
         * admin_sidebar_menu()
         */
        public function admin_sidebar_menu()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'badge'     => false,
                'title'     => extension_lang($this->ex_lang, 'knowledgebase'),
                'submenu'   => [
                    ['title' => extension_lang($this->ex_lang, 'knowledgebase'), 'url' => get_admin_url('posts/'.$this->ex_type), 'badge' => ''],
                    ['title' => admin_lang('add_new'), 'url' => get_admin_url('postnew/'.$this->ex_type), 'badge' => ''],
                    ['title' => admin_lang('categories'), 'url' => get_admin_url('categories/'.$this->ex_type), 'badge' => '']
                ]
            ];
            if(is_permission($this->ex_type)){
                echo get_admin_view('hooks.admin_sidebar_menu', $data)->render();
            }
        }

        /**
         * admin_options_menu()
         */
        public function admin_options_menu()
        {
            $data = ['id' => $this->ex_id, 'icon' => $this->ex_icon, 'title' => extension_lang($this->ex_lang, 'knowledgebase')];
            echo get_admin_view('hooks.admin_options_menu_tab', $data)->render();
        }

        /**
         * admin_options_content()
         */
        public function admin_options_content()
        {
            $template           = (isset($this->options['template']))? $this->options['template'] : 'template1';
            $column             = (isset($this->options['column']))? $this->options['column'] : '';
            $style              = (isset($this->options['style']))? $this->options['style'] : 'full';
            $single_style       = (isset($this->options['single_style']))? $this->options['single_style'] : 'full';
            $widget_search      = (isset($this->options['widget_search']))? $this->options['widget_search'] : '';
            $search_text        = (isset($this->options['search_text']))? $this->options['search_text'] : '';
            $widget_categories  = (isset($this->options['widget_categories']))? $this->options['widget_categories'] : 0;
            $widget_recent      = (isset($this->options['widget_recent']))? $this->options['widget_recent'] : 0;
            $widget_tags        = (isset($this->options['widget_tags']))? $this->options['widget_tags'] : 0;
            $post_per_recent    = (isset($this->options['post_per_recent']))? $this->options['post_per_recent'] : 3;
            $post_per_page      = (isset($this->options['post_per_page']))? $this->options['post_per_page'] : 3;
            $cate_per_page      = (isset($this->options['cate_per_page']))? $this->options['cate_per_page'] : 10;
            $meta_author        = (isset($this->options['meta_author']))? $this->options['meta_author'] : 0;
            $meta_date          = (isset($this->options['meta_date']))? $this->options['meta_date'] : 0;
            $meta_comments      = (isset($this->options['meta_comments']))? $this->options['meta_comments'] : 0;
            $meta_views         = (isset($this->options['meta_views']))? $this->options['meta_views'] : 0;
            $meta_cate          = (isset($this->options['meta_cate']))? $this->options['meta_cate'] : 0;
            $meta_shareit       = (isset($this->options['meta_shareit']))? $this->options['meta_shareit'] : 0;            
            $categories         = [];
            foreach(get_categories_type($this->ex_type) as $cate)
            {
                if(get_post_count_status($this->ex_type, $cate->id))
                {
                    $categories[] = [
                        'name'  => $cate->name,
                        'id'    => $this->option_name.'[terms_home]['.$cate->id.']',
                        'value' => $cate->id,
                    ];
                }
            }

            $data['options'][$this->ex_id]['section_general'] = [
                'title'     => admin_lang('general'),
                'options'   => [
                    ['type' => 'radio', 'id' => $this->option_name.'[template]', 'name' => admin_lang('template'), 'value' => $template, 'options' => [
                        'template1' => admin_lang('template').' 1',
                        'template2' => admin_lang('template').' 2',
                        'template3' => admin_lang('template').' 3',
                    ]],
                    ['type' => 'radio', 'id' => $this->option_name.'[column]', 'name' => admin_lang('column'), 'value' => $column, 'options' => [
                        'col-md-3' => '4 '.admin_lang('column'),
                        'col-md-4' => '3 '.admin_lang('column'),
                        'col-md-6' => '2 '.admin_lang('column'),
                    ]],
                    ['type' => 'slider_number', 'id' => $this->option_name.'[post_per_page]', 'name' => admin_lang('post_per_page'), 'value' => $post_per_page, 'min' => '1', 'max' => '32', 'step' => '1'],
                ]
            ];
            $data['options'][$this->ex_id]['section_category'] = [
                'title'     => admin_lang('category'),
                'options'   => [
                    ['name' => admin_lang('style'), 'id' => $this->option_name.'[style]', 'type' => 'radio', 'value' => $style, 'options' => [
                        'left_sidebar'  => ['label' => admin_lang('left_sidebar'), 'img' => asset('dashboard/images/options/left_sidebar.png')],
                        'right_sidebar' => ['label' => admin_lang('right_sidebar'), 'img' => asset('dashboard/images/options/right_sidebar.png')],
                        'fixed'         => ['label' => admin_lang('centered'), 'img' => asset('dashboard/images/options/fixed.png')],
                        'full'          => ['label' => admin_lang('full_width'), 'img' => asset('dashboard/images/options/full.png')],
                    ]],
                    ['type' => 'slider_number', 'id' => $this->option_name.'[cate_per_page]', 'name' => admin_lang('post_per_page'), 'value' => $cate_per_page, 'min' => '1', 'max' => '32', 'step' => '1'],
                ]
            ];
            $data['options'][$this->ex_id]['section_widget'] = [
                'title'     => admin_lang('widgets'),
                'options'   => [
                    ['type' => 'checkbox', 'id' => $this->option_name.'[widget_search]', 'name' => admin_lang('widget_search'), 'value' => $widget_search],
                    ['type' => 'text', 'id' => $this->option_name.'[search_text]', 'name' => admin_lang('placeholder'), 'value' => $search_text],
                    ['type' => 'checkbox', 'id' => $this->option_name.'[widget_categories]', 'name' => admin_lang('widget_categories'), 'value' => $widget_categories],
                    ['type' => 'checkbox', 'id' => $this->option_name.'[widget_recent]', 'name' => admin_lang('widget_recent'), 'value' => $widget_recent],
                    ['type' => 'slider_number', 'id' => $this->option_name.'[post_per_recent]', 'name' => admin_lang('post_per_page'), 'value' => $post_per_recent, 'min' => '1', 'max' => '12', 'step' => '1'],
                    ['type' => 'checkbox', 'id' => $this->option_name.'[widget_tags]', 'name' => admin_lang('widget_tags'), 'value' => $widget_tags],
                ]
            ];
            $data['options'][$this->ex_id]['section_single'] = [
                'title'     => admin_lang('single_post'),
                'options'   => [
                    ['name' => admin_lang('style'), 'id' => $this->option_name.'[single_style]', 'type' => 'radio', 'value' => $single_style, 'options' => [
                        'left_sidebar'  => ['label' => admin_lang('left_sidebar'), 'img' => asset('dashboard/images/options/left_sidebar.png')],
                        'right_sidebar' => ['label' => admin_lang('right_sidebar'), 'img' => asset('dashboard/images/options/right_sidebar.png')],
                        'fixed'         => ['label' => admin_lang('centered'), 'img' => asset('dashboard/images/options/fixed.png')],
                        'full'          => ['label' => admin_lang('full_width'), 'img' => asset('dashboard/images/options/full.png')],
                    ]],
                    ['type' => 'checkbox_group','name' => admin_lang('meta'), 'options' => [
                        ['id' => $this->option_name.'[meta_author]', 'name' => admin_lang('author'), 'value' => $meta_author],
                        ['id' => $this->option_name.'[meta_date]', 'name' => admin_lang('date'), 'value' => $meta_date],
                        ['id' => $this->option_name.'[meta_comments]', 'name' => admin_lang('comments'), 'value' => $meta_comments],
                        ['id' => $this->option_name.'[meta_views]', 'name' => admin_lang('views'), 'value' => $meta_views],
                        ['id' => $this->option_name.'[meta_cate]', 'name' => admin_lang('category'), 'value' => $meta_cate],
                    ]],
                    ['type' => 'checkbox', 'id' => $this->option_name.'[meta_shareit]', 'name' => admin_lang('share'), 'value' => $meta_shareit],
                ]
            ];
            echo get_admin_view('hooks.admin_options_menu_content', $data)->render();
        }
        
    }

    new extensions_knowledgebase();
}
