<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Bookmaster;
use PHPUnit\Framework\Constraint\Count;
use App\Http\Requests\BookRequest;

class BookmasterController extends Controller
{
    private $url_prefix;
    private $page_title;
    private $url_new;
    private $btn_new;
    private $paginate;

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->url_prefix   = 'Bookmaster';
        $this->page_title   = 'Bookmaster';
        $this->btn_new      = 'add_new';
        $this->url_new      = get_admin_url('bookmasteradd');
        $this->paginate     = 5;
    }
    // index users
    public function index_bookmaster($type = '',Request $request)
    {
       
       
        $data['type']       = 'users';
        $data['page_class'] = 'bookmaster';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
        //if ($request->has('page') and $request->get('page') > $bookmaster->lastPage()) {return redirect($bookmaster->url($bookmaster->lastPage()));}
        return get_admin_view('bookmaster.index_bookmaster',["data"=> $data]);
    }

    public function ajaxlist_bookmaster(Request $request){
    
        if($request->ajax())
        {
            $data['type']       = 'users';
            $data['page_class'] = 'bookmaster';
            $data['url_prefix'] = $this->url_prefix;
            $data['page_title'] = $this->page_title;
            $data['btn_new']    = $this->btn_new;
            $data['url_new']    = $this->url_new;
            $bookmaster=new Bookmaster();
         
            $bookmaster = $bookmaster->orderBy('created_at', 'DESC');
          
            if($request->get('s')){
                $search = $request->get('s');
                $bookmaster->orWhere('book_no', 'LIKE', "%{$search}%");
                $bookmaster->orWhere('receipt_start', 'LIKE', "%{$search}%");                                
                $bookmaster->orWhere('receipt_end', 'LIKE', "%{$search}%");
                $bookmaster->orWhere('created_at', 'LIKE', "%{$search}%");
            }
            $bookmaster = $bookmaster->paginate($this->paginate);
            if($request->has('page') and $request->get('page') > $bookmaster->lastPage()) {
                return redirect($bookmaster->url($bookmaster->lastPage()));
            }
            return get_admin_view('bookmaster.ajaxlist_bookmaster', ["data"=> $data,'bookmasters'=>$bookmaster]);
        }
        
       }

       public function bookmaster_profile($id =0, Request $request)
       {
      
           $curre_user = Auth::user();
          
           $user_id =  $curre_user->id;
      
           $bookmaster=Bookmaster::find($id);
        
           if($bookmaster){
           
           $getuser = User::find($user_id);
          
           if ($getuser->count()) {
              
               $type               = 'users';
               $user               = $getuser->first();
               $data['user']       = $user;
               $data['type']       = $type;
               $data['page_class'] = $type;
               $data['action']     = 'update';
               $data['page_title'] = 'Update bookmaster';
               $data['user_meta']  = query_user_meta($data['user']->id);
           
               $datauser                   = $user;
               $data['user_userlevel']     = $curre_user->userlevel;
               $data['userlevel']          = $datauser->userlevel;
               $data['type']               = $datauser->userlevel;
               $data['page_class']         = $datauser->userlevel;
               $data['action']             = 'update';
               $data['userid']             = $datauser->id;
               $data['username']           = $datauser->username;
               $data['email']              = $datauser->email;
               $data['user_status']        = $datauser->status;
               $data['admin_language']     = get_user_meta('admin_language', $user_id, 'en');
               $permission                 = maybe_unserialize(get_user_meta('permission', $user_id, []));
               $data['user_permission']    = (is_array($permission))? $permission : [];
   
               return get_admin_view('bookmaster.profile_bookmaster', ["data"=>$data,"bookmaster"=>$bookmaster]);
                }
            }
       } 

       public function index_bookmasteradd(Request $request)
       {
           $user = Auth::user();
           
           $data['page_title']         = "Add bookmaster";
           $type                       = 'users';
           $data['type']               = $type;
           $data['page_class']         = $type;
           $data['action']             = 'addnew';
           $data['user_userlevel']     = $user->userlevel;
           $data['userlevel']          = 'user';
           $data['user_vip']           = '0';
           $data['user_viptime']       = '';
           $data['userid']             = '0';
           $data['user_status']        = '1';
           $data['username']           = '';
           $data['email']              = '';
           $data['admin_language']     = 'en';
           $data['user_permission']    = [];
           return get_admin_view('bookmaster.bookmaster_edit', ['data'=>$data]);
       }
   
       // send form
       public function bookmaster_sendform(BookRequest $request)
       {
           
           $user = Auth::user();
       
           $userid = $request->get('userid');
           $bookmaster=Bookmaster::create([
               "book_no"=>$request->input('book_no'),
               "receipt_start"=>$request->input('receipt_start'),
               "receipt_end"=>$request->input("receipt_end")
            ]);
           if($bookmaster){
            $request->session()->put('success', 'bookmaster '.$request->input('book_no') . ' added Successfully!');
            return redirect()->back();
             }else{
                $request->session()->put('failure', 'bookmaster '.$request->input('book_no') . ' Not added!');
                return redirect()->back();
             }
        
       
          // return redirect(get_admin_url('profile/'.$user_id))->with("success", $success);
       }
   
   
       // actions post
       public function bookmaster_actions(BookRequest $request)
       {
        


           if($request->has('query') && $request->get('query') == 'action')
           {
             
                if($request->get('action') == 'update')
               {
                
                   $bookmaster=Bookmaster::find($request->input('id'));
                   $bookmaster->book_no = $request->input('book_no');
                   $bookmaster->receipt_start = $request->input('receipt_start');
                   $bookmaster->receipt_end = $request->input('receipt_end');
                   
                   if($bookmaster->save()){
                    $request->session()->put('success', "bookmaster Updated successfully!");
                    return redirect()->back();
                   }else{
                    $request->session()->put('failure', "bookmaster Not Updated!");
                    return redirect()->back();
                   }
               }
      else{
               $marks = $request->get('mark');
                if(empty($marks)){
                   return redirect()->back();
                }
              
                $faileditem=0;
                $success="";
               if($request->get('action') == 'delete' and is_array($marks))
               {
                 
                   foreach($marks as $markid)
                   {
                    
                      $success= Bookmaster::find($markid)->delete();
                      if(empty($success)){
                       $faileditem= $faileditem+1;
                      }
                   }
                 
                   if($faileditem==0){
                       
                    $request->session()->put("success", "Selected Items are Deleted Successfully!");
                       return redirect()->back();
                   }
                   else if($faileditem!=0){
                    $request->session()->put("failure","Selected Items are deleted except $faileditem book");
                       return redirect()->back();
                   }
                   else{
                    $request->session()->put("failure","Selected Items are not deleted");
                       return redirect()->back();
                   }
               }
            
   
               
           }
       }
       }
      
   
   
   
       // action delete bookmaster
       public function index_deletebookmaster($id, $token,Request $request)
       { 
         $bookmaster=Bookmaster::find($id);
         $book_no=$bookmaster->book_no;
         $bookmaster=$bookmaster->delete();
         if($bookmaster){
            $request->session()->put("success", "Book No $book_no deleted Successfully!");
            return redirect()->back();
    
         }else{
            $request->session()->put("failure", "Book No $book_no Not deleted");
            return redirect()->back();
         }
       }




}
