<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\City;
use App\Models\State;
use App\Models\Country;
use App\Models\Utility;
use PHPUnit\Framework\Constraint\Count;
use Illuminate\Support\Facades\Session;

class CityController extends Controller
{
    private $url_prefix;
    private $page_title;
    private $url_new;
    private $btn_new;
    private $paginate;

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->url_prefix   = 'City';
        $this->page_title   = 'City';
        $this->btn_new      = 'add_new';
        $this->url_new      = get_admin_url('cityadd');
        $this->paginate     = 5;
    }
    //city index
    public function index_city($type = '',Request $request)
    {
       
        $data['type']       = 'users';
        $data['page_class'] = 'city';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
       
        return get_admin_view('city.index_city',["data"=> $data]);
    }


      //city ajaxlist_table
      public function ajaxlist_city(Request $request){
      
        if($request->ajax())
        {
            $data['type']       = 'users';
            $data['page_class'] = 'city';
            $data['url_prefix'] = $this->url_prefix;
            $data['page_title'] = $this->page_title;
            $data['btn_new']    = $this->btn_new;
            $data['url_new']    = $this->url_new;


         
             $city=City::orderBy('created_at', 'DESC');
            if($request->get('s')){
             
                $search = $request->get('s');
             
                $city->orWhere('city_name', 'LIKE', "%{$search}%");
                $city->orWhere('city_name_gj', 'LIKE', "%{$search}%");
                $city->orWhere('id', 'LIKE', "%{$search}%");
                $city->orWhere('created_at', 'LIKE', "%{$search}%");
                $city->orWhere(function ($query) use ($search) {
                    $query->whereHas('state', function ($q) use ($search) {
                        $q->where('state_name', 'LIKE', '%' . $search . '%');
                    });
                });
           
            }
        
            $city = $city->paginate($this->paginate);
        
            if($request->has('page') and $request->get('page') > $city->lastPage()) {return redirect($city->url($city->lastPage()));}
            return get_admin_view('city.ajaxlist_city', ["data"=> $data,'citys'=>$city]);
        }
        }

    //city addform
    public function index_cityadd(Request $request)
    {
        $user = Auth::user();
        
        $data['page_title']         = "Add City";
        $type                       = 'users';
        $data['type']               = $type;
        $data['page_class']         = $type;
        $data['action']             = 'addnew';
        $data['user_userlevel']     = $user->userlevel;
        $data['userlevel']          = 'user';
        $data['user_vip']           = '0';
        $data['user_viptime']       = '';
        $data['userid']             = '0';
        $data['user_status']        = '1';
        $data['username']           = '';
        $data['email']              = '';
        $data['admin_language']     = 'en';
        $data['user_permission']    = [];

        $state=State::all();
        $country=Country::all();
        return get_admin_view('city.city_edit', ['data'=>$data,"states"=> $state,"countrys"=>$country]);
        
    }

        // add City
        public function city_sendform(Request $request)
        {
     
            $user = Auth::user();
        
             $userid = $request->get('userid');
             $city=City::create(["state_id"=>$request->input('state_id'),
            "city_name"=>$request->input("city_name"),
            "city_name_gj"=>$request->input("city_name_gj")]);
            if($city){
                return redirect()->back()->with('success','City '.$request->input('city_name') . ' added Successfully!');
              }
              else{
                return redirect()->back()->with('failure', "City ".$request->input('city_name') . ' Not added');
              }
         
        
            }
        
        public function city_profile($id =0, Request $request)
        {
       
            $curre_user = Auth::user();
           
            $user_id =  $curre_user->id;
       
            $city=City::find($id);
            $state=State::all();
          
         
            if($city){
            
            $getuser = User::find($user_id);
           
            if ($getuser->count()) {
               
                $type               = 'users';
                $user               = $getuser->first();
                $data['user']       = $user;
                $data['type']       = $type;
                $data['page_class'] = $type;
                $data['action']     = 'update';
                $data['page_title'] = 'Update City';
                $data['user_meta']  = query_user_meta($data['user']->id);
            
                $datauser                   = $user;
                $data['user_userlevel']     = $curre_user->userlevel;
                $data['userlevel']          = $datauser->userlevel;
                $data['type']               = $datauser->userlevel;
                $data['page_class']         = $datauser->userlevel;
                $data['action']             = 'update';
                $data['userid']             = $datauser->id;
                $data['username']           = $datauser->username;
                $data['email']              = $datauser->email;
                $data['user_status']        = $datauser->status;
                $data['admin_language']     = get_user_meta('admin_language', $user_id, 'en');
                $permission                 = maybe_unserialize(get_user_meta('permission', $user_id, []));
                $data['user_permission']    = (is_array($permission))? $permission : [];
                $countrys=Country::all();
                return get_admin_view('city.profile_city', ["data"=>$data,"city"=>$city,"states"=>$state]);
            }
        }
    }
     // actions of city
    public function city_actions(Request $request)
    { 
    
     
        if($request->has('query') && $request->get('query') == 'action')
        {
          
             if($request->get('action') == 'update')
            {
               
                $city=City::find($request->input('id'));
                $city->state_id = $request->input('state_id');
                $city->city_name = $request->input('city_name');
                $city->city_name_gj = $request->input('city_name_gj');
                if($city->save()){
                  
                    $request->session()->put('success', "City Updated successfully!");
                    return redirect()->back();
                }else{
                    $request->session()->put('failure', "City Not Updated!");
                    return redirect()->back();
                }
            }
     else{
      
            $marks = $request->get('mark');
             if(empty($marks)){
                return redirect()->back();
             }
            
             $faileditem=0;
            if($request->get('action') == 'delete' and is_array($marks))
            {
             
                foreach($marks as $markid)
                {
                    $city=City::find($markid);
                    $success= $city->delete();
                   if(empty($success)){
                    $faileditem= $faileditem+1;
                   }
                }
                if($faileditem==0){
                    $request->session()->put('success', "Selected City Items are Deleted Successfully!");
                    return redirect()->back();
                }
                else if($faileditem!=0){
                    $request->session()->put('failure', "Selected City Items are deleted except $faileditem 
                    City");
                }
                else{
                    $request->session()->put('failure', "Selected City Items are not deleted");
                    return redirect()->back();
                }
            }       
        }
    }
    }


       // action delete city
       public function index_deletecity($id, $token ,Request $request)
       { 
  
         $city=City::find($id);
         $cityname=$city->city_name;
         $city=$city->delete();
         if($city){
           
             $request->session()->put("success", "City $cityname deleted Successfully!");
             return redirect()->back();
         }else{
           $request->session()->put("failure", "City $cityname deleted");
           return redirect()->back();
         }
       }


        }
       
