<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CommentsController extends Controller
{
    private $paginate;

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->paginate = 10;
    }
    
    public function get_loop_comments($column = false, $type = '')
    {
        $comments = DB::table(COMMENTS_TABLE);
        if($column and is_array($column))
        {
            $comments->where($column)->orderBy('cmodified', 'DESC');
        }
        elseif($type and in_array($type, ['episodes', 'series', 'comments', 'celebrities', 'news']))
        {
            $comments  = DB::table(COMMENTS_TABLE)->where('ctype', $type)->orderBy('cstatus', 'ASC')->orderBy('cmodified', 'DESC');
        }
        else
        {
            $comments = DB::table(COMMENTS_TABLE)->orderBy('cstatus', 'ASC')->orderBy('cmodified', 'DESC');
        }

        if(request()->get('s'))
        {
            $comments->where('ccontent', 'like', '%'.request()->get('s').'%');
        }

        return $comments->paginate($this->paginate);
    }
    
    public function index_comments($action = '', Request $request)
    {
        if(!is_permission('comments')){
            return parent::admin_handle_permission('comments');
        }
        $data['page_class'] = 'comments';
        $data['sub_page_title'] = false;
        $action_title = [
            'unapproved' => admin_lang('unapproved'),
            'approved' => admin_lang('approved'),
        ];
        if($action and in_array($action, ['approved', 'unapproved']))
        {
            $data['page_title'] = admin_lang('comments').' : '.$action_title[$action];
            $data['sub_page_title'] = $action_title[$action];
            $action_where = [
                'unapproved' => '0',
                'approved' => '1',
            ];
            $comments   = $this->get_loop_comments(['cstatus' => $action_where[$action]]);
        }
        else
        {
            $data['page_title'] = admin_lang('comments');
            $comments   = $this->get_loop_comments();
        }
        if ($request->has('page') and $request->get('page') > $comments->lastPage()) {return redirect($comments->url($comments->lastPage()));}
        $data['comments'] = $comments;
        return get_admin_view('comments.index_comments', $data);
    }

    public function index_comments_ip($ip, Request $request)
    {
        if(!is_permission('comments')){
            return parent::admin_handle_permission('comments');
        }
        $data['page_class'] = 'comments';
        $data['page_title'] = admin_lang('comments');
        $data['sub_page_title'] = $ip;
        $comments   = $this->get_loop_comments(['ip' => $ip]);
        if ($request->has('page') and $request->get('page') > $comments->lastPage()) {return redirect($comments->url($comments->lastPage()));}
        $data['comments'] = $comments;
        return get_admin_view('comments.index_comments', $data);
    }
    
    public function index_comments_browser($browser, Request $request)
    {
        if(!is_permission('comments')){
            return parent::admin_handle_permission('comments');
        }
        $data['page_class'] = 'comments';
        $data['page_title'] = admin_lang('comments');
        $data['sub_page_title'] = $browser;
        $comments   = $this->get_loop_comments(['browserfamily' => $browser]);
        if ($request->has('page') and $request->get('page') > $comments->lastPage()) {return redirect($comments->url($comments->lastPage()));}
        $data['comments'] = $comments;
        return get_admin_view('comments.index_comments', $data);
    }
    
    public function index_comments_platfrom($platfrom, Request $request)
    {
        if(!is_permission('comments')){
            return parent::admin_handle_permission('comments');
        }
        $data['page_class'] = 'comments';
        $data['page_title'] = admin_lang('comments');
        $data['sub_page_title'] = $platfrom;
        $comments   = $this->get_loop_comments(['platformname' => $platfrom]);
        if ($request->has('page') and $request->get('page') > $comments->lastPage()) {return redirect($comments->url($comments->lastPage()));}
        $data['comments'] = $comments;
        return get_admin_view('comments.index_comments', $data);
    }
    
    public function index_editcomment($id, Request $request){
        if(!is_permission('commentstrash')){
            return parent::admin_handle_permission('comments');
        }
        $comment = DB::table(COMMENTS_TABLE)->where('cid', $id)->get();
        if($comment->count()){
            $data['page_class'] = 'comments';
            $data['page_title'] = admin_lang('comments').' :: '.admin_lang('edit').' #'.$id;
            $data['comment'] = $comment->first();
            $data['ccontent'] = str_replace("<br />", "\n", $data['comment']->ccontent);
            return get_admin_view('comments.index_editcomments', $data);
        }
        else {
            return redirect(get_admin_url('comments'));
        }
    }
    
    public function comments_sendform(Request $request){
        if(!is_permission('commentstrash')){
            return parent::admin_handle_permission('comments');
        }
        DB::table(COMMENTS_TABLE)->where(['cid' => $request->get('commentid')])->update([
            'cstatus'   => $request->get('cstatus'),
            'ccontent'  => safe_input($request->get('ccontent'))
        ]);
        return redirect()->back()->with("success", admin_lang('msg_comment_update'));
    }
    
    public function comments_actions(Request $request)
    {
        if(!is_permission('commentstrash')){
            return parent::admin_handle_permission('comments');
        }
        if ($request->has('query') && $request->get('query') == 'action') {
            $marks = $request->get('mark');
            if ($request->get('action') == 'approve' and is_array($marks)) {
                foreach ($marks as $markid) {
                    DB::table(COMMENTS_TABLE)->where(['cid' => $markid])->update(['cstatus' => '1']);
                }
                $success = admin_lang('msg_approved_selected');
            }
            elseif ($request->get('action') == 'unapprove' and is_array($marks)) {
                foreach ($marks as $markid) {
                    DB::table(COMMENTS_TABLE)->where(['cid' => $markid])->update(['cstatus' => '0']);
                }
                $success = admin_lang('msg_unapproved_selected');
            }
            elseif ($request->get('action') == 'delete' and is_array($marks)) {
                foreach ($marks as $markid) {
                    DB::table(COMMENTS_TABLE)->where(['cid' => $markid])->delete();
                }
                $success = admin_lang('msg_delete_selected');
            }
            else {
                $success = admin_lang('msg_noselectaction');
            }
            return redirect()->back()->with("success", $success);
        }
    }
    
    public function index_enablecomment($id)
    {
        if(!is_permission('commentstrash')){
            return parent::admin_handle_permission('comments');
        }
        DB::table(COMMENTS_TABLE)->where(['cid' => $id])->update(['cstatus' => '1']);
        return redirect()->back()->with("success", admin_lang('msg_comment_approved'));
    }
    
    public function index_disablecomment($id)
    {
        if(!is_permission('commentstrash')){
            return parent::admin_handle_permission('comments');
        }
        DB::table(COMMENTS_TABLE)->where(['cid' => $id])->update(['cstatus' => '0']);
        return redirect()->back()->with("success", admin_lang('msg_comment_unapproved'));
    }

    public function index_deletecomment($id, $token)
    {
        if(!is_permission('commentstrash')){
            return parent::admin_handle_permission('comments');
        }
        DB::table(COMMENTS_TABLE)->where(['cid' => $id])->delete();
        return redirect()->back()->with("success", admin_lang('msg_comment_delete'));
    }

}
