<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;
use App\Models\Deceased;
use App\Models\DeceasedAddress;
use App\Models\DeceasedInformer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Country;
use App\Models\State;
use App\Models\City;
use App\Models\Area;
use App\Models\Graveyard;
use App\Models\Utility;
use App\Models\Bookmaster;
use App\Models\DeceasedCorrection;
use App\Models\File;
use PHPUnit\Framework\Constraint\Count;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use App\Http\Requests\DeceasedRequest;

class DeceasedController extends Controller
{
    private $url_prefix;
    private $page_title;
    private $url_new;
    private $btn_new;
    private $paginate;
    private $filepath="public/files";

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->url_prefix   = 'Deceased';
        $this->page_title   = 'Deceased';
        $this->btn_new      = 'add_new';
        $this->url_new      = get_admin_url('deceasedadd');
        $this->paginate     = 5;
    }

    //deceased index
    public function index_deceased($type = '',Request $request)
    {
       
        $data['type']       = 'users';
        $data['page_class'] = 'deceased';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
        $filter_graveyard=Graveyard::with('deceased')->get();   
   
        $country=Country::where('country_code','=','IN')->first();
        $state = [];
        if(!empty($country))
            $state=State::select('id','state_name')->where('country_id','=',$country->id)->get();
        return get_admin_view('deceased.index_deceased',["data"=> $data,"states"=>$state,"filter_graveyard"=>$filter_graveyard]);
    }


       //deceased ajaxlist_table
       public function ajaxlist_deceased(Request $request){
       
        if($request->ajax())
        {
            $data['type']       = 'users';
            $data['page_class'] = 'deceased';
            $data['url_prefix'] = $this->url_prefix;
            $data['page_title'] = $this->page_title;
            $data['btn_new']    = $this->btn_new;
            $data['url_new']    = $this->url_new;
            $deceased=Deceased::orderBy('created_at', 'DESC');
        
            
          
                if($request->has('selected_state') and !empty($request->input('selected_state'))){
             $deceased=Deceased::with(["deceasedaddress"=>function($q) 
             {
                $q->where('id', 'name');
             }])
             ->whereHas('deceasedaddress', function ($query) use($request) {
                $query->when($request->selected_state, function ($q) use($request){ 
                     $q->where('state_id','=',$request->selected_state);
                });
                $query->when($request->selected_city, function ($q) use($request){ 
                    $q->where('city_id','=',$request->selected_city);
                });
               $query->when($request->selected_area, function ($q) use($request){ 
                        $q->where('area_id','=',$request->selected_area);
                });
                
            });
        }

             if($request->has('s')){
                $search = $request->input('s');
                $deceased->where(function ($query)use($search) {
                     $query->Where('deceased_name', 'LIKE','%' .$search. '%')
                          ->orWhere('deceased_surname','LIKE','%'.$search.'%')
                          ->orWhere('deceased_father_husband_name','LIKE','%'.$search.'%')
                          ->orWhere('deceased_name_gj', 'LIKE','%'.$search.'%')
                          ->orWhere('deceased_father_husband_name_gj', 'LIKE','%'.$search.'%')
                          ->orWhere('age', 'LIKE', '%'.$search.'%');
                });

               
             }

             if($request->has('search_date')){
               
                $search_date = $request->get('search_date');
                $deceased->where(function ($query)use($search_date) {
                    $query->where(DB::raw('Date(birth_date)'),'LIKE','%'.$search_date.'%')
                          ->orWhere('death_date', 'LIKE', '%'.$search_date.'%');
                });
                
            }
            if($request->has('informer_info') and !empty($request->input('informer_info'))){
                $informer=$request->input('informer_info');
                $deceased=Deceased::with(["deceasedinformer"=>function($q) 
                {
                 
                }])
                ->whereHas('deceasedinformer', function ($query) use($informer) {
                    $query->when($informer, function ($q) use($informer){ 
                         $q->where('informer_name','LIKE','%'.$informer.'%');
                            $q->orWhere('informer_mobileno','LIKE','%'.$informer.'%');
                        });
                   
                });    
        }

        if($request->has('entry_no') and !empty($request->input('entry_no'))){
            $entry_no=$request->input('entry_no');
    
            $deceased=Deceased::Where("entry_no",'LIKE','%'.$entry_no.'%');
         }
         
        if($request->has('selected_birth_date') and !empty($request->input('selected_birth_date'))){
            $selected_birth_date=$request->input('selected_birth_date');
    
            $deceased=Deceased::Where("birth_date",'LIKE','%'.$selected_birth_date.'%');
         }
         if($request->has('selected_gender') and !empty($request->input('selected_gender'))){
            $selected_gender=$request->input('selected_gender');
            $deceased=Deceased::Where("gender",'=',$selected_gender);
           
         }

         if($request->has('selected_graveyard') and !empty($request->input('selected_graveyard'))){
            $selected_graveyard=$request->input('selected_graveyard');
    
            $deceased=Deceased::Where("graveyard_id",'=',$selected_graveyard);
         }
         if($request->has('selected_place_death') and !empty($request->input('selected_place_death'))){
            $selected_place_death=$request->input('selected_place_death');
    
            $deceased=Deceased::Where("place_death",'=',$selected_place_death);
         }
         if($request->has('selected_reason_death') and !empty($request->input('selected_reason_death'))){
            $selected_reason_death=$request->input('selected_reason_death');

            $deceased=Deceased::Where("reason_death",'=',$selected_reason_death);
         }

    
    }
            $deceased = $deceased->paginate($this->paginate);
            
            if($request->has('page') and $request->get('page') > $deceased->lastPage()) {return redirect($deceased->url($deceased->lastPage()));}
            return get_admin_view('deceased.ajaxlist_deceased', ["data"=> $data,"deceaseds"=>$deceased]);
          
        }
        
    

            //deceased addform
    public function index_deceasedadd(Request $request)
    {
        $user = Auth::user();
        
        $data['page_title']         = "Add Deceased";
        $type                       = 'users';
        $data['type']               = $type;
        $data['page_class']         = $type;
        $data['action']             = 'addnew';
        $data['user_userlevel']     = $user->userlevel;
        $data['userlevel']          = 'user';
        $data['user_vip']           = '0';
        $data['user_viptime']       = '';
        $data['userid']             = '0';
        $data['user_status']        = '1';
        $data['username']           = '';
        $data['email']              = '';
        $data['admin_language']     = 'en';
        $data['user_permission']    = [];
        $graveyard=Graveyard::all();
        $country=Country::all()->sortBy("country_name");
    
        $charges_info=DB::table('options')->whereIn('option_name',['digging_charge',
        'graveyard_charge',
        'death_certificate_charge'])->get()->toArray();
        
        $charges_info['death_certificate_charge']=$charges_info[0];
        $charges_info['digging_charge']=$charges_info[1];
        $charges_info['graveyard_charge']=$charges_info[2];
        

        return get_admin_view('deceased.deceased_edit', ['data'=>$data,
        "graveyards"=>$graveyard,
        "countrys"=>$country,
        "charges_info"=>$charges_info]);
        
    }

            // add Deceased
            public function deceased_sendform(DeceasedRequest $request)
            {
                
                 $user = Auth::user();
                 $userid = $request->get('userid');
                 $deceased="";
                 $date=date('Y-m-d');

                 //files stored
                //  $identity_proof_file_name =$date.$request->file('identity_proof_file')->getClientOriginalName();
                //  $hospital_letter_file_name=$date.$request->file('hospital_letter_file')->getClientOriginalName();
                //  $request->file('identity_proof_file')->move($this->filepath,$identity_proof_file_name);
                //  $request->file('hospital_letter_file')->move($this->filepath,$hospital_letter_file_name);
               // $isfiles=request()->allFiles();
                if(!empty($isfiles)){
              //  $file=new File();
               // $file->uploadDeceasedFile($request);
                }

                try{

                    DB::beginTransaction();
                $deceased=Deceased::create(["graveyard_id"=>$request->input('graveyard_id'),
                "deceased_name"=>$request->input("deceased_name"),
                "deceased_name_gj"=>$request->input("deceased_name_gj"),
                "deceased_surname"=>$request->input("deceased_surname"),
                "deceased_surname_gj"=>$request->input("deceased_surname_gj"),
                "deceased_father_husband_name"=>$request->input("deceased_father_husband_name"),
                "deceased_father_husband_name_gj"=>$request->input("deceased_father_husband_name_gj"),
                "gender"=>$request->input("gender"),
                "birth_date"=>$request->input("birth_date"),
                "age"=>$request->input("age"),
                "photo"=>$request->input("photo"),
                "identity_proof"=>$request->input("identity_proof"),
                "place_death"=>$request->input("place_death"),
                "reason_death"=>$request->input("reason_death"),
                "is_postmortem"=>$request->input("is_postmortem"),
                "postmortem_fileno"=>$request->input("postmortem_fileno"),
                "postmortem_date"=>$request->input("postmortem_date"),
                "postmortem_file"=>$request->input("postmortem_file"),
                "entry_no"=>$request->input("entry_no"),
                "graveyard_book_no"=>$request->input('graveyard_book_no'),
                "graveyard_receipt_no"=>$request->input('graveyard_receipt_no'),
                "death_date"=>$request->input("death_date"),
                "digging_charge"=>$request->input("digging_charge"),
                "graveyard_charge"=>$request->input("graveyard_charge"),
                "death_certificate_charge"=>$request->input("death_certificate_charge") ]);

            
                $deceased_address=DeceasedAddress::create(["deceased_id"=>$deceased->id,
                "address1"=>$request->input("address1"),
                "address2"=>$request->input("address2"),
                "address3"=>$request->input("address3"),
                "country_id"=>$request->input("country_id"),
                "state_id"=>$request->input("state_id"),
                "city_id"=>$request->input("city_id"),
                "area_id"=>$request->input("area_id"),
                "pincode"=>$request->input("pincode")]);


                $deceased_informer=DeceasedInformer::create(["deceased_id"=>$deceased->id,
                "informer_name"=>$request->input("informer_name"),
                "informer_relation"=>$request->input("informer_relation"),
                "informer_mobileno"=>$request->input("informer_mobileno"),
                "informer_alt_mobileno"=>$request->input("informer_alt_mobileno"),
                "informer_address"=>$request->input("informer_address"),
                "informer_country_id"=>$request->input("informer_country_id"),
                "informer_state_id"=>$request->input("informer_state_id"),
                "informer_city_id"=>$request->input("informer_city_id"),
                "informer_area_id"=>$request->input("informer_area_id"),
                "informer_pincode"=>$request->input("informer_pincode")]);

              //  $file->uploadInformerFile($request);
              DB::commit();
          
              $request->session()->put('success', "Deceased Added successfully!");
              return redirect()->back();
           
               } catch(\Exception $exp) {
                   DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                   $request->session()->put('failure', "Deceased Not Addedd!");
                   return redirect()->back();
               }

             
            
            }


            public function ajax_state_get(Request $request){
               
                $state=Utility:: getstateByCountry($request->id);
                $options="<option value=''>Select State</option>";
                foreach($state as $key=>$val){
                 
                    if($val=='Gujarat'){
               
                    $options.="<option selected value=".$key.">".$val."</option>"; 
                    }else{
                        $options.="<option value=".$key.">".$val."</option>"; 
                    }       
                }
                return $options;
              
    
    
            }

            public function ajax_city_get(Request $request){
             
                $city=Utility::getcityByState($request->id);
                $options="<option value=''>Select City</option>";
                foreach($city as $key=>$val){
                    if($val=='Ahmedabad'){
                    $options.="<option selected value=".$key.">".$val."</option>";
                    }   
                    else{
                        $options.="<option selected value=".$key.">".$val."</option>";
                    }     
                }
                return $options;
              
    
    
            }

            public function ajax_area_get(Request $request){
         
                $area=Utility:: getareaByCity($request->id);
                $options="<option value=''>Select Area</option>";
                foreach($area as $key=>$val){
                   
                    $options.="<option value=".$key.">".$val."</option>";        
                }
                return $options;
              
    
    
            }
            public function ajax_book(Request $request){
               
            $id=$request->id;
                if($id=="" || empty($id)){
                 return response()->json([
                     'error'=> true,
                     'message' => "Graveyard Book Number is Blank"
                 ]);
                }
            else{

            $bookasc=Bookmaster::orderBy('book_no', 'ASC')->limit(1)->get();
            $bookdesc = Bookmaster::orderBy('book_no', 'DESC')->limit(1)->get();
          
            foreach($bookasc as $rangeasc){
                     $rangeasc=$rangeasc->book_no;            
                } 
            foreach($bookdesc as $rangedesc){
                    $rangedesc=$rangedesc->book_no;            
                } 
       
                $validator = Validator::make($request->all(), 
                    [
                        'id' => 'numeric|between:'.$rangeasc.','.$rangedesc.''
                    ]);

                if ($validator->fails())
                     {
                        return response()->json([
                            'error'=> true,
                            'message' => 'Graveyard Book Number Between '.$rangeasc.' To '.$rangedesc.' ' ]);
                      }

            
                $book=Deceased::where('graveyard_book_no', $id)->exists();
               //print_r($book);die;
                if($book){
                    return response()->json([
                        'error'=> true,
                        'message' => "Graveyard Book Number already Exist"
                    ]);

                }
                // else{

                    
                //     $bookmaster=Bookmaster::where('book_no', $id)->exists();
                //     if($bookmaster){
                //         return response()->json([
                //             'error'=> true,
                //             'message' => "Book Number already Exist"
                //         ]);
                //      }
                // }
              
              
                }
    
            }


            public function ajax_book_receipt(Request $request){
              
                $id=$request->id;
                $receipt_no=$request->receipt_no;
                if($receipt_no=="" || empty($receipt_no)){
                    return response()->json([
                        'error'=> true,
                        'message' => "Graveyard Book Receipt Number is Blank"
                    ]);
                   }
             else{
                $bookasc=Bookmaster::where('book_no', $id)->get();
                        
             foreach($bookasc as $rangeasclist){
                      $rangeasc=$rangeasclist->receipt_start;  
                      $rangedesc=$rangeasclist->receipt_end;          
                 } 
               
                 $validator = Validator::make($request->all(), 
                     [
                         'receipt_no' => 'numeric|between:'.$rangeasc.','.$rangedesc.''
                     ]);
 
                 if ($validator->fails())
                      {
                         return response()->json([
                             'error'=> true,
                             'message' => 'Graveyard Receipt Number Between '.$rangeasc.' To '.$rangedesc.' ' ]);
                       }
 
                
                 $book=Deceased::where('graveyard_receipt_no', $receipt_no)->exists();
                //print_r($book);die;
                 if($book){
                     return response()->json([
                         'error'=> true,
                         'message' => "Graveyard Receipt Number already Exist"
                     ]);
 
                 }
                }
                //  else{
 
                     
                //      $bookmaster=Bookmaster::where('receipt_no', $receipt_no)->exists();
                //      if($bookmaster){
                //          return response()->json([
                //              'error'=> true,
                //              'message' => "Book Receipt Number already Exist"
                //          ]);
                //       }
                //  }
               
               
     
     
             }






            public function deceased_profile($id =0, Request $request)
            {
          
                $curre_user = Auth::user();
               
                $user_id =  $curre_user->id;
           
                $deceased=Deceased::where('id',$id)->with(['deceasedaddress','deceasedinformer'])->first();
           
                $deceased_informer= $deceased['deceasedinformer'];
                $deceased_address=$deceased['deceasedaddress'];
               
                $country=Country::all();
                $state=State::where('country_id','=',$deceased_address->country_id)->get();
    
                $city=City::all();
                $area=Area::all();
                $country=Country::all();
                $graveyard=Graveyard::all();
             
                if($deceased){
                
                $getuser = User::find($user_id);
               
                if ($getuser->count()) {
                   
                    $type               = 'users';
                    $user               = $getuser->first();
                    $data['user']       = $user;
                    $data['type']       = $type;
                    $data['page_class'] = $type;
                    $data['action']     = 'update';
                    $data['page_title'] = 'Update Deceased';
                    $data['user_meta']  = query_user_meta($data['user']->id);
                
                    $datauser                   = $user;
                    $data['user_userlevel']     = $curre_user->userlevel;
                    $data['userlevel']          = $datauser->userlevel;
                    $data['type']               = $datauser->userlevel;
                    $data['page_class']         = $datauser->userlevel;
                    $data['action']             = 'update';
                    $data['userid']             = $datauser->id;
                    $data['username']           = $datauser->username;
                    $data['email']              = $datauser->email;
                    $data['user_status']        = $datauser->status;
                    $data['admin_language']     = get_user_meta('admin_language', $user_id, 'en');
                    $permission                 = maybe_unserialize(get_user_meta('permission', $user_id, []));
                    $data['user_permission']    = (is_array($permission))? $permission : [];
                    $countrys=Country::all();
                    $charges_info=DB::table('options')->whereIn('option_name',['digging_charge',
                    'graveyard_charge',
                    'death_certificate_charge'])->get()->toArray();
                    
                    $charges_info['death_certificate_charge']=$charges_info[0];
                    $charges_info['digging_charge']=$charges_info[1];
                    $charges_info['graveyard_charge']=$charges_info[2];

                    return get_admin_view('deceased.profile_deceased', ["data"=>$data,"deceased"=>$deceased,
                    "countrys"=>$country,"states"=>$state,"citys"=>$city,"graveyards"=>$graveyard,"deceasedaddress"=>$deceased_address,
                    "deceasedinformer"=>$deceased_informer,"areas"=>$area,"charges_info"=>$charges_info]);
                }
            }
        }


             // action delete deceased
       public function index_deletedeceased($id, $token ,Request $request)
       { 
          
         $deceased=Deceased::find($id);
         $deceasedname=$deceased->deceased_name;
         $deceased=$deceased->delete();
         if($deceased){
           
             $request->session()->put("success", "Deceased $deceasedname deleted Successfully!");
             return redirect()->back();
         }else{
           $request->session()->put("failure", "Deceased $deceasedname deleted");
           return redirect()->back();
         }
       }

            // actions of deceased
    public function deceased_actions(Request $request)
    { 
       
        $user = Auth::user();
    
        if($request->has('query') && $request->get('query') == 'action')
        {
          
             if($request->get('action') == 'update')
            {
               
                try{

                DB::beginTransaction();

               //update deceased
                $deceased=Deceased::find($request->input('id'));
                $deceased->deceased_surname = $request->input('deceased_surname');
                $deceased->deceased_name = $request->input('deceased_name');
                $deceased->deceased_father_husband_name = $request->input('deceased_father_husband_name');
                $deceased->deceased_surname_gj = $request->input('deceased_surname_gj');
                $deceased->deceased_name_gj = $request->input('deceased_name_gj');
                $deceased->deceased_father_husband_name_gj = $request->input('deceased_father_husband_name_gj');
                $deceased->gender = $request->input('gender');
                $deceased->birth_date = $request->input('birth_date');
                $deceased->age = $request->input('age');
                $deceased->photo = $request->input('photo');
                $deceased->identity_proof = $request->input('identity_proof');
                $deceased->identity_proof_file = $request->input('identity_proof_file');
                $deceased->entry_no = $request->input('entry_no');
                $deceased->graveyard_id = $request->input('graveyard_id');
                $deceased->graveyard_book_no = $request->input('graveyard_book_no');
                $deceased->graveyard_receipt_no = $request->input('graveyard_receipt_no');
                $deceased->graveyard_receipt = $request->input('graveyard_receipt');
                $deceased->place_death = $request->input('place_death');
                $deceased->graveyard_receipt = $request->input('graveyard_receipt');
                $deceased->reason_death = $request->input('reason_death');
                $deceased->hospital_letter_file = $request->input('hospital_letter_file');
                $deceased->is_postmortem = $request->input('is_postmortem');
                $deceased->postmortem_fileno = $request->input('postmortem_fileno');
                $deceased->postmortem_date = $request->input('postmortem_date');
                $deceased->postmortem_file = $request->input('postmortem_file');
                $deceased->death_date = $request->input('death_date');
                $deceased->dafan_date = $request->input('dafan_date');
                $deceased->digging_charge = $request->input('digging_charge');
                $deceased->graveyard_charge = $request->input('graveyard_charge');
                $deceased->death_certificate_charge = $request->input('death_certificate_charge');
                $deceased->save();

                //update deceased Address
                $deceased_address=DeceasedAddress::where('deceased_id','=',$request->input('id'))->first();
                $deceased_address->address1=$request->input("address1");
                $deceased_address->address2=$request->input("address2");
                $deceased_address->address3=$request->input("address3");
                $deceased_address->country_id=$request->input("country_id");
                $deceased_address->state_id=$request->input("state_id");
                $deceased_address->city_id=$request->input("city_id");
                $deceased_address->area_id=$request->input("area_id");
                $deceased_address->pincode=$request->input("pincode");
                $deceased_address->save();

                //update informer address
                $deceased_informer=DeceasedInformer::where('deceased_id','=',$request->input('id'))->first();
                $deceased_informer->informer_name=$request->input("informer_name");
                $deceased_informer->informer_relation=$request->input("informer_relation");
                $deceased_informer->informer_mobileno=$request->input("informer_mobileno");
                $deceased_informer->informer_alt_mobileno=$request->input("informer_alt_mobileno");
                $deceased_informer->informer_address=$request->input("informer_address");
                $deceased_informer->informer_country_id=$request->input("informer_country_id");
                $deceased_informer->informer_state_id=$request->input("informer_state_id");
                $deceased_informer->informer_city_id=$request->input("informer_city_id");
                $deceased_informer->informer_area_id=$request->input("informer_area_id");
                $deceased_informer->informer_pincode=$request->input("informer_pincode");
                $deceased_informer->save();
                
                 DB::commit();
                 $request->session()->put('success', "Deceased Updated successfully!");
                 return redirect()->back();
              
                  } catch(\Exception $exp) {
                      DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                      $request->session()->put('failure', "Deceased Not Updated successfully!");
                      return redirect()->back();
                  }
            }

            else if($request->get('action') == 'correction')
            {

                try{
                    DB::beginTransaction();
                    $deceased=Deceased::find($request->input('deceased_id'));
                    $deceased_address=DeceasedAddress::where('deceased_id','=',$request->input('deceased_id'))->first();
                
               $correction_dec= DeceasedCorrection::create([
                    "deceased_id"=>$request->input("deceased_id"),
                    "deceased_surname"=>$deceased->deceased_surname,
                    "deceased_name"=>$deceased->deceased_name,
                    "deceased_father_husband_name"=>$deceased->deceased_father_husband_name,
                    "deceased_surname_gj"=>$deceased->deceased_surname_gj,
                    "deceased_name_gj"=>$deceased->deceased_name_gj,
                    "deceased_father_husband_name_gj"=>$deceased->deceased_father_husband_name_gj,
                    "birth_date"=>$deceased->birth_date,
                    "age"=>$deceased->age,
                    "identity_proof"=>$deceased->identity_proof,
                    "identity_proof_file"=>$deceased->identity_proof_file,
                    "death_date"=>$deceased->death_date,
                    "dafan_date"=>$deceased->dafan_date,
                    "reason_death"=>$deceased->reason_death,
                    "place_death"=>$deceased->place_death,
                    "address1"=>$deceased_address->address1,
                    "address2"=>$deceased_address->address2,
                    "address3"=>$deceased_address->address3,
                    "country_id"=>$deceased_address->country_id,
                    "state_id"=>$deceased_address->state_id,
                    "city_id"=>$deceased_address->city_id,
                    "area_id"=>$deceased_address->area_id,
                    "pincode"=>$deceased_address->pincode,
                    "created_by"=>$user->id,
                    "updated_by"=>$user->id,
                ]);

       
                //update deceased Info
                $deceased=Deceased::find($request->input('deceased_id'));
                $deceased->deceased_surname = $request->input('deceased_surname');
                $deceased->deceased_name = $request->input('deceased_name');
                $deceased->deceased_father_husband_name = $request->input('deceased_father_husband_name');
                $deceased->deceased_surname_gj = $request->input('deceased_surname_gj');
                $deceased->deceased_name_gj = $request->input('deceased_name_gj');
                $deceased->deceased_father_husband_name_gj = $request->input('deceased_father_husband_name_gj');
                $deceased->birth_date = $request->input('birth_date');
                $deceased->age = $request->input('age');
                $deceased->identity_proof = $request->input('identity_proof');
                $deceased->identity_proof_file = $request->input('identity_proof_file');
                $deceased->death_date = $request->input('death_date');
                $deceased->dafan_date = $request->input('dafan_date');
                $deceased->place_death = $request->input('place_death');
                $deceased->reason_death = $request->input('reason_death');
                $deceased->save();


                    //update deceased Address 
                $deceased_address=DeceasedAddress::where('deceased_id','=',$request->input('deceased_id'))->first();
                $deceased_address->address1=$request->input("address1");
                $deceased_address->address2=$request->input("address2");
                $deceased_address->address3=$request->input("address3");    
                $deceased_address->country_id=$request->input("country_id");
                $deceased_address->state_id=$request->input("state_id");
                $deceased_address->city_id=$request->input("city_id");
                $deceased_address->area_id=$request->input("area_id");
                $deceased_address->pincode=$request->input("pincode");
                $deceased_address->save();








                DB::commit();
                $request->session()->put('success', "Correction made successfully!");
                return redirect()->back();

             } catch(\Exception $exp) {
                DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                $request->session()->put('failure', "Correction Failed pleasey try again!");
                return redirect()->back();
                }
                   

            }

        else{
      
            $marks = $request->get('mark');
          
             if(empty($marks)){
                return redirect()->back();
             }
            
           
            if($request->get('action') == 'delete' and is_array($marks))
            {
                try{
                    DB::beginTransaction();
                foreach($marks as $markid)
                   {
                 
                   //Delete deceased
                    $deceased=Deceased::find($markid)->delete();

                    //delete deceased Address
                    $deceased_address=DeceasedAddress::where('deceased_id','=',$markid)->delete();
    
                    //delete informer address
                    $deceased_informer=DeceasedInformer::where('deceased_id','=',$markid)->delete();
                    
                     DB::commit();
                  
                  
                      }
                      $request->session()->put('success', "Deceased Deleted successfully!");
                      return redirect()->back();
                    } 
                      catch(\Exception $exp) {
                          DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                          $request->session()->put('failure', "Deceased Not Deleted successfully!");
                          return redirect()->back();
                      }
                }


                }
            
            }       
        }

        public function view_deceased($id,Request $request){
       
        $user = Auth::user();
        $data['page_title']         = "View Deceased";
        $type                       = 'users';
        $data['type']               = $type;
        $data['page_class']         = $type;
        $data['user_userlevel']     = $user->userlevel;
        $data['userlevel']          = 'user';
        $data['user_vip']           = '0';
        $data['user_viptime']       = '';
        $data['userid']             = '0';
        $data['user_status']        = '1';
        $data['username']           = '';
        $data['email']              = '';
        $data['admin_language']     = 'en';
        $data['user_permission']    = [];
              
                $deceased=Deceased::where('id',$id)->with(['deceasedaddress','deceasedinformer'])->first();
                $deceased['deceased_address']=$deceased['deceasedaddress'];
                $deceased['area_info']=Area::where('id', $deceased['deceased_address']->area_id)->first();
                $deceased['city_info']=  $deceased['area_info']->city;
                $deceased['state_info']= $deceased['city_info']->state;
                $deceased['country_info']=$deceased['state_info']->country;
                $deceased['informer_info']=$deceased['deceasedinformer'];
              
                $deceased['informer_area_info']=Area::where('id', $deceased['informer_info']->informer_area_id)->first();
                $deceased['informer_city_info']=  $deceased['informer_area_info']->city;
                $deceased['informer_state_info']= $deceased['informer_city_info']->state;
                $deceased['informer_country_info']=$deceased['informer_state_info']->country;
                $deceased['garveyard_info']=$deceased->graveyard;
              
                if(empty($deceased)){
                    return redirect()->back();
                }
                return get_admin_view('deceased.deceased_edit', ['data'=>$data,"deceased_view"=>true,
                'deceased'=>$deceased]);   
            }

            public function deceased_pdf($id,$lang,Request $request){
              
                $deceased=Deceased::where('id',$id)->with(['deceasedaddress','deceasedinformer'])->first();
                $deceased['deceased_address']=$deceased['deceasedaddress'];
                $deceased['area_info']=Area::where('id', $deceased['deceased_address']->area_id)->first();
                $deceased['city_info']=  $deceased['area_info']->city;
                $deceased['state_info']= $deceased['city_info']->state;
                $deceased['country_info']=$deceased['state_info']->country;
                $deceased['informer_info']=$deceased['deceasedinformer'];
              
                $deceased['informer_area_info']=Area::where('id', $deceased['informer_info']->informer_area_id)->first();
                $deceased['informer_city_info']=  $deceased['informer_area_info']->city;
                $deceased['informer_state_info']= $deceased['informer_city_info']->state;
                $deceased['informer_country_info']=$deceased['informer_state_info']->country;
                $deceased['garveyard_info']=$deceased->graveyard;   
                $deceased['lang']=$lang;
                return redirect()->route('deceased_pdf')->with(["deceased"=>$deceased]);
        
            }

            public function deceased_correction($id=""){

                $user = Auth::user();
                $data['page_title']         = "Deceased Correction";
                $type                       = 'users';
                $data['type']               = $type;
                $data['page_class']         = $type;
                $data['action']             = 'correction';
                $data['user_userlevel']     = $user->userlevel;
                $data['userlevel']          = 'user';
                $data['user_vip']           = '0';
                $data['user_viptime']       = '';
                $data['userid']             = '0';
                $data['user_status']        = '1';
                $data['username']           = '';
                $data['email']              = '';
                $data['admin_language']     = 'en';
                $data['user_permission']    = [];
                $deceased=Deceased::where('id',$id)->with(['deceasedaddress'])->first();
                if(empty($deceased)){
                    return redirect()->back();
                }
                $deceased['deceased_address']=$deceased['deceasedaddress'];
                $deceased['area_info']=Area::where('id', $deceased['deceased_address']->area_id)->first();
                $deceased['city_info']=  $deceased['area_info']->city;
                $deceased['state_info']= $deceased['city_info']->state;
                $deceased['country_info']=$deceased['state_info']->country;
              
                    $deceased['state']=State::all();
                    $deceased['city']=City::all();
                    $deceased['area']=Area::all();
                    $deceased['country']=Country::all();

                return get_admin_view('deceased.deceased_correction', ['data'=>$data,
                "deceased_view"=>true,  
                'deceased'=>$deceased]);                
               
            }

            public function deceased_correctionlists($id=""){
             
                $user = Auth::user();
                $data['page_title']         = "Updated Entry";
                $type                       = 'users';
                $data['type']               = $type;
                $data['page_class']         = $type;
                $data['user_userlevel']     = $user->userlevel;
                $data['action']             = '';
                $data['userlevel']          = 'user';
                $data['user_vip']           = '0';
                $data['user_viptime']       = '';
                $data['userid']             = '0';
                $data['user_status']        = '1';
                $data['username']           = '';
                $data['email']              = '';
                $data['admin_language']     = 'en';
                $data['user_permission']    = [];
              
        
                $deceased=Deceased::where('id',$id)->with(['deceasedaddress','deceasedinformer'])->first();
                
                if(empty($deceased)){
                    return redirect()->back();
                }
                $deceased['deceased_address']=$deceased['deceasedaddress'];
                $deceased['informer_info']=$deceased['deceasedinformer'];
                $deceased['area_info']=Area::where('id', $deceased['deceased_address']->area_id)->first();
                $deceased['city_info']=  $deceased['area_info']->city;
                $deceased['state_info']= $deceased['city_info']->state;
                $deceased['country_info']=$deceased['state_info']->country;
                $deceased['garveyard_info']=$deceased->graveyard;

                $deceased['informer_area_info']=Area::where('id', $deceased['informer_info']->informer_area_id)->first();
                $deceased['informer_city_info']=  $deceased['informer_area_info']->city;
                $deceased['informer_state_info']= $deceased['informer_city_info']->state;
                $deceased['informer_country_info']=$deceased['informer_state_info']->country;
                
                $old_deceased=DeceasedCorrection::where('deceased_id',$id)->get();
                
                return get_admin_view('deceased.deceased_corrections', ['data'=>$data,'deceased'=>$deceased,"old_deceaseds"=>$old_deceased]);
               

            }
        

}