<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Dashboard;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ExtensionsController extends Controller
{
    public $categories = array('count' => 0);
    public $extensionscount = 0;
    private $available = array();
    private $activated = array();
    private $get_extensions;
    private $headers = array(
		'name'        => 'Extension Name',
		'website'     => 'Extension URI',
        'license'     => 'License',
		'version'     => 'Version',
		'requires'    => 'Requires',
		'description' => 'Description',
		'author'      => 'Author',
		'authoruri'   => 'Author URI',
		'category'    => 'Category',
    );
    
    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->paginate = 20;
    }

    public function index_extensions(Request $request)
    {
        if(!is_permission('extensions')){
            return parent::admin_handle_permission('extensions');
        }
        $data['page_title'] = admin_lang('extensions');
        $data['page_class'] = 'extensions';
        $data['fetched_extensions'] = $this->fetch();
        return get_admin_view('extensions.index_extensions', $data);
    }

    public function load()
    {
		return $this->activated = (is_serialized(get_option('start_extensions')))? maybe_unserialize(get_option('start_extensions')) : array() ;
	}

    public function fetch()
    {
		$extensions = glob( app_path('Extensions') . '/*', GLOB_ONLYDIR );
        if ( ! empty( $extensions ) ){
			$this->load();
        }
		foreach ( $extensions as $extension ){
			$slug = basename( $extension );
			$file = $extension . '/extension.php';
			if ( file_exists( $file ) && array_key_exists($slug, $this->get_extensions)){
                $this->extensionscount ++;
                $exdata = $this->get_extensions[$slug];
				$headers                        = $this->get_file_data( $file, $this->headers );
                $headers['current_version']     = $exdata['version'];
                $headers['current_requires']    = $exdata['requires'];
                $headers['current_license']     = $exdata['license'];
                $headers['compatible']          = version_compare( $headers['requires'], SCRIPT_VERSION, '<=' );
				$headers['activated']           = $headers['compatible'] && in_array( $slug, $this->activated );
				$headers['basename']            = $slug . '/extension.php';
                $headers['screenshot']          = url(env('APP_ROOT_PAHT').'/app/Extensions/' . $slug . '/screenshot.png');
				$this->available[ $slug ]       = $headers;
            }
        }
		return $this->available;
    }
    
    public function get_file_data( $file, $default_headers)
    {
        $fp        = fopen( $file, 'r' );
        $file_data = fread( $fp, 8192 );
        fclose( $fp );
        $file_data = str_replace( "\r", "\n", $file_data );
        $all_headers = $default_headers;
        foreach ( $all_headers as $field => $regex ) {
            if ( preg_match( '/^[ \t\/*#@]*' . preg_quote( $regex, '/' ) . ':(.*)$/mi', $file_data, $match ) && $match[1] ){
                $all_headers[ $field ] = cleanup_header_comment( $match[1] );
            }
            else {
                $all_headers[ $field ] = '';
            }
        }
        return $all_headers;
    }

    public function index_extension_action($action , $extension, $token, Request $request)
    {
        if(!is_permission('extensions')){
            return parent::admin_handle_permission('extensions');
        }
        $start_extensions = maybe_unserialize(get_option('start_extensions', []));
        if($action == 'activate'){
            if($extension_data['license'] == 'paid'){
                return redirect(get_admin_url('extensions/license/'.$extension));
            }
            else {
                $activated = array_unique( array_merge($start_extensions , (array) $extension ) );
                update_option('start_extensions', maybe_serialize($activated));
                return redirect(get_admin_url('extensions'))->with("success", admin_lang('msg_extension_enable'));
            }            
        }
        elseif($action == 'deactivate'){
            $activated = array_diff( $start_extensions, (array) $extension );
            update_option('start_extensions', maybe_serialize($activated));
            return redirect(get_admin_url('extensions'))->with("success", admin_lang('msg_extension_disable'));
        }
        else {
            return redirect(get_admin_url('extensions'));
        }
    }
    
    public function index_extension_license($extension, Request $request)
    {

    }

    public function index_extension_verify(Request $request){
        
    }
}
