<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\State;
use App\Models\Country;
use PHPUnit\Framework\Constraint\Count;
use Illuminate\Support\Facades\Session;
use App\Http\Requests\StoreStateRequest;
use App\Http\Requests\UpdateStateRequest;

class StateController extends Controller
{
    private $url_prefix;
    private $page_title;
    private $url_new;
    private $btn_new;
    private $paginate;

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->url_prefix   = 'State';
        $this->page_title   = 'State';
        $this->btn_new      = 'add_new';
        $this->url_new      = get_admin_url('stateadd');
        $this->paginate     = 5;
    }
    // index state
    public function index_state($type = '',Request $request)
    {
    
        $data['type']       = 'users';
        $data['page_class'] = 'state';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;
       
        return get_admin_view('state.index_state',["data"=> $data]);
    }

    //state ajaxlist_table
    public function ajaxlist_state(Request $request){
        if($request->ajax())
        {
            $data['type']       = 'users';
            $data['page_class'] = 'State';
            $data['url_prefix'] = $this->url_prefix;
            $data['page_title'] = $this->page_title;
            $data['btn_new']    = $this->btn_new;
            $data['url_new']    = $this->url_new;


         
            $state=State::orderBy('created_at', 'DESC');
            if($request->get('s')){
                $search = $request->get('s');
               
                $state->orWhere('state_name', 'LIKE', "%{$search}%");
                $state->orWhere('state_name_gj', 'LIKE', "%{$search}%");
                $state->orWhere('id', 'LIKE', "%{$search}%");
                $state->orWhere('created_at', 'LIKE', "%{$search}%");
                $state->orWhere(function ($query) use ($search) {
                    $query->whereHas('country', function ($q) use ($search) {
                        $q->where('country_name', 'LIKE', '%' . $search . '%');
                    });
                });
            }
            $state = $state->paginate($this->paginate);
            if($request->has('page') and $request->get('page') > $state->lastPage()) {return redirect($state->url($state->lastPage()));}
            return get_admin_view('state.ajaxlist_state', ["data"=> $data,'state'=>$state]);
        }
        
       }
           //state addform
    public function index_stateadd(Request $request)
    {
        $user = Auth::user();
        
        $data['page_title']         = "Add State";
        $type                       = 'users';
        $data['type']               = $type;
        $data['page_class']         = $type;
        $data['action']             = 'addnew';
        $data['user_userlevel']     = $user->userlevel;
        $data['userlevel']          = 'user';
        $data['user_vip']           = '0';
        $data['user_viptime']       = '';
        $data['userid']             = '0';
        $data['user_status']        = '1';
        $data['username']           = '';
        $data['email']              = '';
        $data['admin_language']     = 'en';
        $data['user_permission']    = [];

        $countrys=Country::all();
      
        return get_admin_view('state.state_edit', ['data'=>$data,"countrys"=>$countrys]);
    }

        // add state
        public function state_sendform(Request $request)
        {
           
            $user = Auth::user();
        
            $userid = $request->get('userid');
            $state=State::create(["state_name"=>$request->input('state_name'),
            "state_name_gj"=>$request->input("state_name_gj"),
            "country_id"=>$request->input('country_id')]);
            if($state){
                return redirect()->back()->with('success','State '.$request->input('state_name') . ' added Successfully!');
              }
              else{
                return redirect()->back()->with('failure', "State ".$request->input('state_name') . ' Not added');
              }
         
        
        }
    
        public function state_profile($id =0, Request $request)
        {
       
            $curre_user = Auth::user();
           
            $user_id =  $curre_user->id;
       
            $state=State::find($id);
         
            if($state){
            
            $getuser = User::find($user_id);
           
            if ($getuser->count()) {
               
                $type               = 'users';
                $user               = $getuser->first();
                $data['user']       = $user;
                $data['type']       = $type;
                $data['page_class'] = $type;
                $data['action']     = 'update';
                $data['page_title'] = 'Update State';
                $data['user_meta']  = query_user_meta($data['user']->id);
            
                $datauser                   = $user;
                $data['user_userlevel']     = $curre_user->userlevel;
                $data['userlevel']          = $datauser->userlevel;
                $data['type']               = $datauser->userlevel;
                $data['page_class']         = $datauser->userlevel;
                $data['action']             = 'update';
                $data['userid']             = $datauser->id;
                $data['username']           = $datauser->username;
                $data['email']              = $datauser->email;
                $data['user_status']        = $datauser->status;
                $data['admin_language']     = get_user_meta('admin_language', $user_id, 'en');
                $permission                 = maybe_unserialize(get_user_meta('permission', $user_id, []));
                $data['user_permission']    = (is_array($permission))? $permission : [];
                $countrys=Country::all();
                return get_admin_view('state.profile_state', ["data"=>$data,"state"=>$state,"countrys"=>$countrys]);
            }
        }
        }
              // actions of state

    public function state_actions(Request $request)
    { 
     

        if($request->has('query') && $request->get('query') == 'action')
        {
          
             if($request->get('action') == 'update')
            {
               
                $state=State::find($request->input('id'));
                $state->country_id = $request->input('country_id');
                $state->state_name = $request->input('state_name');
                $state->state_name_gj = $request->input('state_name_gj');
                if($state->save()){
                  
                    $request->session()->put('success', "State Updated successfully!");
                    return redirect()->back();
                }else{
                    $request->session()->put('failure', "State Not Updated!");
                    return redirect()->back();
                }
            }
     else{
      
            $marks = $request->get('mark');
             if(empty($marks)){
                return redirect()->back();
             }
            
             $faileditem=0;
            if($request->get('action') == 'delete' and is_array($marks))
            {
             
                foreach($marks as $markid)
                {
                    $state=State::find($markid);
                    $success= $state->delete();
                   if(empty($success)){
                    $faileditem= $faileditem+1;
                   }
                }
                if($faileditem==0){
                    $request->session()->put('success', "Selected State Items are Deleted Successfully!");
                    return redirect()->back();
                }
                else if($faileditem!=0){
                    $request->session()->put('failure', "Selected State Items are deleted except $faileditem 
                    State");
                }
                else{
                    $request->session()->put('failure', "Selected State Items are not deleted");
                    return redirect()->back();
                }
            }       
        }
    }
    }

      // action delete state
      public function index_deletestate($id, $token ,Request $request)
      { 
    
        $state=State::find($id);
        $statename=$state->state_name;
        $state=$state->delete();
        if($state){
            $request->session()->put("success", "State $statename deleted Successfully!");
            return redirect()->back();
        }else{
          $request->session()->put("failure", "State $statename deleted");
          return redirect()->back();
        }
      }

    }
     